/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.util.Map;
import java.util.function.Predicate;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeUtils;

public class AgentPropertyPredicate
implements Predicate<AgentInfo> {
    private final Map<String, String> properties;

    public AgentPropertyPredicate(String propertiesStr) {
        this.properties = (Map)InputConversionEngine.convertArgToType((String)propertiesStr, Map.class);
    }

    public AgentPropertyPredicate(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public boolean test(AgentInfo agent) {
        for (Map.Entry<String, String> e : this.properties.entrySet()) {
            String property = e.getKey();
            String propertyValue = e.getValue();
            if (propertyValue == null || propertyValue.isEmpty() || propertyValue.equals(agent.getAgentProperty(property))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return TypeUtils.stringify(this.properties);
    }
}

