/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.alerts;

import org.lsst.ccs.bus.data.Alert;

public enum InfrastructureAlert {
    PERIODIC_TASK_BEHIND("PeriodicTaskBehind", "Alert raised when a periodic task falls behind."),
    PERIODIC_TASK_FAILURE("PeriodicTaskFailure", "Alert raised when periodic tasks have failures (exceptions) during execution. At ALARM level the task execution is terminated.");

    private final String id;
    private final String description;

    private InfrastructureAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public String getAlertId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public Alert getAlert() {
        return new Alert(this.id, this.description);
    }
}

