/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ps;

import java.io.IOException;
import java.io.PrintStream;
import org.freehep.graphicsbase.util.ScientificFormat;
import org.freehep.graphicsio.QuadToCubicPathConstructor;

public class PSPathConstructor
extends QuadToCubicPathConstructor {
    private PrintStream os;
    private boolean intPrecision;
    private String moveto;
    private String lineto;
    private String curveto;
    private String close;
    private ScientificFormat scientific = new ScientificFormat(6, 9, false);

    public PSPathConstructor(PrintStream os, boolean useProlog, boolean intPrecision) {
        this.os = os;
        this.intPrecision = intPrecision;
        if (useProlog) {
            this.moveto = "m";
            this.lineto = "l";
            this.curveto = "c";
            this.close = "h";
        } else {
            this.moveto = "moveto";
            this.lineto = "lineto";
            this.curveto = "curveto";
            this.close = "closepath";
        }
    }

    public void move(double x, double y) throws IOException {
        this.os.println(this.fixedPrecision(x) + " " + this.fixedPrecision(y) + " " + this.moveto);
        super.move(x, y);
    }

    public void line(double x, double y) throws IOException {
        this.os.println(this.fixedPrecision(x) + " " + this.fixedPrecision(y) + " " + this.lineto);
        super.line(x, y);
    }

    public void cubic(double x1, double y1, double x2, double y2, double x3, double y3) throws IOException {
        this.os.println(this.fixedPrecision(x1) + " " + this.fixedPrecision(y1) + " " + this.fixedPrecision(x2) + " " + this.fixedPrecision(y2) + " " + this.fixedPrecision(x3) + " " + this.fixedPrecision(y3) + "  " + this.curveto);
        super.cubic(x1, y1, x2, y2, x3, y3);
    }

    public void closePath(double x0, double y0) throws IOException {
        this.os.println(this.close);
        super.closePath(x0, y0);
    }

    protected String fixedPrecision(double d) {
        if (this.intPrecision) {
            return Integer.toString((int)d);
        }
        return this.scientific.format(d);
    }
}

