/*
 * Decompiled with CFR 0.152.
 */
package com.wittams.gritty.swing;

import com.wittams.gritty.BackBuffer;
import com.wittams.gritty.Emulator;
import com.wittams.gritty.RequestOrigin;
import com.wittams.gritty.ResizePanelDelegate;
import com.wittams.gritty.ScrollBuffer;
import com.wittams.gritty.SelectionRunConsumer;
import com.wittams.gritty.Style;
import com.wittams.gritty.StyleState;
import com.wittams.gritty.StyledRunConsumer;
import com.wittams.gritty.TerminalDisplay;
import com.wittams.gritty.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class TermPanel
extends JComponent
implements TerminalDisplay,
ClipboardOwner,
StyledRunConsumer {
    private static final Logger logger = Logger.getLogger(TermPanel.class);
    private static final long serialVersionUID = -1048763516632093014L;
    private static final double FPS = 20.0;
    private BufferedImage img;
    private Graphics2D gfx;
    private final Component termComponent = this;
    private Font normalFont;
    private Font boldFont;
    private int descent = 0;
    private int lineSpace = 0;
    Dimension charSize = new Dimension();
    Dimension termSize = new Dimension(80, 24);
    protected Point cursor = new Point();
    private boolean antialiasing = true;
    private Emulator emulator = null;
    protected Point selectionStart;
    protected Point selectionEnd;
    protected boolean selectionInProgress;
    private Clipboard clipBoard;
    private ResizePanelDelegate resizePanelDelegate;
    private final BackBuffer backBuffer;
    private final ScrollBuffer scrollBuffer;
    private final StyleState styleState;
    private final BoundedRangeModel brm = new DefaultBoundedRangeModel(0, 80, 0, 80);
    protected int clientScrollOrigin;
    protected volatile int newClientScrollOrigin;
    protected volatile boolean shouldDrawCursor;
    private KeyListener keyHandler;
    int noDamage = 0;
    int framesSkipped = 0;
    private boolean cursorChanged;
    final PendingScrolls pendingScrolls = new PendingScrolls();

    public TermPanel(BackBuffer backBuffer, ScrollBuffer scrollBuffer, StyleState styleState) {
        this.scrollBuffer = scrollBuffer;
        this.backBuffer = backBuffer;
        this.styleState = styleState;
        this.brm.setRangeProperties(0, this.termSize.height, -scrollBuffer.getLineCount(), this.termSize.height, false);
        this.normalFont = Font.decode("Monospaced-14");
        this.boldFont = this.normalFont.deriveFont(1);
        this.establishFontMetrics();
        this.setUpImages();
        this.setUpClipboard();
        this.setAntiAliasing(this.antialiasing);
        this.setPreferredSize(new Dimension(this.getPixelWidth(), this.getPixelHeight()));
        this.setFocusable(true);
        this.enableInputMethods(true);
        this.setFocusTraversalKeysEnabled(false);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Point charCoords = TermPanel.this.panelToCharCoords(e.getPoint());
                if (!TermPanel.this.selectionInProgress) {
                    TermPanel.this.selectionStart = new Point(charCoords);
                    TermPanel.this.selectionInProgress = true;
                }
                TermPanel.this.repaint();
                TermPanel.this.selectionEnd = charCoords;
                TermPanel.this.selectionEnd.x = Math.min(TermPanel.this.selectionEnd.x + 1, TermPanel.this.termSize.width);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                TermPanel.this.selectionInProgress = false;
                if (TermPanel.this.selectionStart != null && TermPanel.this.selectionEnd != null) {
                    TermPanel.this.copySelection(TermPanel.this.selectionStart, TermPanel.this.selectionEnd);
                }
                TermPanel.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TermPanel.this.requestFocusInWindow();
                TermPanel.this.selectionStart = null;
                TermPanel.this.selectionEnd = null;
                if (e.getButton() == 3) {
                    TermPanel.this.pasteSelection();
                }
                TermPanel.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TermPanel.this.sizeTerminalFromComponent();
            }
        });
        this.brm.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TermPanel.this.newClientScrollOrigin = TermPanel.this.brm.getValue();
            }
        });
        Timer redrawTimer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TermPanel.this.redrawFromDamage();
            }
        });
        this.setDoubleBuffered(true);
        redrawTimer.start();
        this.repaint();
    }

    private Point panelToCharCoords(Point p) {
        return new Point(p.x / this.charSize.width, p.y / this.charSize.height + this.clientScrollOrigin);
    }

    void setUpClipboard() {
        this.clipBoard = Toolkit.getDefaultToolkit().getSystemSelection();
        if (this.clipBoard == null) {
            this.clipBoard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
    }

    private void copySelection(Point selectionStart, Point selectionEnd) {
        Point bottom;
        Point top;
        if (selectionStart == null || selectionEnd == null) {
            return;
        }
        if (selectionStart.y == selectionEnd.y) {
            top = selectionStart.x < selectionEnd.x ? selectionStart : selectionEnd;
            bottom = selectionStart.x >= selectionEnd.x ? selectionStart : selectionEnd;
        } else {
            top = selectionStart.y < selectionEnd.y ? selectionStart : selectionEnd;
            bottom = selectionStart.y > selectionEnd.y ? selectionStart : selectionEnd;
        }
        StringBuffer selection = new StringBuffer();
        if (top.y < 0) {
            Point scrollEnd = bottom.y >= 0 ? new Point(this.termSize.width, -1) : bottom;
            this.scrollBuffer.pumpRuns(top.y, scrollEnd.y - top.y, new SelectionRunConsumer(selection, top, scrollEnd));
        }
        if (bottom.y >= 0) {
            Point backBegin = top.y < 0 ? new Point(0, 0) : top;
            this.backBuffer.pumpRuns(0, backBegin.y, this.termSize.width, bottom.y - backBegin.y + 1, new SelectionRunConsumer(selection, backBegin, bottom));
        }
        if (selection.length() == 0) {
            return;
        }
        try {
            this.clipBoard.setContents(new StringSelection(selection.toString()), this);
        }
        catch (IllegalStateException e) {
            logger.error((Object)"Could not set clipboard:", (Throwable)e);
        }
    }

    void pasteSelection() {
        try {
            String selection = (String)this.clipBoard.getData(DataFlavor.stringFlavor);
            this.emulator.sendBytes(selection.getBytes());
        }
        catch (UnsupportedFlavorException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private void setUpImages() {
        BufferedImage oldImage = this.img;
        this.img = new BufferedImage(this.getPixelWidth(), this.getPixelHeight(), 1);
        this.gfx = this.img.createGraphics();
        this.gfx.fillRect(0, 0, this.getPixelWidth(), this.getPixelHeight());
        if (oldImage != null) {
            this.gfx.drawImage(oldImage, 0, this.img.getHeight() - oldImage.getHeight(), oldImage.getWidth(), oldImage.getHeight(), this.termComponent);
        }
    }

    private void sizeTerminalFromComponent() {
        if (this.emulator != null) {
            int newWidth = this.getWidth() / this.charSize.width;
            int newHeight = this.getHeight() / this.charSize.height;
            Dimension newSize = new Dimension(newWidth, newHeight);
            this.emulator.postResize(newSize, RequestOrigin.User);
        }
    }

    public void setEmulator(Emulator emulator) {
        this.emulator = emulator;
        this.sizeTerminalFromComponent();
    }

    public void setKeyHandler(KeyListener keyHandler) {
        this.keyHandler = keyHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension doResize(Dimension newSize, RequestOrigin origin) {
        if (!newSize.equals(this.termSize)) {
            this.backBuffer.lock();
            try {
                this.backBuffer.doResize(newSize, origin);
                this.termSize = (Dimension)newSize.clone();
                this.setUpImages();
                Dimension pixelDimension = new Dimension(this.getPixelWidth(), this.getPixelHeight());
                this.setPreferredSize(pixelDimension);
                if (this.resizePanelDelegate != null) {
                    this.resizePanelDelegate.resizedPanel(pixelDimension, origin);
                }
                this.brm.setRangeProperties(0, this.termSize.height, -this.scrollBuffer.getLineCount(), this.termSize.height, false);
            }
            finally {
                this.backBuffer.unlock();
            }
        }
        return new Dimension(this.getPixelWidth(), this.getPixelHeight());
    }

    public void setResizePanelDelegate(ResizePanelDelegate resizeDelegate) {
        this.resizePanelDelegate = resizeDelegate;
    }

    private void establishFontMetrics() {
        BufferedImage img = new BufferedImage(1, 1, 1);
        Graphics2D graphics = img.createGraphics();
        graphics.setFont(this.normalFont);
        FontMetrics fo = graphics.getFontMetrics();
        this.descent = fo.getDescent();
        this.charSize.width = fo.charWidth('@');
        this.charSize.height = fo.getHeight() + this.lineSpace * 2;
        this.descent += this.lineSpace;
        img.flush();
        graphics.dispose();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D gfx = (Graphics2D)g;
        super.paintComponent(g);
        if (this.img != null) {
            gfx.drawImage((Image)this.img, 0, 0, this.termComponent);
            this.drawCursor(gfx);
            this.drawSelection(gfx);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        int id = e.getID();
        if (id == 401) {
            this.keyHandler.keyPressed(e);
        } else if (id != 402 && id == 400) {
            this.keyHandler.keyTyped(e);
        }
        e.consume();
    }

    public int getPixelWidth() {
        return this.charSize.width * this.termSize.width;
    }

    public int getPixelHeight() {
        return this.charSize.height * this.termSize.height;
    }

    @Override
    public int getColumnCount() {
        return this.termSize.width;
    }

    @Override
    public int getRowCount() {
        return this.termSize.height;
    }

    public void drawCursor(Graphics2D g) {
        int y = this.cursor.y - 1 - this.clientScrollOrigin;
        if (y >= 0 && y < this.termSize.height) {
            Style current = this.styleState.getCurrent();
            g.setColor(current.getForeground());
            g.setXORMode(current.getBackground());
            g.fillRect(this.cursor.x * this.charSize.width, y * this.charSize.height, this.charSize.width, this.charSize.height);
        }
    }

    public void drawSelection(Graphics2D g) {
        Style current = this.styleState.getCurrent();
        g.setColor(current.getForeground());
        g.setXORMode(current.getBackground());
        if (this.selectionStart == null || this.selectionEnd == null) {
            return;
        }
        if (this.selectionStart.y == this.selectionEnd.y) {
            if (this.selectionStart.x == this.selectionEnd.x) {
                return;
            }
            Point top = this.selectionStart.x < this.selectionEnd.x ? this.selectionStart : this.selectionEnd;
            Point bottom = this.selectionStart.x >= this.selectionEnd.x ? this.selectionStart : this.selectionEnd;
            g.fillRect(top.x * this.charSize.width, (top.y - this.clientScrollOrigin) * this.charSize.height, (bottom.x - top.x) * this.charSize.width, this.charSize.height);
        } else {
            Point top = this.selectionStart.y < this.selectionEnd.y ? this.selectionStart : this.selectionEnd;
            Point bottom = this.selectionStart.y > this.selectionEnd.y ? this.selectionStart : this.selectionEnd;
            g.fillRect(top.x * this.charSize.width, (top.y - this.clientScrollOrigin) * this.charSize.height, (this.termSize.width - top.x) * this.charSize.width, this.charSize.height);
            if (bottom.y - top.y > 1) {
                g.fillRect(0, (top.y + 1 - this.clientScrollOrigin) * this.charSize.height, this.termSize.width * this.charSize.width, (bottom.y - top.y - 1) * this.charSize.height);
            }
            g.fillRect(0, (bottom.y - this.clientScrollOrigin) * this.charSize.height, bottom.x * this.charSize.width, this.charSize.height);
        }
    }

    @Override
    public void consumeRun(int x, int y, Style style, char[] buf, int start, int len) {
        this.gfx.setColor(style.getBackgroundForRun());
        this.gfx.fillRect(x * this.charSize.width, (y - this.clientScrollOrigin) * this.charSize.height, len * this.charSize.width, this.charSize.height);
        this.gfx.setFont(style.hasOption(Style.Option.BOLD) ? this.boldFont : this.normalFont);
        this.gfx.setColor(style.getForegroundForRun());
        int baseLine = (y + 1 - this.clientScrollOrigin) * this.charSize.height - this.descent;
        this.gfx.drawChars(buf, start, len, x * this.charSize.width, baseLine);
        if (style.hasOption(Style.Option.UNDERSCORE)) {
            this.gfx.drawLine(x * this.charSize.width, baseLine + 1, (x + len) * this.charSize.width, baseLine + 1);
        }
    }

    private void clientScrollOriginChanged(int oldOrigin) {
        int dy = this.clientScrollOrigin - oldOrigin;
        int dyPix = dy * this.charSize.height;
        this.gfx.copyArea(0, Math.max(0, dyPix), this.getPixelWidth(), this.getPixelHeight() - Math.abs(dyPix), 0, -dyPix);
        if (dy < 0) {
            this.scrollBuffer.pumpRuns(this.clientScrollOrigin, -dy, this);
        } else {
            int oldEnd = oldOrigin + this.termSize.height;
            int portionInScroll = oldEnd < 0 ? Math.min(-oldEnd, dy) : 0;
            int portionInBackBuffer = dy - portionInScroll;
            if (portionInScroll > 0) {
                this.scrollBuffer.pumpRuns(oldEnd, portionInScroll, this);
            }
            if (portionInBackBuffer > 0) {
                this.backBuffer.pumpRuns(0, oldEnd + portionInScroll, this.termSize.width, portionInBackBuffer, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redrawFromDamage() {
        int newOrigin = this.newClientScrollOrigin;
        if (!this.backBuffer.tryLock()) {
            if (this.framesSkipped >= 5) {
                this.backBuffer.lock();
            } else {
                ++this.framesSkipped;
                return;
            }
        }
        try {
            boolean hasDamage;
            boolean clientScroll;
            this.framesSkipped = 0;
            boolean serverScroll = this.pendingScrolls.enact(this.gfx, this.getPixelWidth(), this.charSize.height);
            boolean bl = clientScroll = this.clientScrollOrigin != newOrigin;
            if (clientScroll) {
                int oldOrigin = this.clientScrollOrigin;
                this.clientScrollOrigin = newOrigin;
                this.clientScrollOriginChanged(oldOrigin);
            }
            if (hasDamage = this.backBuffer.hasDamage()) {
                this.noDamage = 0;
                this.backBuffer.pumpRunsFromDamage(this);
                this.backBuffer.resetDamage();
            } else {
                ++this.noDamage;
            }
            if (serverScroll || clientScroll || hasDamage || this.cursorChanged) {
                this.repaint();
                this.cursorChanged = false;
            }
        }
        finally {
            this.backBuffer.unlock();
        }
    }

    @Override
    public void scrollArea(int y, int h, int dy) {
        if (dy < 0) {
            this.backBuffer.pumpRuns(0, y - 1, this.termSize.width, -dy, this.scrollBuffer);
            this.brm.setRangeProperties(0, this.termSize.height, -this.scrollBuffer.getLineCount(), this.termSize.height, false);
        }
        this.selectionStart = null;
        this.selectionEnd = null;
        this.pendingScrolls.add(y, h, dy);
    }

    @Override
    public void setCursor(int x, int y) {
        this.cursor.x = x;
        this.cursor.y = y;
        this.cursorChanged = true;
    }

    @Override
    public void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void setLineSpace(int foo) {
        this.lineSpace = foo;
    }

    public void setAntiAliasing(boolean foo) {
        if (this.gfx == null) {
            return;
        }
        this.antialiasing = foo;
        Object mode = foo ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, mode);
        this.gfx.setRenderingHints(hints);
    }

    public BoundedRangeModel getBoundedRangeModel() {
        return this.brm;
    }

    public BackBuffer getBackBuffer() {
        return this.backBuffer;
    }

    public ScrollBuffer getScrollBuffer() {
        return this.scrollBuffer;
    }

    public void lock() {
        this.backBuffer.lock();
    }

    public void unlock() {
        this.backBuffer.unlock();
    }

    static class PendingScrolls {
        int[] ys = new int[10];
        int[] hs = new int[10];
        int[] dys = new int[10];
        int scrollCount = -1;

        PendingScrolls() {
        }

        void ensureArrays(int index) {
            int curLen = this.ys.length;
            if (index >= curLen) {
                this.ys = Util.copyOf(this.ys, curLen * 2);
                this.hs = Util.copyOf(this.hs, curLen * 2);
                this.dys = Util.copyOf(this.dys, curLen * 2);
            }
        }

        void add(int y, int h, int dy) {
            if (dy == 0) {
                return;
            }
            if (this.scrollCount >= 0 && y == this.ys[this.scrollCount] && h == this.hs[this.scrollCount]) {
                int n = this.scrollCount;
                this.dys[n] = this.dys[n] + dy;
            } else {
                ++this.scrollCount;
                this.ensureArrays(this.scrollCount);
                this.ys[this.scrollCount] = y;
                this.hs[this.scrollCount] = h;
                this.dys[this.scrollCount] = dy;
            }
        }

        boolean enact(Graphics2D gfx, int width, int charHeight) {
            if (this.scrollCount < 0) {
                return false;
            }
            for (int i = 0; i <= this.scrollCount; ++i) {
                gfx.copyArea(0, this.ys[i] * charHeight, width, this.hs[i] * charHeight, 0, this.dys[i] * charHeight);
            }
            this.scrollCount = -1;
            return true;
        }
    }
}

