/*
 * Decompiled with CFR 0.152.
 */
package com.wittams.gritty;

import com.wittams.gritty.CharacterUtils;
import com.wittams.gritty.RequestOrigin;
import com.wittams.gritty.Style;
import com.wittams.gritty.StyleState;
import com.wittams.gritty.StyledRunConsumer;
import com.wittams.gritty.Util;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class BackBuffer {
    private static final Logger logger = Logger.getLogger(BackBuffer.class);
    private static final char EMPTY_CHAR = ' ';
    private char[] buf;
    private Style[] styleBuf;
    private BitSet damage;
    StyleState styleState;
    private int width;
    private int height;
    private final Lock lock = new ReentrantLock();

    public BackBuffer(int width, int height, StyleState styleState) {
        this.styleState = styleState;
        this.allocateBuffers(width, height);
    }

    private void allocateBuffers(int width, int height) {
        this.width = width;
        this.height = height;
        this.buf = new char[width * height];
        Arrays.fill(this.buf, ' ');
        this.styleBuf = new Style[width * height];
        Arrays.fill(this.styleBuf, Style.EMPTY);
        this.damage = new BitSet(width * height);
    }

    public Dimension doResize(Dimension pendingResize, RequestOrigin origin) {
        char[] oldBuf = this.buf;
        Style[] oldStyleBuf = this.styleBuf;
        int oldHeight = this.height;
        int oldWidth = this.width;
        this.allocateBuffers(pendingResize.width, pendingResize.height);
        this.clear();
        int copyWidth = Math.min(oldWidth, this.width);
        int copyHeight = Math.min(oldHeight, this.height);
        int oldStart = oldHeight - copyHeight;
        int start = this.height - copyHeight;
        for (int i = 0; i < copyHeight; ++i) {
            System.arraycopy(oldBuf, (oldStart + i) * oldWidth, this.buf, (start + i) * this.width, copyWidth);
            System.arraycopy(oldStyleBuf, (oldStart + i) * oldWidth, this.styleBuf, (start + i) * this.width, copyWidth);
        }
        this.damage.set(0, this.width * this.height - 1, true);
        return pendingResize;
    }

    public void clear() {
        Arrays.fill(this.buf, ' ');
        this.damage.set(0, this.width * this.height, true);
    }

    public void clearArea(int leftX, int topY, int rightX, int bottomY) {
        if (topY > bottomY) {
            logger.error((Object)("Attempt to clear upside down area: top:" + topY + " > bottom:" + bottomY));
            return;
        }
        for (int y = topY; y < bottomY; ++y) {
            if (y > this.height - 1 || y < 0) {
                logger.error((Object)("attempt to clear line" + y + "\n" + "args were x1:" + leftX + " y1:" + topY + " x2:" + rightX + "y2:" + bottomY));
                continue;
            }
            if (leftX > rightX) {
                logger.error((Object)("Attempt to clear backwards area: left:" + leftX + " > right:" + rightX));
                continue;
            }
            Arrays.fill(this.buf, y * this.width + leftX, y * this.width + rightX, ' ');
            Arrays.fill(this.styleBuf, y * this.width + leftX, y * this.width + rightX, Style.EMPTY);
            this.damage.set(y * this.width + leftX, y * this.width + rightX, true);
        }
    }

    public void drawBytes(byte[] bytes, int s, int len, int x, int y) {
        int adjY = y - 1;
        if (adjY >= this.height || adjY < 0) {
            if (logger.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer("Attempt to draw line ").append(adjY).append(" at (").append(x).append(",").append(y).append(")");
                CharacterUtils.appendBuf(sb, bytes, s, len);
                logger.debug((Object)sb);
            }
            return;
        }
        for (int i = 0; i < len; ++i) {
            int location = adjY * this.width + x + i;
            this.buf[location] = (char)bytes[s + i];
            this.styleBuf[location] = this.styleState.getCurrent();
        }
        this.damage.set(adjY * this.width + x, adjY * this.width + x + len);
    }

    public void drawString(String str, int x, int y) {
        int adjY = y - 1;
        if (adjY >= this.height || adjY < 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attempt to draw line out of bounds: " + adjY + " at (" + x + "," + y + ")"));
            }
            return;
        }
        str.getChars(0, str.length(), this.buf, adjY * this.width + x);
        for (int i = 0; i < str.length(); ++i) {
            int location = adjY * this.width + x + i;
            this.styleBuf[location] = this.styleState.getCurrent();
        }
        this.damage.set(adjY * this.width + x, adjY * this.width + x + str.length());
    }

    public void scrollArea(int y, int h, int dy) {
        int lastLine = y + h;
        if (dy > 0) {
            for (int line = lastLine - dy; line >= y; --line) {
                if (line < 0) {
                    logger.error((Object)("Attempt to scroll line from above top of screen:" + line));
                    continue;
                }
                if (line + dy + 1 > this.height) {
                    logger.error((Object)("Attempt to scroll line off bottom of screen:" + (line + dy)));
                    continue;
                }
                System.arraycopy(this.buf, line * this.width, this.buf, (line + dy) * this.width, this.width);
                System.arraycopy(this.styleBuf, line * this.width, this.styleBuf, (line + dy) * this.width, this.width);
                Util.bitsetCopy(this.damage, line * this.width, this.damage, (line + dy) * this.width, this.width);
            }
        } else {
            for (int line = y + dy + 1; line < lastLine; ++line) {
                if (line > this.height - 1) {
                    logger.error((Object)("Attempt to scroll line from below bottom of screen:" + line));
                    continue;
                }
                if (line + dy < 0) {
                    logger.error((Object)("Attempt to scroll to line off top of screen" + (line + dy)));
                    continue;
                }
                System.arraycopy(this.buf, line * this.width, this.buf, (line + dy) * this.width, this.width);
                System.arraycopy(this.styleBuf, line * this.width, this.styleBuf, (line + dy) * this.width, this.width);
                Util.bitsetCopy(this.damage, line * this.width, this.damage, (line + dy) * this.width, this.width);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStyleLines() {
        this.lock.lock();
        try {
            StringBuilder sb = new StringBuilder();
            for (int row = 0; row < this.height; ++row) {
                for (int col = 0; col < this.width; ++col) {
                    int styleNum;
                    Style style = this.styleBuf[row * this.width + col];
                    styleNum = style == null ? (styleNum = 0) : style.getNumber();
                    sb.append(String.format("%03d ", styleNum));
                }
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getLines() {
        this.lock.lock();
        try {
            StringBuffer sb = new StringBuffer();
            for (int row = 0; row < this.height; ++row) {
                sb.append(this.buf, row * this.width, this.width);
                sb.append('\n');
            }
            String string = sb.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDamageLines() {
        this.lock.lock();
        try {
            StringBuffer sb = new StringBuffer();
            for (int row = 0; row < this.height; ++row) {
                for (int col = 0; col < this.width; ++col) {
                    boolean isDamaged = this.damage.get(row * this.width + col);
                    sb.append(isDamaged ? (char)'X' : '-');
                }
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void resetDamage() {
        this.lock.lock();
        try {
            this.damage.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pumpRuns(int x, int y, int w, int h, StyledRunConsumer consumer) {
        int startRow = y;
        int endRow = y + h;
        int startCol = x;
        int endCol = x + w;
        this.lock.lock();
        try {
            for (int row = startRow; row < endRow; ++row) {
                Style lastStyle = null;
                int beginRun = startCol;
                for (int col = startCol; col < endCol; ++col) {
                    int location = row * this.width + col;
                    if (location < 0 || location > this.styleBuf.length) {
                        logger.error((Object)("Requested out of bounds runs:x:" + x + " y:" + y + " w:" + w + " h:" + h));
                        continue;
                    }
                    Style cellStyle = this.styleBuf[location];
                    if (lastStyle == null) {
                        lastStyle = cellStyle;
                        continue;
                    }
                    if (cellStyle.equals(lastStyle)) continue;
                    consumer.consumeRun(beginRun, row, lastStyle, this.buf, row * this.width + beginRun, col - beginRun);
                    beginRun = col;
                    lastStyle = cellStyle;
                }
                if (lastStyle == null) {
                    logger.error((Object)("Style is null for run supposed to be from " + beginRun + " to " + endCol + "on row " + row));
                    continue;
                }
                consumer.consumeRun(beginRun, row, lastStyle, this.buf, row * this.width + beginRun, endCol - beginRun);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pumpRunsFromDamage(StyledRunConsumer consumer) {
        boolean startRow = false;
        int endRow = this.height;
        boolean startCol = false;
        int endCol = this.width;
        this.lock.lock();
        try {
            for (int row = 0; row < endRow; ++row) {
                Style lastStyle = null;
                int beginRun = 0;
                for (int col = 0; col < endCol; ++col) {
                    int location = row * this.width + col;
                    if (location < 0 || location > this.styleBuf.length) {
                        logger.error((Object)"Requested out of bounds runs: pumpFromDamage");
                        continue;
                    }
                    Style cellStyle = this.styleBuf[location];
                    boolean isDamaged = this.damage.get(location);
                    if (!isDamaged) {
                        if (lastStyle != null) {
                            consumer.consumeRun(beginRun, row, lastStyle, this.buf, row * this.width + beginRun, col - beginRun);
                        }
                        beginRun = col;
                        lastStyle = null;
                        continue;
                    }
                    if (lastStyle == null) {
                        lastStyle = cellStyle;
                        continue;
                    }
                    if (cellStyle.equals(lastStyle)) continue;
                    consumer.consumeRun(beginRun, row, lastStyle, this.buf, row * this.width + beginRun, col - beginRun);
                    beginRun = col;
                    lastStyle = cellStyle;
                }
                if (lastStyle == null) continue;
                consumer.consumeRun(beginRun, row, lastStyle, this.buf, row * this.width + beginRun, endCol - beginRun);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasDamage() {
        return this.damage.nextSetBit(0) != -1;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public boolean tryLock() {
        return this.lock.tryLock();
    }
}

