/*
 * Decompiled with CFR 0.152.
 */
package retrofit2;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.ParameterHandler;
import retrofit2.RequestBuilder;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.Utils;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.Field;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.HeaderMap;
import retrofit2.http.Headers;
import retrofit2.http.Multipart;
import retrofit2.http.OPTIONS;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.PartMap;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;
import retrofit2.http.QueryName;
import retrofit2.http.Url;

final class ServiceMethod<R, T> {
    static final String PARAM = "[a-zA-Z][a-zA-Z0-9_-]*";
    static final Pattern PARAM_URL_REGEX = Pattern.compile("\\{([a-zA-Z][a-zA-Z0-9_-]*)\\}");
    static final Pattern PARAM_NAME_REGEX = Pattern.compile("[a-zA-Z][a-zA-Z0-9_-]*");
    private final Call.Factory callFactory;
    private final CallAdapter<R, T> callAdapter;
    private final HttpUrl baseUrl;
    private final Converter<ResponseBody, R> responseConverter;
    private final String httpMethod;
    private final String relativeUrl;
    private final okhttp3.Headers headers;
    private final MediaType contentType;
    private final boolean hasBody;
    private final boolean isFormEncoded;
    private final boolean isMultipart;
    private final ParameterHandler<?>[] parameterHandlers;

    ServiceMethod(Builder<R, T> builder) {
        this.callFactory = builder.retrofit.callFactory();
        this.callAdapter = builder.callAdapter;
        this.baseUrl = builder.retrofit.baseUrl();
        this.responseConverter = builder.responseConverter;
        this.httpMethod = builder.httpMethod;
        this.relativeUrl = builder.relativeUrl;
        this.headers = builder.headers;
        this.contentType = builder.contentType;
        this.hasBody = builder.hasBody;
        this.isFormEncoded = builder.isFormEncoded;
        this.isMultipart = builder.isMultipart;
        this.parameterHandlers = builder.parameterHandlers;
    }

    okhttp3.Call toCall(Object ... args) throws IOException {
        int argumentCount;
        RequestBuilder requestBuilder = new RequestBuilder(this.httpMethod, this.baseUrl, this.relativeUrl, this.headers, this.contentType, this.hasBody, this.isFormEncoded, this.isMultipart);
        ParameterHandler<?>[] handlers = this.parameterHandlers;
        int n = argumentCount = args != null ? args.length : 0;
        if (argumentCount != handlers.length) {
            throw new IllegalArgumentException("Argument count (" + argumentCount + ") doesn't match expected count (" + handlers.length + ")");
        }
        for (int p = 0; p < argumentCount; ++p) {
            handlers[p].apply(requestBuilder, args[p]);
        }
        return this.callFactory.newCall(requestBuilder.build());
    }

    T adapt(Call<R> call) {
        return this.callAdapter.adapt(call);
    }

    R toResponse(ResponseBody body) throws IOException {
        return this.responseConverter.convert(body);
    }

    static Set<String> parsePathParameters(String path) {
        Matcher m = PARAM_URL_REGEX.matcher(path);
        LinkedHashSet<String> patterns = new LinkedHashSet<String>();
        while (m.find()) {
            patterns.add(m.group(1));
        }
        return patterns;
    }

    static Class<?> boxIfPrimitive(Class<?> type) {
        if (Boolean.TYPE == type) {
            return Boolean.class;
        }
        if (Byte.TYPE == type) {
            return Byte.class;
        }
        if (Character.TYPE == type) {
            return Character.class;
        }
        if (Double.TYPE == type) {
            return Double.class;
        }
        if (Float.TYPE == type) {
            return Float.class;
        }
        if (Integer.TYPE == type) {
            return Integer.class;
        }
        if (Long.TYPE == type) {
            return Long.class;
        }
        if (Short.TYPE == type) {
            return Short.class;
        }
        return type;
    }

    static final class Builder<T, R> {
        final Retrofit retrofit;
        final Method method;
        final Annotation[] methodAnnotations;
        final Annotation[][] parameterAnnotationsArray;
        final Type[] parameterTypes;
        Type responseType;
        boolean gotField;
        boolean gotPart;
        boolean gotBody;
        boolean gotPath;
        boolean gotQuery;
        boolean gotUrl;
        String httpMethod;
        boolean hasBody;
        boolean isFormEncoded;
        boolean isMultipart;
        String relativeUrl;
        okhttp3.Headers headers;
        MediaType contentType;
        Set<String> relativeUrlParamNames;
        ParameterHandler<?>[] parameterHandlers;
        Converter<ResponseBody, T> responseConverter;
        CallAdapter<T, R> callAdapter;

        Builder(Retrofit retrofit, Method method) {
            this.retrofit = retrofit;
            this.method = method;
            this.methodAnnotations = method.getAnnotations();
            this.parameterTypes = method.getGenericParameterTypes();
            this.parameterAnnotationsArray = method.getParameterAnnotations();
        }

        public ServiceMethod build() {
            this.callAdapter = this.createCallAdapter();
            this.responseType = this.callAdapter.responseType();
            if (this.responseType == Response.class || this.responseType == okhttp3.Response.class) {
                throw this.methodError("'" + Utils.getRawType(this.responseType).getName() + "' is not a valid response body type. Did you mean ResponseBody?", new Object[0]);
            }
            this.responseConverter = this.createResponseConverter();
            for (Annotation annotation : this.methodAnnotations) {
                this.parseMethodAnnotation(annotation);
            }
            if (this.httpMethod == null) {
                throw this.methodError("HTTP method annotation is required (e.g., @GET, @POST, etc.).", new Object[0]);
            }
            if (!this.hasBody) {
                if (this.isMultipart) {
                    throw this.methodError("Multipart can only be specified on HTTP methods with request body (e.g., @POST).", new Object[0]);
                }
                if (this.isFormEncoded) {
                    throw this.methodError("FormUrlEncoded can only be specified on HTTP methods with request body (e.g., @POST).", new Object[0]);
                }
            }
            int parameterCount = this.parameterAnnotationsArray.length;
            this.parameterHandlers = new ParameterHandler[parameterCount];
            for (int p = 0; p < parameterCount; ++p) {
                Type parameterType = this.parameterTypes[p];
                if (Utils.hasUnresolvableType(parameterType)) {
                    throw this.parameterError(p, "Parameter type must not include a type variable or wildcard: %s", parameterType);
                }
                Annotation[] parameterAnnotations = this.parameterAnnotationsArray[p];
                if (parameterAnnotations == null) {
                    throw this.parameterError(p, "No Retrofit annotation found.", new Object[0]);
                }
                this.parameterHandlers[p] = this.parseParameter(p, parameterType, parameterAnnotations);
            }
            if (this.relativeUrl == null && !this.gotUrl) {
                throw this.methodError("Missing either @%s URL or @Url parameter.", this.httpMethod);
            }
            if (!this.isFormEncoded && !this.isMultipart && !this.hasBody && this.gotBody) {
                throw this.methodError("Non-body HTTP method cannot contain @Body.", new Object[0]);
            }
            if (this.isFormEncoded && !this.gotField) {
                throw this.methodError("Form-encoded method must contain at least one @Field.", new Object[0]);
            }
            if (this.isMultipart && !this.gotPart) {
                throw this.methodError("Multipart method must contain at least one @Part.", new Object[0]);
            }
            return new ServiceMethod(this);
        }

        private CallAdapter<T, R> createCallAdapter() {
            Type returnType = this.method.getGenericReturnType();
            if (Utils.hasUnresolvableType(returnType)) {
                throw this.methodError("Method return type must not include a type variable or wildcard: %s", returnType);
            }
            if (returnType == Void.TYPE) {
                throw this.methodError("Service methods cannot return void.", new Object[0]);
            }
            Annotation[] annotations = this.method.getAnnotations();
            try {
                return this.retrofit.callAdapter(returnType, annotations);
            }
            catch (RuntimeException e) {
                throw this.methodError(e, "Unable to create call adapter for %s", returnType);
            }
        }

        private void parseMethodAnnotation(Annotation annotation) {
            if (annotation instanceof DELETE) {
                this.parseHttpMethodAndPath("DELETE", ((DELETE)annotation).value(), false);
            } else if (annotation instanceof GET) {
                this.parseHttpMethodAndPath("GET", ((GET)annotation).value(), false);
            } else if (annotation instanceof HEAD) {
                this.parseHttpMethodAndPath("HEAD", ((HEAD)annotation).value(), false);
                if (!Void.class.equals((Object)this.responseType)) {
                    throw this.methodError("HEAD method must use Void as response type.", new Object[0]);
                }
            } else if (annotation instanceof PATCH) {
                this.parseHttpMethodAndPath("PATCH", ((PATCH)annotation).value(), true);
            } else if (annotation instanceof POST) {
                this.parseHttpMethodAndPath("POST", ((POST)annotation).value(), true);
            } else if (annotation instanceof PUT) {
                this.parseHttpMethodAndPath("PUT", ((PUT)annotation).value(), true);
            } else if (annotation instanceof OPTIONS) {
                this.parseHttpMethodAndPath("OPTIONS", ((OPTIONS)annotation).value(), false);
            } else if (annotation instanceof HTTP) {
                HTTP http = (HTTP)annotation;
                this.parseHttpMethodAndPath(http.method(), http.path(), http.hasBody());
            } else if (annotation instanceof Headers) {
                String[] headersToParse = ((Headers)annotation).value();
                if (headersToParse.length == 0) {
                    throw this.methodError("@Headers annotation is empty.", new Object[0]);
                }
                this.headers = this.parseHeaders(headersToParse);
            } else if (annotation instanceof Multipart) {
                if (this.isFormEncoded) {
                    throw this.methodError("Only one encoding annotation is allowed.", new Object[0]);
                }
                this.isMultipart = true;
            } else if (annotation instanceof FormUrlEncoded) {
                if (this.isMultipart) {
                    throw this.methodError("Only one encoding annotation is allowed.", new Object[0]);
                }
                this.isFormEncoded = true;
            }
        }

        private void parseHttpMethodAndPath(String httpMethod, String value, boolean hasBody) {
            String queryParams;
            Matcher queryParamMatcher;
            if (this.httpMethod != null) {
                throw this.methodError("Only one HTTP method is allowed. Found: %s and %s.", this.httpMethod, httpMethod);
            }
            this.httpMethod = httpMethod;
            this.hasBody = hasBody;
            if (value.isEmpty()) {
                return;
            }
            int question = value.indexOf(63);
            if (question != -1 && question < value.length() - 1 && (queryParamMatcher = PARAM_URL_REGEX.matcher(queryParams = value.substring(question + 1))).find()) {
                throw this.methodError("URL query string \"%s\" must not have replace block. For dynamic query parameters use @Query.", queryParams);
            }
            this.relativeUrl = value;
            this.relativeUrlParamNames = ServiceMethod.parsePathParameters(value);
        }

        private okhttp3.Headers parseHeaders(String[] headers) {
            Headers.Builder builder = new Headers.Builder();
            for (String header : headers) {
                int colon = header.indexOf(58);
                if (colon == -1 || colon == 0 || colon == header.length() - 1) {
                    throw this.methodError("@Headers value must be in the form \"Name: Value\". Found: \"%s\"", header);
                }
                String headerName = header.substring(0, colon);
                String headerValue = header.substring(colon + 1).trim();
                if ("Content-Type".equalsIgnoreCase(headerName)) {
                    MediaType type = MediaType.parse((String)headerValue);
                    if (type == null) {
                        throw this.methodError("Malformed content type: %s", headerValue);
                    }
                    this.contentType = type;
                    continue;
                }
                builder.add(headerName, headerValue);
            }
            return builder.build();
        }

        private ParameterHandler<?> parseParameter(int p, Type parameterType, Annotation[] annotations) {
            ParameterHandler<?> result = null;
            for (Annotation annotation : annotations) {
                ParameterHandler<?> annotationAction = this.parseParameterAnnotation(p, parameterType, annotations, annotation);
                if (annotationAction == null) continue;
                if (result != null) {
                    throw this.parameterError(p, "Multiple Retrofit annotations found, only one allowed.", new Object[0]);
                }
                result = annotationAction;
            }
            if (result == null) {
                throw this.parameterError(p, "No Retrofit annotation found.", new Object[0]);
            }
            return result;
        }

        private ParameterHandler<?> parseParameterAnnotation(int p, Type type, Annotation[] annotations, Annotation annotation) {
            if (annotation instanceof Url) {
                if (this.gotUrl) {
                    throw this.parameterError(p, "Multiple @Url method annotations found.", new Object[0]);
                }
                if (this.gotPath) {
                    throw this.parameterError(p, "@Path parameters may not be used with @Url.", new Object[0]);
                }
                if (this.gotQuery) {
                    throw this.parameterError(p, "A @Url parameter must not come after a @Query", new Object[0]);
                }
                if (this.relativeUrl != null) {
                    throw this.parameterError(p, "@Url cannot be used with @%s URL", this.httpMethod);
                }
                this.gotUrl = true;
                if (type == HttpUrl.class || type == String.class || type == URI.class || type instanceof Class && "android.net.Uri".equals(((Class)type).getName())) {
                    return new ParameterHandler.RelativeUrl();
                }
                throw this.parameterError(p, "@Url must be okhttp3.HttpUrl, String, java.net.URI, or android.net.Uri type.", new Object[0]);
            }
            if (annotation instanceof Path) {
                if (this.gotQuery) {
                    throw this.parameterError(p, "A @Path parameter must not come after a @Query.", new Object[0]);
                }
                if (this.gotUrl) {
                    throw this.parameterError(p, "@Path parameters may not be used with @Url.", new Object[0]);
                }
                if (this.relativeUrl == null) {
                    throw this.parameterError(p, "@Path can only be used with relative url on @%s", this.httpMethod);
                }
                this.gotPath = true;
                Path path = (Path)annotation;
                String name = path.value();
                this.validatePathName(p, name);
                Converter converter = this.retrofit.stringConverter(type, annotations);
                return new ParameterHandler.Path(name, converter, path.encoded());
            }
            if (annotation instanceof Query) {
                Query query = (Query)annotation;
                String name = query.value();
                boolean encoded = query.encoded();
                Class<?> rawParameterType = Utils.getRawType(type);
                this.gotQuery = true;
                if (Iterable.class.isAssignableFrom(rawParameterType)) {
                    if (!(type instanceof ParameterizedType)) {
                        throw this.parameterError(p, rawParameterType.getSimpleName() + " must include generic type (e.g., " + rawParameterType.getSimpleName() + "<String>)", new Object[0]);
                    }
                    ParameterizedType parameterizedType = (ParameterizedType)type;
                    Type iterableType = Utils.getParameterUpperBound(0, parameterizedType);
                    Converter converter = this.retrofit.stringConverter(iterableType, annotations);
                    return new ParameterHandler.Query(name, converter, encoded).iterable();
                }
                if (rawParameterType.isArray()) {
                    Class<?> arrayComponentType = ServiceMethod.boxIfPrimitive(rawParameterType.getComponentType());
                    Converter converter = this.retrofit.stringConverter(arrayComponentType, annotations);
                    return new ParameterHandler.Query(name, converter, encoded).array();
                }
                Converter converter = this.retrofit.stringConverter(type, annotations);
                return new ParameterHandler.Query(name, converter, encoded);
            }
            if (annotation instanceof QueryName) {
                QueryName query = (QueryName)annotation;
                boolean encoded = query.encoded();
                Class<?> rawParameterType = Utils.getRawType(type);
                this.gotQuery = true;
                if (Iterable.class.isAssignableFrom(rawParameterType)) {
                    if (!(type instanceof ParameterizedType)) {
                        throw this.parameterError(p, rawParameterType.getSimpleName() + " must include generic type (e.g., " + rawParameterType.getSimpleName() + "<String>)", new Object[0]);
                    }
                    ParameterizedType parameterizedType = (ParameterizedType)type;
                    Type iterableType = Utils.getParameterUpperBound(0, parameterizedType);
                    Converter converter = this.retrofit.stringConverter(iterableType, annotations);
                    return new ParameterHandler.QueryName(converter, encoded).iterable();
                }
                if (rawParameterType.isArray()) {
                    Class<?> arrayComponentType = ServiceMethod.boxIfPrimitive(rawParameterType.getComponentType());
                    Converter converter = this.retrofit.stringConverter(arrayComponentType, annotations);
                    return new ParameterHandler.QueryName(converter, encoded).array();
                }
                Converter converter = this.retrofit.stringConverter(type, annotations);
                return new ParameterHandler.QueryName(converter, encoded);
            }
            if (annotation instanceof QueryMap) {
                Class<?> rawParameterType = Utils.getRawType(type);
                if (!Map.class.isAssignableFrom(rawParameterType)) {
                    throw this.parameterError(p, "@QueryMap parameter type must be Map.", new Object[0]);
                }
                Type mapType = Utils.getSupertype(type, rawParameterType, Map.class);
                if (!(mapType instanceof ParameterizedType)) {
                    throw this.parameterError(p, "Map must include generic types (e.g., Map<String, String>)", new Object[0]);
                }
                ParameterizedType parameterizedType = (ParameterizedType)mapType;
                Type keyType = Utils.getParameterUpperBound(0, parameterizedType);
                if (String.class != keyType) {
                    throw this.parameterError(p, "@QueryMap keys must be of type String: " + keyType, new Object[0]);
                }
                Type valueType = Utils.getParameterUpperBound(1, parameterizedType);
                Converter valueConverter = this.retrofit.stringConverter(valueType, annotations);
                return new ParameterHandler.QueryMap(valueConverter, ((QueryMap)annotation).encoded());
            }
            if (annotation instanceof Header) {
                Header header = (Header)annotation;
                String name = header.value();
                Class<?> rawParameterType = Utils.getRawType(type);
                if (Iterable.class.isAssignableFrom(rawParameterType)) {
                    if (!(type instanceof ParameterizedType)) {
                        throw this.parameterError(p, rawParameterType.getSimpleName() + " must include generic type (e.g., " + rawParameterType.getSimpleName() + "<String>)", new Object[0]);
                    }
                    ParameterizedType parameterizedType = (ParameterizedType)type;
                    Type iterableType = Utils.getParameterUpperBound(0, parameterizedType);
                    Converter converter = this.retrofit.stringConverter(iterableType, annotations);
                    return new ParameterHandler.Header(name, converter).iterable();
                }
                if (rawParameterType.isArray()) {
                    Class<?> arrayComponentType = ServiceMethod.boxIfPrimitive(rawParameterType.getComponentType());
                    Converter converter = this.retrofit.stringConverter(arrayComponentType, annotations);
                    return new ParameterHandler.Header(name, converter).array();
                }
                Converter converter = this.retrofit.stringConverter(type, annotations);
                return new ParameterHandler.Header(name, converter);
            }
            if (annotation instanceof HeaderMap) {
                Class<?> rawParameterType = Utils.getRawType(type);
                if (!Map.class.isAssignableFrom(rawParameterType)) {
                    throw this.parameterError(p, "@HeaderMap parameter type must be Map.", new Object[0]);
                }
                Type mapType = Utils.getSupertype(type, rawParameterType, Map.class);
                if (!(mapType instanceof ParameterizedType)) {
                    throw this.parameterError(p, "Map must include generic types (e.g., Map<String, String>)", new Object[0]);
                }
                ParameterizedType parameterizedType = (ParameterizedType)mapType;
                Type keyType = Utils.getParameterUpperBound(0, parameterizedType);
                if (String.class != keyType) {
                    throw this.parameterError(p, "@HeaderMap keys must be of type String: " + keyType, new Object[0]);
                }
                Type valueType = Utils.getParameterUpperBound(1, parameterizedType);
                Converter valueConverter = this.retrofit.stringConverter(valueType, annotations);
                return new ParameterHandler.HeaderMap(valueConverter);
            }
            if (annotation instanceof Field) {
                if (!this.isFormEncoded) {
                    throw this.parameterError(p, "@Field parameters can only be used with form encoding.", new Object[0]);
                }
                Field field = (Field)annotation;
                String name = field.value();
                boolean encoded = field.encoded();
                this.gotField = true;
                Class<?> rawParameterType = Utils.getRawType(type);
                if (Iterable.class.isAssignableFrom(rawParameterType)) {
                    if (!(type instanceof ParameterizedType)) {
                        throw this.parameterError(p, rawParameterType.getSimpleName() + " must include generic type (e.g., " + rawParameterType.getSimpleName() + "<String>)", new Object[0]);
                    }
                    ParameterizedType parameterizedType = (ParameterizedType)type;
                    Type iterableType = Utils.getParameterUpperBound(0, parameterizedType);
                    Converter converter = this.retrofit.stringConverter(iterableType, annotations);
                    return new ParameterHandler.Field(name, converter, encoded).iterable();
                }
                if (rawParameterType.isArray()) {
                    Class<?> arrayComponentType = ServiceMethod.boxIfPrimitive(rawParameterType.getComponentType());
                    Converter converter = this.retrofit.stringConverter(arrayComponentType, annotations);
                    return new ParameterHandler.Field(name, converter, encoded).array();
                }
                Converter converter = this.retrofit.stringConverter(type, annotations);
                return new ParameterHandler.Field(name, converter, encoded);
            }
            if (annotation instanceof FieldMap) {
                if (!this.isFormEncoded) {
                    throw this.parameterError(p, "@FieldMap parameters can only be used with form encoding.", new Object[0]);
                }
                Class<?> rawParameterType = Utils.getRawType(type);
                if (!Map.class.isAssignableFrom(rawParameterType)) {
                    throw this.parameterError(p, "@FieldMap parameter type must be Map.", new Object[0]);
                }
                Type mapType = Utils.getSupertype(type, rawParameterType, Map.class);
                if (!(mapType instanceof ParameterizedType)) {
                    throw this.parameterError(p, "Map must include generic types (e.g., Map<String, String>)", new Object[0]);
                }
                ParameterizedType parameterizedType = (ParameterizedType)mapType;
                Type keyType = Utils.getParameterUpperBound(0, parameterizedType);
                if (String.class != keyType) {
                    throw this.parameterError(p, "@FieldMap keys must be of type String: " + keyType, new Object[0]);
                }
                Type valueType = Utils.getParameterUpperBound(1, parameterizedType);
                Converter valueConverter = this.retrofit.stringConverter(valueType, annotations);
                this.gotField = true;
                return new ParameterHandler.FieldMap(valueConverter, ((FieldMap)annotation).encoded());
            }
            if (annotation instanceof Part) {
                if (!this.isMultipart) {
                    throw this.parameterError(p, "@Part parameters can only be used with multipart encoding.", new Object[0]);
                }
                Part part = (Part)annotation;
                this.gotPart = true;
                String partName = part.value();
                Class<?> rawParameterType = Utils.getRawType(type);
                if (partName.isEmpty()) {
                    if (Iterable.class.isAssignableFrom(rawParameterType)) {
                        if (!(type instanceof ParameterizedType)) {
                            throw this.parameterError(p, rawParameterType.getSimpleName() + " must include generic type (e.g., " + rawParameterType.getSimpleName() + "<String>)", new Object[0]);
                        }
                        ParameterizedType parameterizedType = (ParameterizedType)type;
                        Type iterableType = Utils.getParameterUpperBound(0, parameterizedType);
                        if (!MultipartBody.Part.class.isAssignableFrom(Utils.getRawType(iterableType))) {
                            throw this.parameterError(p, "@Part annotation must supply a name or use MultipartBody.Part parameter type.", new Object[0]);
                        }
                        return ParameterHandler.RawPart.INSTANCE.iterable();
                    }
                    if (rawParameterType.isArray()) {
                        Class<?> arrayComponentType = rawParameterType.getComponentType();
                        if (!MultipartBody.Part.class.isAssignableFrom(arrayComponentType)) {
                            throw this.parameterError(p, "@Part annotation must supply a name or use MultipartBody.Part parameter type.", new Object[0]);
                        }
                        return ParameterHandler.RawPart.INSTANCE.array();
                    }
                    if (MultipartBody.Part.class.isAssignableFrom(rawParameterType)) {
                        return ParameterHandler.RawPart.INSTANCE;
                    }
                    throw this.parameterError(p, "@Part annotation must supply a name or use MultipartBody.Part parameter type.", new Object[0]);
                }
                okhttp3.Headers headers = okhttp3.Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"" + partName + "\"", "Content-Transfer-Encoding", part.encoding()});
                if (Iterable.class.isAssignableFrom(rawParameterType)) {
                    if (!(type instanceof ParameterizedType)) {
                        throw this.parameterError(p, rawParameterType.getSimpleName() + " must include generic type (e.g., " + rawParameterType.getSimpleName() + "<String>)", new Object[0]);
                    }
                    ParameterizedType parameterizedType = (ParameterizedType)type;
                    Type iterableType = Utils.getParameterUpperBound(0, parameterizedType);
                    if (MultipartBody.Part.class.isAssignableFrom(Utils.getRawType(iterableType))) {
                        throw this.parameterError(p, "@Part parameters using the MultipartBody.Part must not include a part name in the annotation.", new Object[0]);
                    }
                    Converter converter = this.retrofit.requestBodyConverter(iterableType, annotations, this.methodAnnotations);
                    return new ParameterHandler.Part(headers, converter).iterable();
                }
                if (rawParameterType.isArray()) {
                    Class<?> arrayComponentType = ServiceMethod.boxIfPrimitive(rawParameterType.getComponentType());
                    if (MultipartBody.Part.class.isAssignableFrom(arrayComponentType)) {
                        throw this.parameterError(p, "@Part parameters using the MultipartBody.Part must not include a part name in the annotation.", new Object[0]);
                    }
                    Converter converter = this.retrofit.requestBodyConverter(arrayComponentType, annotations, this.methodAnnotations);
                    return new ParameterHandler.Part(headers, converter).array();
                }
                if (MultipartBody.Part.class.isAssignableFrom(rawParameterType)) {
                    throw this.parameterError(p, "@Part parameters using the MultipartBody.Part must not include a part name in the annotation.", new Object[0]);
                }
                Converter converter = this.retrofit.requestBodyConverter(type, annotations, this.methodAnnotations);
                return new ParameterHandler.Part(headers, converter);
            }
            if (annotation instanceof PartMap) {
                if (!this.isMultipart) {
                    throw this.parameterError(p, "@PartMap parameters can only be used with multipart encoding.", new Object[0]);
                }
                this.gotPart = true;
                Class<?> rawParameterType = Utils.getRawType(type);
                if (!Map.class.isAssignableFrom(rawParameterType)) {
                    throw this.parameterError(p, "@PartMap parameter type must be Map.", new Object[0]);
                }
                Type mapType = Utils.getSupertype(type, rawParameterType, Map.class);
                if (!(mapType instanceof ParameterizedType)) {
                    throw this.parameterError(p, "Map must include generic types (e.g., Map<String, String>)", new Object[0]);
                }
                ParameterizedType parameterizedType = (ParameterizedType)mapType;
                Type keyType = Utils.getParameterUpperBound(0, parameterizedType);
                if (String.class != keyType) {
                    throw this.parameterError(p, "@PartMap keys must be of type String: " + keyType, new Object[0]);
                }
                Type valueType = Utils.getParameterUpperBound(1, parameterizedType);
                if (MultipartBody.Part.class.isAssignableFrom(Utils.getRawType(valueType))) {
                    throw this.parameterError(p, "@PartMap values cannot be MultipartBody.Part. Use @Part List<Part> or a different value type instead.", new Object[0]);
                }
                Converter valueConverter = this.retrofit.requestBodyConverter(valueType, annotations, this.methodAnnotations);
                PartMap partMap = (PartMap)annotation;
                return new ParameterHandler.PartMap(valueConverter, partMap.encoding());
            }
            if (annotation instanceof Body) {
                Converter converter;
                if (this.isFormEncoded || this.isMultipart) {
                    throw this.parameterError(p, "@Body parameters cannot be used with form or multi-part encoding.", new Object[0]);
                }
                if (this.gotBody) {
                    throw this.parameterError(p, "Multiple @Body method annotations found.", new Object[0]);
                }
                try {
                    converter = this.retrofit.requestBodyConverter(type, annotations, this.methodAnnotations);
                }
                catch (RuntimeException e) {
                    throw this.parameterError(e, p, "Unable to create @Body converter for %s", type);
                }
                this.gotBody = true;
                return new ParameterHandler.Body(converter);
            }
            return null;
        }

        private void validatePathName(int p, String name) {
            if (!PARAM_NAME_REGEX.matcher(name).matches()) {
                throw this.parameterError(p, "@Path parameter name must match %s. Found: %s", PARAM_URL_REGEX.pattern(), name);
            }
            if (!this.relativeUrlParamNames.contains(name)) {
                throw this.parameterError(p, "URL \"%s\" does not contain \"{%s}\".", this.relativeUrl, name);
            }
        }

        private Converter<ResponseBody, T> createResponseConverter() {
            Annotation[] annotations = this.method.getAnnotations();
            try {
                return this.retrofit.responseBodyConverter(this.responseType, annotations);
            }
            catch (RuntimeException e) {
                throw this.methodError(e, "Unable to create converter for %s", this.responseType);
            }
        }

        private RuntimeException methodError(String message, Object ... args) {
            return this.methodError(null, message, args);
        }

        private RuntimeException methodError(Throwable cause, String message, Object ... args) {
            message = String.format(message, args);
            return new IllegalArgumentException(message + "\n    for method " + this.method.getDeclaringClass().getSimpleName() + "." + this.method.getName(), cause);
        }

        private RuntimeException parameterError(Throwable cause, int p, String message, Object ... args) {
            return this.methodError(cause, message + " (parameter #" + (p + 1) + ")", args);
        }

        private RuntimeException parameterError(int p, String message, Object ... args) {
            return this.methodError(message + " (parameter #" + (p + 1) + ")", args);
        }
    }
}

