/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.console.py4j;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.NetworkUtilities;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.ScriptingStatusBusListener;
import org.lsst.ccs.scripting.ScriptingStatusBusMessage;
import org.lsst.ccs.scripting.ScriptingStatusBusMessageFilter;
import org.lsst.ccs.scripting.ScriptingSubsystemWrapper;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeUtils;
import py4j.GatewayServer;

public class Py4JServer
extends Subsystem
implements HasLifecycle {
    @Persist
    private final List<Py4jGatewayServer> gateways = new ArrayList<Py4jGatewayServer>();
    private static final String LOCALHOST_NANE = "default-localhost";

    public Py4JServer() {
        super("py4j-server", AgentInfo.AgentType.SERVICE);
    }

    @Override
    public void shutdown() {
        for (Py4jGatewayServer gw : this.gateways) {
            gw.stopServer();
        }
    }

    @Override
    public void start() {
        this.getAgentPersistenceService().load();
        try {
            if (this.gateways.isEmpty()) {
                this.createGateway();
            } else {
                for (Py4jGatewayServer server : this.gateways) {
                    server.startServer();
                }
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @Command
    public void createGateway() throws UnknownHostException {
        this.createGateway(LOCALHOST_NANE, 25333, LOCALHOST_NANE, 25334);
    }

    @Command(description="starts a gateway")
    public void createGateway(@Argument(description="the name of this gateway") String name, @Argument(description="the listening port") int port, @Argument(description="the python client's callback address") String callbackAddress, @Argument(description="the python client's callback port") int callbackPort) throws UnknownHostException {
        Py4jGatewayServer gateway = new Py4jGatewayServer(name, port, callbackAddress, callbackPort);
        gateway.startServer();
        this.gateways.add(gateway);
        this.getAgentPersistenceService().persistNow();
    }

    @Command(description="restart a gateway")
    public void restartGateway(@Argument(description="the name of the gateway") String name) {
        for (Py4jGatewayServer server : this.gateways) {
            if (!server.getName().equals(name)) continue;
            server.stopServer();
            server.startServer();
            return;
        }
        throw new IllegalArgumentException("No Gateway is available with name " + name);
    }

    @Command(description="remove a gateway")
    public void removeGateway(@Argument(description="the name of the gateway") String name) {
        Iterator<Py4jGatewayServer> iter = this.gateways.iterator();
        while (iter.hasNext()) {
            Py4jGatewayServer server = iter.next();
            if (!server.getName().equals(name)) continue;
            iter.remove();
            this.getAgentPersistenceService().persistNow();
            return;
        }
        throw new IllegalArgumentException("No Gateway is available with name " + name);
    }

    @Command
    public String listGateways() {
        StringBuilder sb = new StringBuilder();
        if (this.gateways.isEmpty()) {
            sb.append("No gateways are currently available");
        } else {
            for (Py4jGatewayServer gw : this.gateways) {
                sb.append(gw.toPrettyString()).append("\n");
            }
        }
        return sb.toString();
    }

    public static class Py4jGatewayServer {
        private GatewayServer server;
        private InetAddress address;
        private InetAddress callbackAddress;
        private final Map<String, String> parameters = new HashMap<String, String>();
        private static final String NAME = "name";
        private static final String SERVER_PORT = "serverPort";
        private static final String CALLBACK_ADDRESS = "callbackAddress";
        private static final String CALLBACK_PORT = "callbackPort";

        public Py4jGatewayServer(String stringRepresentation) {
            Map pars = (Map)InputConversionEngine.convertArgToType((String)stringRepresentation, Map.class);
            this.initializeServer((String)pars.get(NAME), Integer.valueOf((String)pars.get(SERVER_PORT)), (String)pars.get(CALLBACK_ADDRESS), Integer.valueOf((String)pars.get(CALLBACK_PORT)));
        }

        Py4jGatewayServer() throws UnknownHostException {
            this(Py4JServer.LOCALHOST_NANE, 25333, Py4JServer.LOCALHOST_NANE, 25334);
        }

        Py4jGatewayServer(String name, int port, String callbackAddress, int callbackPort) {
            this.initializeServer(name, port, callbackAddress, callbackPort);
        }

        private final void initializeServer(String name, int port, String callbackAddress, int callbackPort) {
            this.address = this.getGatewayAddress(name);
            this.callbackAddress = this.getCallbackAddress(callbackAddress);
            this.server = new GatewayServer((Object)this, port, callbackPort, this.address, this.callbackAddress, 0, 0, null);
            this.parameters.put(NAME, name);
            this.parameters.put(SERVER_PORT, String.valueOf(port));
            this.parameters.put(CALLBACK_ADDRESS, callbackAddress);
            this.parameters.put(CALLBACK_PORT, String.valueOf(callbackPort));
        }

        private InetAddress getGatewayAddress(String name) {
            try {
                if (name.equals(Py4JServer.LOCALHOST_NANE)) {
                    return InetAddress.getLoopbackAddress();
                }
                return NetworkInterface.getByName(NetworkUtilities.getMainInterfaceName()).getInterfaceAddresses().get(0).getAddress();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        private InetAddress getCallbackAddress(String name) {
            try {
                if (name.equals(Py4JServer.LOCALHOST_NANE)) {
                    return InetAddress.getLoopbackAddress();
                }
                return InetAddress.getByName(name);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public String getName() {
            return this.parameters.get(NAME);
        }

        public int getPort() {
            return Integer.valueOf(this.parameters.get(SERVER_PORT));
        }

        private void startServer() {
            this.server.start();
            System.out.println("Started Gateway Server on " + this.server.getAddress() + ":" + this.server.getPort() + " and callback " + this.server.getCallbackClient().getAddress() + " " + this.server.getCallbackClient().getPort());
        }

        private void stopServer() {
            this.server.shutdown();
        }

        public String toString() {
            return TypeUtils.stringify(this.parameters);
        }

        public String toPrettyString() {
            return this.getName() + " Java(" + this.server.getAddress() + ":" + this.server.getPort() + ") -> Python(" + this.server.getCallbackClient().getAddress() + " " + this.server.getCallbackClient().getPort() + ")";
        }

        public void initializeScriptingEnvironment() throws UnknownHostException {
            this.server.resetCallbackClient(this.callbackAddress, Integer.valueOf(this.parameters.get(CALLBACK_PORT)).intValue());
            CCS.initializeScriptingEnvironment();
        }

        public void shutdownScriptingEnvironment() throws Exception {
            CCS.shutdownScriptingEnvironment();
        }

        public ScriptingSubsystemWrapper attachSubsystem(String target) {
            return CCS.attachSubsystem(target);
        }

        public void setThrowExceptions(boolean throwExceptions) {
            CCS.setThrowExceptions(throwExceptions);
        }

        public boolean getThrowExceptions() {
            return CCS.getThrowExceptions();
        }

        public void addStatusBusListener(ScriptingStatusBusListener listener) {
            CCS.addStatusBusListener(listener);
        }

        public void addStatusBusListener(ScriptingStatusBusListener listener, ScriptingStatusBusMessageFilter filter) {
            CCS.addStatusBusListener(listener, filter);
        }

        public void removeStatusBusListener(ScriptingStatusBusListener listener) {
            CCS.removeStatusBusListener(listener);
        }

        public Future<ScriptingStatusBusMessage> startListeningForStatusBusMessage(ScriptingStatusBusMessageFilter filter, Duration timeout) {
            return CCS.startListeningForStatusBusMessage(filter, timeout);
        }
    }
}

