/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.lsst.ccs.bus.data.AgentLock;
import org.lsst.ccs.bus.data.AgentLockInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusLock;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AbstractAgentLockServiceDelegate;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class RemoteAgentLockService
extends AbstractAgentLockServiceDelegate {
    private AgentMessagingLayer aml;
    private ConcurrentMessagingUtils cmu;
    StatusMessageListener sml = new StatusMessageListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStatusMessage(StatusMessage msg) {
            block13: {
                try {
                    if (!(msg instanceof StatusLock)) {
                        return;
                    }
                    Serializable obj = msg.getObject();
                    if (!(obj instanceof AgentLockInfo)) {
                        return;
                    }
                    AgentLockInfo lock = (AgentLockInfo)obj;
                    AbstractAgentLockServiceDelegate.log.finest((Object)("got lock message " + lock));
                    int level = ((StatusLock)msg).getLevel();
                    if (level >= 0) {
                        AgentLockInfo existingLock = (AgentLockInfo)RemoteAgentLockService.this.getLockForAgent(lock.getAgentName());
                        if (existingLock == null || !existingLock.getOwnerName().equals(lock.getOwnerName())) {
                            throw new UnauthorizedLevelException(lock.toString());
                        }
                        RemoteAgentLockService.this.setLevelInternal(lock.getAgentName(), level);
                        AbstractAgentLockServiceDelegate.log.finest((Object)("level updated to " + level));
                        break block13;
                    }
                    if (lock.getStatus() == AgentLockInfo.Status.ACKNOWLEDGED) {
                        RemoteAgentLockService.this.setLockInternal(lock.getAgentName(), (AgentLock)lock);
                        break block13;
                    }
                    if (lock.getStatus() == AgentLockInfo.Status.RELEASED) {
                        RemoteAgentLockService.this.setLevelInternal(lock.getAgentName(), 0);
                        RemoteAgentLockService.this.setLockInternal(lock.getAgentName(), null);
                        break block13;
                    }
                    if (lock.getStatus() != AgentLockInfo.Status.REQUESTED || !lock.getAgentName().equals(RemoteAgentLockService.this.getAgent().getName())) break block13;
                    AgentLockInfo reply = null;
                    Object object = RemoteAgentLockService.this.lockLevelUpdate;
                    synchronized (object) {
                        AgentLock oldLock = RemoteAgentLockService.this.getLockForAgent(RemoteAgentLockService.this.getAgent().getName());
                        if (oldLock != null && !oldLock.getOwnerName().equals(lock.getOwnerName())) {
                            reply = new AgentLockInfo(lock, AgentLockInfo.Status.REJECTED, CCSTimeStamp.currentTime());
                        } else {
                            reply = new AgentLockInfo(lock, AgentLockInfo.Status.ACKNOWLEDGED, CCSTimeStamp.currentTime());
                            RemoteAgentLockService.this.setLockInternal(lock.getAgentName(), (AgentLock)reply);
                        }
                    }
                    StatusLock replyMsg = new StatusLock(reply);
                    replyMsg.setState(RemoteAgentLockService.this.getAgentStateService().getState());
                    RemoteAgentLockService.this.aml.sendStatusMessage((StatusMessage)replyMsg);
                }
                catch (IOException | UnauthorizedLevelException | UnauthorizedLockException e) {
                    AbstractAgentLockServiceDelegate.log.error((Object)"error registering lock locally ", (Throwable)e);
                }
            }
        }
    };

    public RemoteAgentLockService(AgentLockService svc) {
        super(svc);
    }

    @Override
    public void preInit() {
        super.preInit();
        this.aml = this.getAgent().getMessagingAccess();
        this.cmu = new ConcurrentMessagingUtils(this.aml);
        log.finest((Object)"RemoteAgentLockService init");
    }

    @Override
    public void preStart() {
        log.finest((Object)"adding lock message listener");
        this.aml.addStatusMessageListener(this.sml, BusMessageFilterFactory.embeddedObjectClass(AgentLockInfo.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLevelForAgent(String agentName, int level) throws UnauthorizedLevelException, UnauthorizedLockException, IOException {
        AgentLockInfo lock = null;
        Object object = this.lockLevelUpdate;
        synchronized (object) {
            lock = (AgentLockInfo)this.heldLocks.get(agentName);
            if (lock == null) {
                this.lockAgent(agentName);
                lock = (AgentLockInfo)this.heldLocks.get(agentName);
                log.finest((Object)("=> " + lock));
            }
            this.setLevelInternal(agentName, level);
        }
        try {
            this.cmu.sendSynchronousCommand(new CommandRequest("lockmanager", "updateLevel", new Object[]{lock, level}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void lockAgent(String agentName) throws UnauthorizedLockException, IOException {
        try {
            AgentLockInfo request = new AgentLockInfo(agentName, this.getAgent().getName(), this.svc.getUserId(), 99999, AgentLockInfo.Status.REQUESTED, CCSTimeStamp.currentTime());
            AgentLockInfo lock = (AgentLockInfo)this.cmu.sendSynchronousCommand(new CommandRequest("lockmanager", "lockAgent", new Object[]{request}));
            log.finest((Object)("received lock " + lock));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void unlockAgent(String agentName) throws IOException {
        try {
            AgentLockInfo request = new AgentLockInfo(agentName, this.getAgent().getName(), this.svc.getUserId(), 1, AgentLockInfo.Status.RELEASED, CCSTimeStamp.currentTime());
            AgentLockInfo lock = (AgentLockInfo)this.cmu.sendSynchronousCommand(new CommandRequest("lockmanager", "unlockAgent", new Object[]{request}));
            log.finest((Object)("received unlock " + lock));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean validateLock(AgentLock lock) {
        return true;
    }

    @Override
    public Map<String, AgentLock> getLocks() {
        return Collections.emptyMap();
    }
}

