/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.Callable;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;

public class CommandHelper {
    private boolean preconditionsMet = true;
    private boolean enterFaultOnError = false;
    private String preconditionsReason = "Preconditions not met";
    private final Agent agent;
    private Duration duration;
    private static final Alert defaultAlert = new Alert("CMDFAIL", "Command failed");
    private final AgentStateService agentStateService;

    public CommandHelper(Agent agent) {
        this.agent = agent;
        this.agentStateService = agent.getAgentService(AgentStateService.class);
    }

    public CommandHelper precondition(boolean ok) {
        this.preconditionsMet &= ok;
        return this;
    }

    public CommandHelper precondition(boolean ok, String reason, Object ... args) {
        if (this.preconditionsMet && !ok) {
            this.preconditionsMet = false;
            this.preconditionsReason = args.length > 0 ? String.format(reason, args) : reason;
        }
        return this;
    }

    public CommandHelper precondition(Enum ... states) {
        StateBundle stateBundle = this.agentStateService.getState();
        for (Enum state : states) {
            if (!stateBundle.isInState(state)) continue;
            return this;
        }
        this.preconditionsMet = false;
        this.preconditionsReason = "Command not accepted in state " + stateBundle;
        return this;
    }

    public CommandHelper duration(Duration duration) {
        this.duration = duration;
        return this;
    }

    public CommandHelper enterFaultOnException(boolean enterFault) {
        this.enterFaultOnError = enterFault;
        return this;
    }

    public <T> T action(Callable<T> callable) {
        if (this.handlePreconditions()) {
            try {
                return callable.call();
            }
            catch (Exception x) {
                throw this.handleException(x);
            }
        }
        return null;
    }

    public void action(RunnableWithException runnable) {
        if (this.handlePreconditions()) {
            try {
                runnable.run();
            }
            catch (Exception x) {
                throw this.handleException(x);
            }
        }
    }

    private boolean handlePreconditions() {
        if (!this.preconditionsMet) {
            this.agent.sendNack((Serializable)((Object)this.preconditionsReason));
        } else if (this.duration != null) {
            this.agent.sendAck(this.duration);
        }
        return this.preconditionsMet;
    }

    private CommandFailedException handleException(Exception x) {
        if (this.enterFaultOnError) {
            this.agent.getAgentService(AlertService.class).raiseAlert(defaultAlert, AlertState.ALARM, "Execution of command failed unexpectedly");
            return new CommandFailedException("Exception while executing command, fault state entered", x);
        }
        return new CommandFailedException("Unexpected exception during command execution", x);
    }

    public static class CommandFailedException
    extends RuntimeException {
        private static final long serialVersionUID = -809673339005572968L;

        public CommandFailedException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface RunnableWithException {
        public void run() throws Exception;
    }
}

