/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.util.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.stream.Collectors;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.lsst.ccs.gconsole.services.persist.Savable;
import org.lsst.ccs.gconsole.util.tree.SModel;
import org.lsst.ccs.gconsole.util.tree.SNode;
import org.lsst.ccs.gconsole.util.tree.TreeUtil;

public class STree<T>
extends JTree
implements Savable {
    public STree() {
        super(new SModel());
        this.setRootVisible(false);
        this.getSelectionModel().setSelectionMode(1);
    }

    public STree(SModel<T> model) {
        super(model);
        this.setRootVisible(false);
        this.getSelectionModel().setSelectionMode(1);
    }

    @Override
    public SNode<T> getLastSelectedPathComponent() {
        return (SNode)super.getLastSelectedPathComponent();
    }

    @Override
    public SModel<T> getModel() {
        return (SModel)super.getModel();
    }

    public void expandLevel(int level) {
        Object root = ((SModel)this.getModel()).getRoot();
        if (root != null) {
            this.expandLevel(level - 1, 0, (SNode<T>)root, new TreePath(root));
        }
    }

    private boolean expandLevel(int targetLevel, int currentLevel, SNode<T> node, TreePath path) {
        if (targetLevel == currentLevel) {
            if (node.isLeaf()) {
                return true;
            }
            this.expandPath(path);
        } else {
            Enumeration<TreeNode> e = node.children();
            if (e.hasMoreElements()) {
                ++currentLevel;
                while (e.hasMoreElements()) {
                    SNode child = (SNode)e.nextElement();
                    boolean expandParent = this.expandLevel(targetLevel, currentLevel, child, path.pathByAddingChild(child));
                    if (!expandParent) continue;
                    this.expandPath(path);
                    break;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public T getSelectedUserObject() {
        Object node = this.getLastSelectedPathComponent();
        return node == null ? null : (T)((SNode)node).getUserObject();
    }

    public String getSelectedPathAsString() {
        Object last = this.getLastSelectedPathComponent();
        return last == null ? null : ((SNode)last).getPathAsString();
    }

    public void setSelectedPath(String path) {
        if (path == null) {
            this.setSelectionPath(null);
        } else {
            TreeModel model = this.getModel();
            if (model != null) {
                this.setSelectionPath(((SModel)model).getPath(path));
            }
        }
    }

    @Override
    public void restore(Serializable descriptor) {
        String[] expansionState;
        if (!(descriptor instanceof Descriptor)) {
            return;
        }
        Descriptor desc = (Descriptor)descriptor;
        for (String path : expansionState = desc.getExpansionState()) {
            TreePath tp = ((SModel)this.getModel()).getPath(path);
            if (tp == null) continue;
            this.expandPath(tp);
        }
        String select = desc.getSelection();
        if (select != null && !select.equals(this.getSelectedPathAsString())) {
            this.setSelectedPath(select);
        }
    }

    @Override
    public Descriptor save() {
        Descriptor desc = new Descriptor();
        ArrayList<TreePath> expandedPaths = TreeUtil.saveExpansionState(this);
        String[] expansionState = expandedPaths.stream().map(p -> ((SNode)p.getLastPathComponent()).getPathAsString()).collect(Collectors.toList()).toArray(new String[expandedPaths.size()]);
        desc.setExpansionState(expansionState);
        desc.setSelection(this.getSelectedPathAsString());
        return desc;
    }

    public static class Descriptor
    implements Serializable,
    Cloneable {
        private String[] expansionState;
        private String selection;

        public String[] getExpansionState() {
            return this.expansionState;
        }

        public void setExpansionState(String[] expansionState) {
            this.expansionState = expansionState;
        }

        public String getSelection() {
            return this.selection;
        }

        public void setSelection(String selection) {
            this.selection = selection;
        }

        public Descriptor clone() {
            try {
                Descriptor clone = (Descriptor)super.clone();
                if (this.expansionState != null) {
                    clone.expansionState = Arrays.copyOf(this.expansionState, this.expansionState.length);
                }
                return clone;
            }
            catch (CloneNotSupportedException x) {
                throw new RuntimeException(x);
            }
        }
    }
}

