/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.tutorial;

import java.awt.Component;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.freehep.application.studio.Studio;
import org.freehep.util.commanddispatcher.BooleanCommandState;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandState;
import org.lsst.ccs.gconsole.plugins.tutorial.AdvancedTutorialPage;
import org.lsst.ccs.gconsole.plugins.tutorial.TutorialConsole;
import org.lsst.ccs.gconsole.plugins.tutorial.TutorialPage;

public class TutorialCommands
extends CommandProcessor {
    private Studio studio;
    private TutorialConsole tutorialConsole;
    private boolean chooseMeEnabled = true;

    public TutorialCommands(Studio studio) {
        this.studio = studio;
        this.tutorialConsole = new TutorialConsole(studio);
    }

    public void onChooseMe() {
        JOptionPane.showMessageDialog((Component)this.studio, "Choose Me was activated");
    }

    public void enableChooseMe(CommandState state) {
        state.setEnabled(this.chooseMeEnabled);
    }

    public void onEnableChooseMe(boolean onOff) {
        this.chooseMeEnabled = onOff;
        this.setChanged();
    }

    public void enableEnableChooseMe(BooleanCommandState state) {
        state.setEnabled(true);
        state.setSelected(this.chooseMeEnabled);
    }

    public void onOpenTutorialPage() {
        ImageIcon icon = new ImageIcon(((Object)((Object)this)).getClass().getResource("Letter T.png"));
        this.studio.getPageManager().openPage((Component)new TutorialPage(), "Tutorial", (Icon)icon);
    }

    public void onOpenAdvancedTutorialPage() {
        ImageIcon icon = new ImageIcon(((Object)((Object)this)).getClass().getResource("Letter A.png"));
        this.studio.getPageManager().openPage((Component)new AdvancedTutorialPage(), "Advanced", (Icon)icon);
    }

    public void onCreateDemoOutputConsole() throws IOException {
        this.tutorialConsole.createOutputConsole();
    }

    public void onCreateDemoInputConsole() throws IOException {
        this.tutorialConsole.createInputConsole();
    }

    public void onCreateDemoInputOutputConsole() throws IOException {
        this.tutorialConsole.createInputOutputConsole();
    }
}

