/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Color;
import java.math.BigInteger;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.EnumMap;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

public class MonitorFormat {
    public static final DefaultMonitorFormat DEFAULT = new DefaultMonitorFormat();
    public static final Color COLOR_FG = Color.BLACK;
    public static final Color COLOR_BG = Color.WHITE;
    public static final Color COLOR_CHANGED = Color.BLUE;
    public static final Color COLOR_GOOD = new Color(160, 255, 160);
    public static final Color COLOR_WARN = new Color(255, 255, 100);
    public static final Color COLOR_ERR = new Color(255, 160, 160);
    public static final Color COLOR_DISABLED = new Color(255, 200, 255);
    public static final Color COLOR_OFF = new Color(160, 200, 255);
    public static final Color COLOR_POPUP = new Color(255, 255, 160);
    public static final Color COLOR_MULTI = Color.LIGHT_GRAY;
    public static final Color COLOR_NA = COLOR_BG;
    public static final EnumMap<DataProviderState, Color> COLOR_STATE = new EnumMap(DataProviderState.class);
    public static final String TEXT_MULTI = "---";
    public static final int HA_MULTI = 0;
    protected String DEFAULT_FLOAT_FORMAT = "%14.5f";
    protected String DEFAULT_INT_FORMAT = "%10d";
    protected String DEFAULT_DT_FORMAT = "%1$tF %1$tT";
    protected int LENGTH_LIMIT = 40;
    private static final Pattern pFormatConversion;

    public FormattedValue format(MonitorField field, List<AgentChannel> channels) {
        FormattedValue fv = field.format(channels);
        if (fv == null) {
            List<FormattedValue> fvList = channels.stream().map(ch -> this.format(field, (AgentChannel)ch)).collect(Collectors.toList());
            fv = this.merge(field, fvList);
        }
        if (!fv.isValid()) {
            fv = this.format(fv);
        }
        if (!fv.isValid()) {
            fv = FormattedValue.NA;
        }
        return fv;
    }

    public FormattedValue format(MonitorField field, AgentChannel channel) {
        FormattedValue fv = field.format(channel);
        if (fv.isValid()) {
            return fv;
        }
        if ((fv = this.format(fv)).isValid()) {
            return fv;
        }
        return FormattedValue.NA;
    }

    protected FormattedValue format(FormattedValue fv) {
        if (fv.isValid()) {
            return fv;
        }
        if (fv.value instanceof ConfigurationParameterInfo) {
            ConfigurationParameterInfo conf = (ConfigurationParameterInfo)fv.value;
            fv.value = conf.getCurrentValue();
            if (fv.fgColor == null) {
                Color color = fv.fgColor = conf.isDirty() ? COLOR_CHANGED : COLOR_FG;
            }
            if (fv.editable == null) {
                fv.editable = !conf.isFinal();
            }
            if (fv.toolTip == null) {
                fv.toolTip = conf.getDescription();
            }
            return this.format(fv);
        }
        if (fv.text == null) {
            if (fv.format != null) {
                char conv = MonitorFormat.getFormatConversion(fv.format).charAt(0);
                try {
                    switch (conv) {
                        case 'X': 
                        case 'd': 
                        case 'o': 
                        case 'x': {
                            if (fv.value instanceof Integer || fv.value instanceof Long || fv.value instanceof Short || fv.value instanceof Byte || fv.value instanceof BigInteger) break;
                            fv.value = Long.parseLong(fv.value.toString());
                            break;
                        }
                        case 'E': 
                        case 'G': 
                        case 'e': 
                        case 'f': 
                        case 'g': {
                            if (fv.value instanceof Double || fv.value instanceof Float || fv.value instanceof BigInteger) break;
                            fv.value = Double.parseDouble(fv.value.toString());
                        }
                    }
                    fv.text = String.format(fv.format, fv.value);
                }
                catch (NumberFormatException | IllegalFormatException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (fv.text == null) {
                if (fv.value instanceof Double || fv.value instanceof Float) {
                    try {
                        fv.text = String.format(this.DEFAULT_FLOAT_FORMAT, fv.value);
                    }
                    catch (IllegalFormatException illegalFormatException) {}
                } else if (fv.value instanceof Integer) {
                    try {
                        fv.text = String.format(this.DEFAULT_INT_FORMAT, fv.value);
                    }
                    catch (IllegalFormatException illegalFormatException) {}
                } else if (fv.value instanceof Instant) {
                    try {
                        fv.text = String.format(this.DEFAULT_DT_FORMAT, ZonedDateTime.ofInstant((Instant)fv.value, ZoneId.systemDefault()));
                    }
                    catch (DateTimeException | IllegalFormatException runtimeException) {}
                } else if (fv.value instanceof ZonedDateTime) {
                    try {
                        fv.text = String.format(this.DEFAULT_DT_FORMAT, fv.value);
                    }
                    catch (IllegalFormatException illegalFormatException) {
                        // empty catch block
                    }
                }
            }
            if (fv.text == null) {
                fv.text = fv.value.toString();
            }
            if (fv.text.length() > this.LENGTH_LIMIT) {
                fv.toolTip = fv.toolTip == null ? fv.text : "<html><b>" + fv.text + "</b><br>" + fv.toolTip;
            }
            if (!fv.text.startsWith("<")) {
                if (!fv.text.startsWith(" ")) {
                    fv.text = " " + fv.text;
                }
                if (!fv.text.endsWith(" ")) {
                    fv.text = fv.text + " ";
                }
            }
        }
        fv.value = null;
        return fv;
    }

    public boolean format(MonitorCell cell) {
        List<AgentChannel> channels = cell.getChannels().stream().flatMap(h -> h.getChannels().stream()).collect(Collectors.toList());
        FormattedValue fv = this.format(cell.getField(), channels);
        if (Objects.equals(fv, cell.getFormattedValue())) {
            return false;
        }
        cell.setFormattedValue(fv);
        return true;
    }

    public boolean format(MonitorCell cell, DisplayChannel channelHandle) {
        return this.format(cell);
    }

    public FormattedValue format(MonitorField field, DisplayChannel channelHandle) {
        return this.format(field, channelHandle.getChannels());
    }

    public FormattedValue merge(MonitorField field, List<FormattedValue> values) {
        switch (values.size()) {
            case 0: {
                return new FormattedValue(field.getTitle(), COLOR_FG, COLOR_BG, 0, null, false);
            }
            case 1: {
                return values.get(0);
            }
        }
        Iterator<FormattedValue> it = values.iterator();
        FormattedValue first = it.next();
        String text = first.getText();
        Color fgColor = first.getFgColor();
        Color bgColor = first.getBgColor();
        int horizontalAlignment = first.getHorizontalAlignment();
        String toolTip = first.getToolTip();
        while (it.hasNext()) {
            FormattedValue other = it.next();
            if (!Objects.equals(text, other.getText())) {
                text = TEXT_MULTI;
            }
            fgColor = this.mergeConfigColor(fgColor, other.getFgColor());
            bgColor = this.mergeStateColor(bgColor, other.getBgColor());
            if (horizontalAlignment != other.getHorizontalAlignment()) {
                horizontalAlignment = 0;
            }
            if (Objects.equals(toolTip, other.getToolTip())) continue;
            toolTip = null;
        }
        return new FormattedValue(text, fgColor, bgColor, horizontalAlignment, toolTip, false);
    }

    public Color mergeConfigColor(Color c1, Color c2) {
        return COLOR_FG.equals(c1) ? c2 : c1;
    }

    public Color mergeStateColor(Color c1, Color c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        for (Color c : COLOR_STATE.values()) {
            if (c.equals(c1)) {
                return c2;
            }
            if (!c.equals(c2)) continue;
            return c1;
        }
        return c1;
    }

    public Object getValue(MonitorField field, AgentChannel channel) {
        return field.getValue(channel);
    }

    private static String getFormatConversion(String format) {
        String[] ss;
        for (String s : ss = format.split("%")) {
            Matcher m = pFormatConversion.matcher(s);
            if (!m.matches()) continue;
            return m.group(1);
        }
        return " ";
    }

    static {
        COLOR_STATE.put(DataProviderState.OFF_LINE, COLOR_OFF);
        COLOR_STATE.put(DataProviderState.DISABLED, COLOR_DISABLED);
        COLOR_STATE.put(DataProviderState.NOT_VALIDATED, COLOR_BG);
        COLOR_STATE.put(DataProviderState.NOMINAL, COLOR_GOOD);
        COLOR_STATE.put(DataProviderState.WARNING, COLOR_WARN);
        COLOR_STATE.put(DataProviderState.ALARM, COLOR_ERR);
        pFormatConversion = Pattern.compile("(?:\\d+\\$)?[^ ]*?\\d*(?:\\.\\d*)?([a-zA-Z]{1,2})(?: .*)?");
    }

    public static final class DefaultMonitorFormat
    extends MonitorFormat {
        public final String FLOAT_FORMAT;
        public final String INT_FORMAT;
        public final String DT_FORMAT;
        public final int LENGTH_LIMIT;

        public DefaultMonitorFormat() {
            this.FLOAT_FORMAT = this.DEFAULT_FLOAT_FORMAT;
            this.INT_FORMAT = this.DEFAULT_INT_FORMAT;
            this.DT_FORMAT = this.DEFAULT_DT_FORMAT;
            this.LENGTH_LIMIT = ((MonitorFormat)this).LENGTH_LIMIT;
        }
    }
}

