/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

class ReaderInputStream
extends InputStream {
    private Reader in;
    private Writer out;
    private int pointer;
    private MyWriter writer;

    ReaderInputStream(Reader in) {
        this.in = in;
        this.writer = new MyWriter();
        this.out = new OutputStreamWriter(this.writer);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int l = this.writer.getCount() - this.pointer;
        if (l <= 0) {
            this.fillBuffer();
            l = this.writer.getCount();
            if (l == 0) {
                return -1;
            }
        }
        l = Math.min(len, l);
        System.arraycopy(this.writer.getBuf(), this.pointer, b, off, l);
        this.pointer += l;
        return l;
    }

    @Override
    public int read() throws IOException {
        if (this.pointer >= this.writer.getCount()) {
            this.fillBuffer();
            if (this.writer.getCount() == 0) {
                return -1;
            }
        }
        return this.writer.getBuf()[this.pointer++];
    }

    private void fillBuffer() throws IOException {
        int c;
        this.pointer = 0;
        this.writer.clear();
        for (int i = 0; i < 1000 && (c = this.in.read()) >= 0; ++i) {
            this.out.write(c);
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private class MyWriter
    extends ByteArrayOutputStream {
        private MyWriter() {
        }

        void clear() {
            this.count = 0;
        }

        int getCount() {
            return this.count;
        }

        byte[] getBuf() {
            return this.buf;
        }
    }
}

