/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.tree;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.freehep.jas.plugin.tree.DefaultFTree;
import org.freehep.jas.plugin.tree.DefaultFTreeNodeAdapterManager;
import org.freehep.jas.plugin.tree.FTree;
import org.freehep.jas.plugin.tree.FTreeFolderNode;
import org.freehep.jas.plugin.tree.FTreeLeafNode;
import org.freehep.jas.plugin.tree.FTreeNode;
import org.freehep.jas.plugin.tree.FTreeNodeAddedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeEvent;
import org.freehep.jas.plugin.tree.FTreeNodeListener;
import org.freehep.jas.plugin.tree.FTreeNodeSorterManager;
import org.freehep.jas.plugin.tree.FTreeNodeStructureChangedNotification;
import org.freehep.jas.plugin.tree.FTreeNodeStructureProvider;
import org.freehep.jas.plugin.tree.FTreeNodeTextChangeEvent;
import org.freehep.jas.plugin.tree.FTreePath;
import org.freehep.util.images.ImageHandler;

class DefaultFTreeNode
extends DefaultMutableTreeNode
implements FTreeNode,
FTreeNodeListener {
    private boolean allowsChildren = false;
    private boolean allowsChildrenChecked = false;
    private String name;
    private Class type;
    private FTree tree;
    private ArrayList listeners = new ArrayList();
    private String sortingString = "Default order";
    private boolean recursiveSorting = false;
    private static final Icon NOICON = ImageHandler.brokenIcon;
    private List sortedChildren;
    public boolean childrenChecked = false;
    private Hashtable keyHash = null;
    private Object nodeObject = null;

    DefaultFTreeNode(FTreeNodeAddedNotification e, FTree tree) {
        this(e.nodeName(), e.nodeClass(), e.nodeObject(), tree);
    }

    DefaultFTreeNode(String name, Class type, FTree tree) {
        this(name, type, null, tree);
    }

    DefaultFTreeNode(String name, Class type, Object obj, FTree tree) {
        this.name = name;
        this.type = type;
        this.nodeObject = obj;
        this.tree = tree;
    }

    @Override
    public Object objectForClass(Class clazz) {
        if (this.nodeObject != null && clazz.isAssignableFrom(this.nodeObject.getClass())) {
            return this.nodeObject;
        }
        return this.adapterManager().userObjectForNode(this, clazz);
    }

    @Override
    public Class type() {
        return this.type;
    }

    @Override
    public FTree tree() {
        return this.tree;
    }

    @Override
    public FTreePath path() {
        if (this.isRoot()) {
            return null;
        }
        if (((DefaultFTreeNode)this.parent()).isRoot()) {
            return new FTreePath(this.realName());
        }
        return this.parent().path().pathByAddingChild(this.realName());
    }

    @Override
    public void addKey(Object key, Object value) {
        if (this.keyHash == null) {
            this.keyHash = new Hashtable();
        }
        this.keyHash.put(key, value);
    }

    @Override
    public void removeKey(Object key) {
        if (this.keyHash != null) {
            this.keyHash.remove(key);
        }
    }

    @Override
    public Object value(Object key) {
        if (this.keyHash != null) {
            return this.keyHash.get(key);
        }
        return null;
    }

    @Override
    public void addFTreeNodeListener(FTreeNodeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeFTreeNodeListener(FTreeNodeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public List childNodes() {
        this.checkForChildren();
        return Collections.unmodifiableList(this.sortedChildren());
    }

    @Override
    public void nodeChanged(FTreeNodeEvent event) {
        FTreePath parentPath;
        this.fireFTreeNodeEvent(event);
        if (event.eventId() == 2 && ((parentPath = event.node().path().getParentPath()) == null && this.isRoot() || parentPath != null && parentPath.equals(this.path()))) {
            this.applySorting(this.sortingString(), this.isRecursiveSorting());
        }
    }

    FTreeNodeStructureProvider structureProvider() {
        return this.adapterManager().nodeStructureProvider(this);
    }

    public String realName() {
        return this.name;
    }

    public String name() {
        String text = this.adapterManager().text(this);
        if (text != null) {
            return text;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    boolean isShowingName() {
        return this.realName().equals(this.name());
    }

    public Icon icon(boolean selected, boolean expanded) {
        Icon icon = NOICON;
        icon = this.getAllowsChildren() ? this.adapterManager().adapterForClass(FTreeFolderNode.class).icon(this, icon, selected, expanded) : this.adapterManager().adapterForClass(FTreeLeafNode.class).icon(this, icon, selected, expanded);
        return this.adapterManager().icon(this, icon, selected, expanded);
    }

    Component treeCellRendererComponent(Component component, boolean sel, boolean expanded, boolean leaf, boolean hasFocus) {
        return this.adapterManager().treeCellRendererComponent(component, this, sel, expanded, leaf, hasFocus);
    }

    String toolTipMessage() {
        return this.adapterManager().toolTipMessage(this);
    }

    DefaultFTreeNode find(String childName) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            DefaultFTreeNode node = (DefaultFTreeNode)this.getChildAt(i);
            if (!node.realName().equals(childName)) continue;
            return node;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.realName();
    }

    boolean isEditable() {
        FTreeNodeTextChangeEvent evt = new FTreeNodeTextChangeEvent(this, this.name(), null, this.isShowingName());
        return this.adapterManager().isNodeEditable(evt);
    }

    @Override
    public FTreeNode parent() {
        return (FTreeNode)((Object)super.getParent());
    }

    public DefaultFTreeNode root() {
        return (DefaultFTreeNode)super.getRoot();
    }

    @Override
    public boolean getAllowsChildren() {
        if (this.isRoot()) {
            return true;
        }
        if (this.type == Object.class) {
            return true;
        }
        if (!this.allowsChildrenChecked) {
            this.allowsChildren = this.adapterManager().allowsChildren(this);
            this.allowsChildrenChecked = true;
        }
        return this.allowsChildren;
    }

    boolean childrenChecked() {
        if (this.isRoot()) {
            return true;
        }
        return this.childrenChecked;
    }

    protected void checkForChildren() {
        if (this.childrenChecked()) {
            return;
        }
        this.childrenChecked = true;
        if (this.getAllowsChildren() && this.sortedChildren().size() == 0) {
            this.adapterManager().checkForChildren(this);
        }
    }

    @Override
    public int getChildCount() {
        this.checkForChildren();
        return this.sortedChildren().size();
    }

    public Enumeration children() {
        this.checkForChildren();
        return new MyEnumeration(this.sortedChildren().iterator());
    }

    @Override
    public TreeNode getFirstChild() {
        this.checkForChildren();
        return (TreeNode)this.sortedChildren().get(0);
    }

    @Override
    public TreeNode getLastChild() {
        this.checkForChildren();
        return (TreeNode)this.sortedChildren().get(this.sortedChildren().size() - 1);
    }

    public boolean addNode(MutableTreeNode newChild) {
        DefaultFTreeNode node = (DefaultFTreeNode)newChild;
        if (this.structureProvider().addNode((FTreeNode)((Object)newChild))) {
            newChild.setParent(this);
            if (!this.sortedChildren().contains(node)) {
                int index = this.sortedChildren().size();
                FTreeNodeSorterManager.SorterComparator comparator = FTreeNodeSorterManager.sortingComparator(this.sortingString);
                if (index > 0 && comparator != null) {
                    index = Collections.binarySearch(this.sortedChildren(), node, comparator);
                    index = -index - 1;
                }
                this.sortedChildren().add(index, node);
                if (this.isRecursiveSorting()) {
                    node.setSorting(this.sortingString(), true);
                }
                node.addFTreeNodeListener(this);
            }
            this.fireFTreeNodeEvent(new FTreeNodeEvent(this, node, 0));
            return true;
        }
        return false;
    }

    public boolean removeNode(MutableTreeNode newChild) {
        if (this.structureProvider().removeNode((FTreeNode)((Object)newChild))) {
            this.sortedChildren().remove(newChild);
            DefaultFTreeNode node = (DefaultFTreeNode)newChild;
            this.fireFTreeNodeEvent(new FTreeNodeEvent(this, node, 1));
            node.removeFTreeNodeListener(this);
            return true;
        }
        return false;
    }

    @Override
    public TreeNode getChildAt(int index) {
        this.checkForChildren();
        return (TreeNode)this.sortedChildren().get(index);
    }

    @Override
    public int getIndex(TreeNode child) {
        this.checkForChildren();
        return this.sortedChildren().indexOf(child);
    }

    void setSorting(String sortingString, boolean isRecursive) {
        this.sortingString = sortingString;
        this.recursiveSorting = isRecursive;
    }

    String sortingString() {
        return this.sortingString;
    }

    boolean isRecursiveSorting() {
        return this.recursiveSorting;
    }

    private List sortedChildren() {
        if (this.sortedChildren == null) {
            this.sortedChildren = new ArrayList(this.structureProvider().nodes());
            if (this.sortedChildren.size() != 0) {
                Collections.sort(this.sortedChildren, FTreeNodeSorterManager.sortingComparator(this.sortingString()));
            }
        }
        return this.sortedChildren;
    }

    void applySorting(String sortingString, boolean recursive) {
        this.applySorting(sortingString, recursive, true);
    }

    void applySorting(String sortingString, boolean recursive, boolean finalize) {
        if (this.getAllowsChildren()) {
            this.setSorting(sortingString, recursive);
            if (this.childrenChecked()) {
                DefaultFTree tree;
                Collections.sort(this.sortedChildren(), FTreeNodeSorterManager.sortingComparator(sortingString));
                for (DefaultFTreeNode node : this.sortedChildren()) {
                    if (!this.isRecursiveSorting()) continue;
                    node.applySorting(sortingString, true, false);
                }
                if (finalize && (tree = (DefaultFTree)this.tree()).isNodeExpanded(this)) {
                    tree.treeChanged(new FTreeNodeStructureChangedNotification((Object)this, this));
                }
            }
        }
    }

    void setDefaultTree(FTree tree) {
        this.tree = tree;
    }

    void fireFTreeNodeEvent(FTreeNodeEvent event) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((FTreeNodeListener)this.listeners.get(i)).nodeChanged(event);
        }
    }

    private DefaultFTreeNodeAdapterManager adapterManager() {
        return ((DefaultFTree)this.tree()).adapterManager();
    }

    private class MyEnumeration
    implements Enumeration {
        private Iterator iter;

        MyEnumeration(Iterator iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iter.hasNext();
        }

        public Object nextElement() {
            return this.iter.next();
        }
    }
}

