/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.freehep.jas.services.PreferencesTopic;
import org.freehep.util.FreeHEPLookup;
import org.openide.util.Lookup;

class PreferencesTree
extends JTree {
    PreferencesTree(FreeHEPLookup lookup) {
        this.setModel(PreferencesTree.create(lookup));
        this.getSelectionModel().setSelectionMode(1);
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setClosedIcon(null);
        renderer.setOpenIcon(null);
        renderer.setLeafIcon(null);
        this.setCellRenderer(renderer);
    }

    PreferencesTopic getSelectedTopic() {
        if (this.getSelectionCount() == 0) {
            return null;
        }
        PrefTreeNode node = (PrefTreeNode)this.getSelectionPath().getLastPathComponent();
        return node.getTopic();
    }

    private static TreeModel create(FreeHEPLookup lookup) {
        Lookup.Template template = new Lookup.Template(PreferencesTopic.class);
        Lookup.Result result = lookup.lookup(template);
        PrefTreeNode root = new PrefTreeNode();
        for (PreferencesTopic topic : result.allInstances()) {
            String[] path = topic.path();
            PrefTreeNode node = root;
            for (int j = 0; j < path.length; ++j) {
                String name = path[j];
                PrefTreeNode newNode = node.find(name);
                if (newNode == null) {
                    newNode = new PrefTreeNode(node, name);
                }
                node = newNode;
            }
            node.setTopic(topic);
        }
        root.sort();
        return new DefaultTreeModel(root);
    }

    private static class PrefTreeNode
    implements TreeNode {
        private PrefTreeNode parent;
        private String name;
        private PreferencesTopic topic;
        private List children;
        private Map map = new TreeMap();

        PrefTreeNode(PrefTreeNode parent, String name) {
            this.parent = parent;
            this.name = name;
            parent.add(this);
        }

        PrefTreeNode() {
            this.name = "root";
        }

        public Enumeration children() {
            return Collections.enumeration(this.children);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return (TreeNode)this.children.get(childIndex);
        }

        @Override
        public int getChildCount() {
            return this.children.size();
        }

        @Override
        public int getIndex(TreeNode node) {
            return this.children.indexOf(node);
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public boolean isLeaf() {
            return this.children == null;
        }

        private void add(PrefTreeNode child) {
            this.map.put(child.name, child);
        }

        void sort() {
            if (this.map.size() > 0) {
                this.children = new ArrayList(this.map.values());
                Iterator i = this.children.iterator();
                while (i.hasNext()) {
                    ((PrefTreeNode)i.next()).sort();
                }
            }
            this.map = null;
        }

        PrefTreeNode find(String name) {
            return (PrefTreeNode)this.map.get(name);
        }

        void setTopic(PreferencesTopic topic) {
            this.topic = topic;
        }

        public String toString() {
            return this.name;
        }

        PreferencesTopic getTopic() {
            return this.topic;
        }
    }
}

