/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.basic;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class FileHelper {
    private static final int KEYSIZE = 32;
    private Class klass;
    private EventListenerList listeners = new EventListenerList();
    private boolean fireListenersOnAWTThread = true;
    private Thread thread;
    private final boolean debug = Boolean.getBoolean("debugFileHelper");

    public FileHelper(Class klass) {
        this.klass = klass;
    }

    public void addActionListener(ActionListener al) {
        this.listeners.add(ActionListener.class, al);
    }

    public void removeActionListener(ActionListener al) {
        this.listeners.remove(ActionListener.class, al);
    }

    protected void fireActionPerformed(ActionEvent e) {
        ActionListener[] al = (ActionListener[])this.listeners.getListeners(ActionListener.class);
        for (int i = 0; i < al.length; ++i) {
            al[i].actionPerformed(e);
        }
    }

    public void start() {
        this.thread = new Thread(){

            @Override
            public void run() {
                FileHelper.this.runHelper();
            }
        };
        this.thread.start();
    }

    public void stop() {
        block2: {
            this.thread.interrupt();
            try {
                Preferences prefs = Preferences.userNodeForPackage(this.klass);
                prefs.clear();
            }
            catch (BackingStoreException x) {
                if (!this.debug) break block2;
                x.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void runHelper() {
        ServerSocket socket;
        byte[] key;
        try {
            SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
            key = new byte[32];
            rand.nextBytes(key);
            socket = new ServerSocket();
            socket.bind(null);
            Preferences prefs = Preferences.userNodeForPackage(this.klass);
            prefs.putByteArray("key", key);
            prefs.putInt("port", socket.getLocalPort());
            prefs.flush();
            while (true) {
                try {}
                catch (IOException x) {
                    if (!this.debug) continue;
                    x.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (Throwable x) {
            if (this.debug) {
                x.printStackTrace();
            }
            return;
        }
        while (true) {
            Socket connection = socket.accept();
            connection.setSoTimeout(2000);
            try {
                ActionEvent e;
                block15: {
                    InputStream in = connection.getInputStream();
                    for (int i = 0; i < 32; ++i) {
                        byte ii = (byte)in.read();
                        if (ii == key[i]) continue;
                        throw new IOException("Bad key");
                    }
                    InputStreamReader reader = new InputStreamReader(in);
                    StringBuffer message = new StringBuffer();
                    while (true) {
                        int i;
                        if ((i = ((Reader)reader).read()) < 0) {
                            e = new ActionEvent(this, 0, message.toString());
                            if (this.fireListenersOnAWTThread) {
                                break;
                            }
                            break block15;
                        }
                        message.append((char)i);
                    }
                    Runnable run = new Runnable(){

                        @Override
                        public void run() {
                            FileHelper.this.fireActionPerformed(e);
                        }
                    };
                    SwingUtilities.invokeLater(run);
                    continue;
                }
                this.fireActionPerformed(e);
                continue;
            }
            finally {
                connection.close();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String message) throws IOException {
        Preferences prefs = Preferences.userNodeForPackage(this.klass);
        int port = prefs.getInt("port", 0);
        if (port == 0) {
            throw new IOException("Missing port");
        }
        byte[] key = prefs.getByteArray("key", null);
        if (key == null) {
            throw new IOException("Missing key");
        }
        Socket socket = new Socket();
        socket.setSoTimeout(2000);
        socket.connect(new InetSocketAddress(InetAddress.getLocalHost(), port));
        try {
            OutputStream out = socket.getOutputStream();
            out.write(key);
            OutputStreamWriter writer = new OutputStreamWriter(out);
            writer.write(message.toCharArray());
            ((Writer)writer).close();
            out.close();
        }
        finally {
            socket.close();
        }
    }

    public boolean isFireListenersOnAWTThread() {
        return this.fireListenersOnAWTThread;
    }

    public void setFireListenersOnAWTThread(boolean fireListenersOnAWTThread) {
        this.fireListenersOnAWTThread = fireListenersOnAWTThread;
    }
}

