/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.bus.data.Alert;

public enum LocalDBAlert {
    BatchException("BatchException", "Exception caught when persisting batch"),
    BatchRollbackException("BatchRollbackException", "Exception caught when attempting to rollback batch"),
    BatchMaxCapacity("BatchMaxCapacity", "Batch persister running at full capacity"),
    ConfigurationPersistenceException("ConfigurationServerException", "Exception when persisting configuration state"),
    WrongStatePersistence("WrongStatePersistence", "Persistence layer persists two different agent states with the same id");

    private final String id;
    private final String description;
    private final Map<String, Object> data = new HashMap<String, Object>();

    private LocalDBAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public LocalDBAlert addData(String key, Object o) {
        this.data.put(key, o);
        return this;
    }

    public Alert getAlert(String prefix, Exception ex) {
        String alertId = (prefix != null ? prefix + "_" : "") + this.id;
        if (ex != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            this.data.put("stackTrace", sw.toString());
            pw.close();
        }
        return new Alert(alertId, this.description, this.data);
    }

    public static String getFirstException(Exception ex) {
        Throwable th = ex;
        while (th.getCause() != null) {
            th = th.getCause();
        }
        return th.toString();
    }
}

