/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extension.jython;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.freehep.application.ApplicationEvent;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.studio.EventSender;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.Studio;
import org.freehep.application.studio.StudioListener;
import org.freehep.jas.event.EditorPopupEvent;
import org.freehep.jas.event.ScriptEvent;
import org.freehep.jas.extension.jython.JASInteractiveInterpreter;
import org.freehep.jas.plugin.console.Console;
import org.freehep.jas.plugin.console.ConsoleInputStream;
import org.freehep.jas.plugin.console.ConsoleOutputStream;
import org.freehep.jas.plugin.console.ConsoleService;
import org.freehep.jas.services.DynamicClassLoader;
import org.freehep.jas.services.FileHandler;
import org.freehep.jas.services.ScriptEngine;
import org.freehep.jas.services.TextEditor;
import org.freehep.jas.services.TextEditorService;
import org.freehep.jas.services.URLHandler;
import org.freehep.swing.ExtensionFileFilter;
import org.freehep.util.ClasspathUtilities;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandState;
import org.freehep.util.images.ImageHandler;
import org.freehep.util.template.Template;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;
import org.xml.sax.SAXException;

public class JythonPlugin
extends Plugin
implements FileHandler,
URLHandler,
StudioListener {
    private static boolean init = false;
    private static Icon pythonIcon = ImageHandler.getIcon((String)"python", JythonPlugin.class);
    private static Icon consoleIcon = ImageHandler.getIcon((String)"pycon", JythonPlugin.class);
    private static String mimeType = "text/python";

    public FileFilter getFileFilter() {
        return new ExtensionFileFilter(new String[]{"py", "jy"}, "Python File");
    }

    public boolean accept(File file) throws IOException {
        return file.getName().endsWith(".py") || file.getName().endsWith(".jy");
    }

    public void handleEvent(EventObject e) {
        TextEditorService te;
        if (e instanceof EditorPopupEvent) {
            final EditorPopupEvent event = (EditorPopupEvent)e;
            String type = event.getEditor().getMimeType();
            if (type.equals(mimeType)) {
                JPopupMenu menu = event.getMenu();
                JMenuItem item = new JMenuItem("Run Script", 82){

                    @Override
                    public void fireActionPerformed(ActionEvent e) {
                        PythonThread t = new PythonThread();
                        t.setPriority(5 - 1);
                        t.setFile(event.getEditor().getText());
                        t.start();
                    }
                };
                item.setAccelerator(KeyStroke.getKeyStroke(113, 0));
                item.setIcon(consoleIcon);
                menu.add(item);
            }
        } else if (e instanceof ApplicationEvent && ((ApplicationEvent)e).getID() == ApplicationEvent.INITIALIZATION_COMPLETE && (te = (TextEditorService)this.getApplication().getLookup().lookup(TextEditorService.class)) != null) {
            te.addMimeType(mimeType, pythonIcon);
        }
    }

    public void openFile(File file) throws IOException {
        TextEditorService te = (TextEditorService)this.getApplication().getLookup().lookup(TextEditorService.class);
        te.show(file, mimeType);
    }

    protected void init() throws SAXException, IOException {
        Studio app = this.getApplication();
        XMLMenuBuilder builder = app.getXMLMenuBuilder();
        URL xml = ((Object)((Object)this)).getClass().getResource("Jython.menus");
        builder.build(xml);
        Commands commands = new Commands();
        app.getCommandTargetManager().add((CommandGroup)commands);
        app.getLookup().add((Object)this);
        app.getEventSender().addEventListener((StudioListener)this, EditorPopupEvent.class);
        app.getEventSender().addEventListener((StudioListener)this, ApplicationEvent.class);
        app.getPageManager().addPageListener((PageListener)commands);
        Template map = new Template();
        map.set("title", "Python Examples");
        map.set("url", "classpath:/org/freehep/jas/extension/jython/web/examples.html");
        map.set("description", "AIDA examples written in the Python scripting language");
        app.getLookup().add((Object)map, "examples");
    }

    protected void postInit() {
        Studio app = this.getApplication();
        String prop = app.getUserProperties().getProperty("userJythonCache", "{user.home}/.{appName}/jythonCache");
        Properties sysProps = System.getProperties();
        sysProps.setProperty("python.cachedir", prop);
        sysProps.setProperty("python.packages.paths", "full.java.class.path,sun.boot.class.path,app.class.path");
        ClasspathUtilities.setFullSystemClasspathInSystemProperty((String)"full.java.class.path");
        StringBuffer appPath = new StringBuffer();
        URL[] urls = app.getExtensionLoader().getURLs();
        int i = 0;
        while (i < urls.length) {
            try {
                URI uri = new URI(urls[i].toExternalForm());
                File file = new File(uri.normalize());
                appPath.append(file.getAbsolutePath());
                if (urls.length == ++i) break;
                appPath.append(File.pathSeparatorChar);
            }
            catch (URISyntaxException x) {
                x.printStackTrace();
            }
        }
        sysProps.setProperty("app.class.path", appPath.toString());
    }

    void openConsole() {
        PythonThread t = new PythonThread();
        t.setPriority(5 - 1);
        t.start();
    }

    public boolean accept(URL url) throws IOException {
        TextEditorService editor = (TextEditorService)this.getApplication().getLookup().lookup(TextEditorService.class);
        return editor != null && (url.getFile().endsWith(".py") || url.getFile().endsWith(".jy"));
    }

    public void openURL(URL url) throws IOException {
        TextEditorService editor = (TextEditorService)this.getApplication().getLookup().lookup(TextEditorService.class);
        if (editor != null) {
            editor.show(url, mimeType);
        }
    }

    private class PythonThread
    extends Thread
    implements ScriptEngine {
        private JASInteractiveInterpreter interp;
        private String file;

        private PythonThread() {
        }

        public boolean canAccept(String mimeType) {
            return mimeType.equalsIgnoreCase(mimeType);
        }

        public void registerVariable(String name, Object value) {
            this.interp.set(name, value);
        }

        @Override
        public void run() {
            Studio app = JythonPlugin.this.getApplication();
            if (!init) {
                PythonInterpreter.initialize((Properties)app.getAppProperties(), (Properties)app.getUserProperties(), null);
                init = true;
            }
            try {
                String line;
                PySystemState state = new PySystemState();
                DynamicClassLoader compiler = (DynamicClassLoader)app.getLookup().lookup(DynamicClassLoader.class);
                if (compiler != null) {
                    state.setClassLoader(compiler.getClassLoader());
                }
                this.interp = new JASInteractiveInterpreter(state);
                ConsoleService service = (ConsoleService)app.getLookup().lookup(ConsoleService.class);
                Console console = service.createConsole("Jython", consoleIcon);
                EventSender es = app.getEventSender();
                if (es.hasListeners(ScriptEvent.class)) {
                    es.broadcast((EventObject)new ScriptEvent((ScriptEngine)this));
                }
                ConsoleOutputStream out = console.getOutputStream(null);
                this.interp.setOut((OutputStream)out);
                service.redirectStandardOutputOnThreadToConsole((Thread)this, out);
                SimpleAttributeSet red = new SimpleAttributeSet();
                red.addAttribute(StyleConstants.Foreground, Color.red);
                this.interp.setErr((OutputStream)console.getOutputStream((AttributeSet)red));
                if (this.file != null) {
                    this.interp.exec(this.file);
                }
                ConsoleInputStream in = console.getInputStream(">>> ");
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in));
                StringBuffer commands = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    if (this.interp.buffer.length() > 0) {
                        this.interp.buffer.append("\n");
                    }
                    this.interp.buffer.append(line);
                    boolean more = this.interp.runsource(this.interp.buffer.toString(), "console");
                    if (!more) {
                        this.interp.resetbuffer();
                        in.setPrompt(">>> ");
                        continue;
                    }
                    in.setPrompt("... ");
                    StringBuffer initialEntry = new StringBuffer();
                    for (int i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
                        initialEntry.append(' ');
                    }
                    if (line.endsWith(":")) {
                        initialEntry.append("  ");
                    }
                    in.setInitialEntry(initialEntry.toString());
                }
            }
            catch (Throwable t) {
                app.error("Jython thread exited", t);
            }
        }

        public void runScript(String file) {
        }

        private void setFile(String file) {
            this.file = file;
        }
    }

    public class Commands
    extends CommandProcessor
    implements PageListener {
        public void enableRun(CommandState state) {
            TextEditorService tes = (TextEditorService)JythonPlugin.this.getApplication().getLookup().lookup(TextEditorService.class);
            TextEditor te = tes.getCurrentEditor();
            state.setEnabled(te != null && mimeType.equals(te.getMimeType()));
        }

        public void onJythonConsole() {
            JythonPlugin.this.openConsole();
        }

        public void onJythonScript() {
            TextEditorService te = (TextEditorService)JythonPlugin.this.getApplication().getLookup().lookup(TextEditorService.class);
            te.show("", mimeType, null);
        }

        public void onRun() {
            TextEditorService tes = (TextEditorService)JythonPlugin.this.getApplication().getLookup().lookup(TextEditorService.class);
            TextEditor te = tes.getCurrentEditor();
            PythonThread t = new PythonThread();
            t.setPriority(5 - 1);
            t.setFile(te.getText());
            t.start();
        }

        public void pageChanged(PageEvent e) {
            this.setChanged();
        }
    }
}

