/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.tuple;

import hep.aida.IBaseTupleColumn;
import hep.aida.ITuple;
import hep.aida.ITupleColumn;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.tuple.FTuple;
import hep.aida.ref.tuple.FTupleColumn;
import hep.aida.ref.tuple.FTupleCursor;
import hep.aida.ref.tuple.HasFTuple;
import hep.aida.ref.tuple.Tuple;
import java.util.ArrayList;
import java.util.Map;
import org.freehep.util.Value;

public abstract class TupleColumn
implements IBaseTupleColumn,
FTupleColumn {
    protected Value defaultValue = null;
    protected ArrayList arrayList = new ArrayList();
    protected int arraySize;
    protected int maximumSize;
    protected int nStack;
    protected Object currentArray;
    protected int currentArrayIndex = -1;
    private boolean isOpenEnded;
    private int sizeOfLastCreatedArray;
    private int nFilled;
    private String columnName;
    private Class columnType;
    private double minValue;
    private double maxValue;
    private double meanValue;
    private double rmsValue;
    private Value colValue = new Value();
    private boolean hasDefaultValue = false;
    private int nNaN = 0;
    private boolean calculateStatistics = true;
    private Tuple tuple;

    TupleColumn(String name, Class type, Value value, String options, Tuple tuple) {
        this.tuple = tuple;
        Map optionMap = AidaUtils.parseOptions(options);
        int length = 1000;
        int maxLength = -1;
        if (optionMap.containsKey("length")) {
            length = Integer.parseInt((String)optionMap.get("length"));
        }
        if (optionMap.containsKey("maxlength")) {
            maxLength = Integer.parseInt((String)optionMap.get("maxlength"));
            if (!optionMap.containsKey("length")) {
                length = maxLength;
            }
        }
        if (optionMap.containsKey("calculatestatistics")) {
            this.calculateStatistics = Boolean.valueOf((String)optionMap.get("calculatestatistics"));
        }
        this.columnName = name;
        this.columnType = type;
        if (value != null) {
            if (value.getObject() != null && !type.isAssignableFrom(value.getType())) {
                throw new IllegalArgumentException("The default value's type " + value.getType() + " is incompatible with the TupleColumn's type " + type);
            }
            this.setDefaultValue(value);
            this.hasDefaultValue = true;
        }
        if (this.hasStatistics()) {
            this.minValue = Double.NaN;
            this.maxValue = Double.NaN;
        }
        if (length < 0) {
            throw new IllegalArgumentException("Wrong length " + length + " it must be positive!");
        }
        this.arraySize = length;
        if (maxLength < 0) {
            this.isOpenEnded = true;
        } else if (maxLength >= length) {
            this.isOpenEnded = false;
        } else {
            throw new IllegalArgumentException("Wrong maximum length " + maxLength + " it cannot be smaller than the internal arraySize " + length);
        }
        this.maximumSize = maxLength;
        this.reset();
    }

    Tuple tuple() {
        return this.tuple;
    }

    Value colValue() {
        return this.colValue;
    }

    public double minimum() {
        this.minValue(this.colValue());
        return this.colValue().getDouble();
    }

    public double maximum() {
        this.maxValue(this.colValue());
        return this.colValue().getDouble();
    }

    public double mean() {
        this.meanValue(this.colValue());
        return this.colValue().getDouble();
    }

    public double rms() {
        this.rmsValue(this.colValue());
        return this.colValue().getDouble();
    }

    @Override
    public boolean hasDefaultValue() {
        return this.hasDefaultValue;
    }

    @Override
    public String name() {
        return this.columnName;
    }

    @Override
    public Class type() {
        return this.columnType;
    }

    public void value(FTupleCursor cursor, Value value) {
        this.value(cursor.row(), value);
    }

    public abstract void value(int var1, Value var2);

    public void fill(Value value) {
        this.setValue(this.nStack, value);
    }

    public abstract void setValue(int var1, Value var2);

    public void addRow() {
        if (this.calculateStatistics && this.hasStatistics()) {
            this.value(this.nStack, this.colValue());
            double v = this.colValue().getDouble();
            if (v < this.minValue || Double.isNaN(this.minValue)) {
                this.minValue = v;
            }
            if (v > this.maxValue || Double.isNaN(this.maxValue)) {
                this.maxValue = v;
            }
            if (!Double.isNaN(v)) {
                this.meanValue += v;
                this.rmsValue += v * v;
            } else {
                ++this.nNaN;
            }
        }
        this.nFilled = this.nStack++;
        int columnLength = this.getColumnLength();
        if (this.nStack == columnLength) {
            int spaceLeft;
            if (!this.isOpenEnded() && (spaceLeft = this.maximumSize - columnLength) < this.arraySize) {
                this.sizeOfLastCreatedArray = spaceLeft;
            }
            if (this.sizeOfLastCreatedArray > 0) {
                this.createArray(this.sizeOfLastCreatedArray);
            }
        }
    }

    public void resetRow() {
        if (this.hasDefaultValue()) {
            this.fill(this.getDefaultValue());
        }
    }

    public void reset() {
        this.arrayList.clear();
        this.sizeOfLastCreatedArray = this.arraySize;
        this.createArray(this.sizeOfLastCreatedArray);
        this.setCurrentArray(0);
        this.initTupleColumn();
    }

    @Override
    public void minValue(Value value) {
        if (!this.hasStatistics() || this.nFilled < 0) {
            value.set(Double.NaN);
        } else {
            value.set(this.minValue);
        }
    }

    @Override
    public void maxValue(Value value) {
        if (!this.hasStatistics() || this.nFilled < 0) {
            value.set(Double.NaN);
        } else {
            value.set(this.maxValue);
        }
    }

    @Override
    public void meanValue(Value value) {
        if (!this.hasStatistics() || this.nFilled < 0) {
            value.set(Double.NaN);
        } else {
            value.set(this.meanValue / (double)(this.getFilledRows() - this.nNaN));
        }
    }

    @Override
    public void rmsValue(Value value) {
        if (!this.hasStatistics() || this.nFilled < 0) {
            value.set(Double.NaN);
        } else {
            double rows = this.getFilledRows() - this.nNaN;
            value.set(Math.sqrt(this.rmsValue / rows - this.meanValue * this.meanValue / rows / rows));
        }
    }

    private void initTupleColumn() {
        this.nFilled = -1;
        this.nStack = 0;
        this.meanValue = 0.0;
        this.rmsValue = 0.0;
        this.nNaN = 0;
    }

    private int getColumnLength() {
        return this.arraySize * (this.arrayList.size() - 1) + this.sizeOfLastCreatedArray;
    }

    private int getFilledRows() {
        return this.nFilled + 1;
    }

    private boolean isOpenEnded() {
        return this.isOpenEnded;
    }

    protected abstract void createArray(int var1);

    protected Value getDefaultValue() {
        return this.defaultValue;
    }

    protected void setDefaultValue(Value value) {
        this.defaultValue = new Value(value);
    }

    protected abstract boolean hasStatistics();

    protected void setCurrentArray(int index) {
        if (index < 0 || index > this.getFilledRows()) {
            String message = "Illegal cursor position. ";
            if (index < 0) {
                message = message + "next() has to be invoked after start() before accessing the data in the ITuple";
            }
            if (index > this.nFilled) {
                message = message + "Before accessing the data start() has to be invoked.";
            }
            throw new IllegalArgumentException(message);
        }
        int arrayIndex = index / this.arraySize;
        if (arrayIndex != this.currentArrayIndex) {
            this.currentArrayIndex = arrayIndex;
            this.currentArray = this.arrayList.get(this.currentArrayIndex);
            this.currentArrayUpdated();
        }
    }

    protected abstract void currentArrayUpdated();

    public void resetRows(int numberOfRows) {
        if (this.hasDefaultValue()) {
            this.fill(this.getDefaultValue());
        }
        while (numberOfRows-- > 0) {
            this.value(this.nFilled--, this.colValue());
            if (this.hasStatistics()) {
                double v = this.colValue().getDouble();
                if (Double.isNaN(v)) {
                    --this.nNaN;
                } else {
                    this.meanValue -= v;
                    this.rmsValue -= v * v;
                }
            }
            --this.nStack;
            if (!this.hasDefaultValue()) continue;
            this.fill(this.getDefaultValue());
        }
        if (this.hasStatistics()) {
            this.calculateMinMax();
        }
    }

    private void calculateMinMax() {
        this.minValue = Double.NaN;
        this.maxValue = Double.NaN;
        int rows = this.getFilledRows();
        for (int i = 0; i < rows; ++i) {
            this.value(i, this.colValue());
            double v = this.colValue().getDouble();
            if (v < this.minValue || Double.isNaN(this.minValue)) {
                this.minValue = v;
            }
            if (!(v > this.maxValue) && !Double.isNaN(this.maxValue)) continue;
            this.maxValue = v;
        }
    }

    @Override
    public void defaultValue(Value value) {
        throw new UnsupportedOperationException();
    }

    public static class TupleColumnObject
    extends TupleColumn
    implements ITupleColumn.Object {
        private Object[] data;

        TupleColumnObject(String name, Class type, Value value, String options, Tuple tuple) {
            super(name, type, value, options, tuple);
        }

        @Override
        protected void createArray(int size) {
            Object[] data = new Object[size];
            if (this.hasDefaultValue()) {
                Object def = this.getDefaultValue().getObject();
                for (int i = 0; i < size; ++i) {
                    if (def != null) continue;
                    data[i] = def;
                }
            }
            this.arrayList.add(data);
        }

        @Override
        public void value(int index, Value value) {
            this.setCurrentArray(index);
            value.set(this.data[index % this.arraySize]);
        }

        @Override
        public void setValue(int index, Value value) {
            try {
                this.setCurrentArray(index);
                this.data[index % this.arraySize] = value.getObject();
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("Wrong argument for TupleColumnObject");
            }
        }

        @Override
        protected boolean hasStatistics() {
            return false;
        }

        @Override
        public void defaultValue(Value value) {
            if (this.hasDefaultValue()) {
                value.set(this.getDefaultValue().getObject());
            }
        }

        @Override
        protected void currentArrayUpdated() {
            this.data = (Object[])this.currentArray;
        }

        public void fill(Object value) throws IllegalArgumentException {
            this.colValue().set(value);
            this.fill(this.colValue());
        }

        public Object value() {
            this.value(this.tuple().internalCursor(), this.colValue());
            return this.colValue().getObject();
        }

        public Object defaultValue() {
            this.defaultValue(this.colValue());
            return this.colValue().getObject();
        }

        public Object fillableObject() {
            return this.defaultValue();
        }
    }

    public static class TupleColumnFolder
    extends TupleColumn
    implements ITupleColumn.ITuple,
    HasFTuple {
        private int index;
        private boolean indexCalculated = false;

        TupleColumnFolder(String name, Tuple folderTuple, String options, Tuple parentTuple) {
            super(name, ITuple.class, new Value().set((Object)folderTuple), "length=1; maxlength=2", parentTuple);
        }

        private int index() {
            if (!this.indexCalculated) {
                this.index = this.tuple().findColumn(this.name());
                this.indexCalculated = true;
            }
            return this.index;
        }

        @Override
        protected void createArray(int size) {
            throw new UnsupportedOperationException("createArray not supported for TupleColumnFolder");
        }

        @Override
        public void value(int index, Value value) {
            value.set((Object)((Tuple)this.getDefaultValue().getObject()));
        }

        @Override
        public void fill(Value value) {
            throw new UnsupportedOperationException("fill not supported for TupleColumnFolder");
        }

        @Override
        public void setValue(int index, Value value) {
            throw new UnsupportedOperationException("setValue not supported for TupleColumnFolder");
        }

        @Override
        public FTuple fTuple() {
            return (FTuple)this.value();
        }

        public void fill(ITuple tp) {
            ITuple folder = this.tuple().findTuple(this.index());
            tp.start();
            while (tp.next()) {
                for (int i = 0; i < tp.columns(); ++i) {
                    Class columnType = tp.columnType(i);
                    if (columnType == Integer.TYPE) {
                        folder.fill(i, tp.getInt(i));
                        continue;
                    }
                    if (columnType == Short.TYPE) {
                        folder.fill(i, tp.getShort(i));
                        continue;
                    }
                    if (columnType == Long.TYPE) {
                        folder.fill(i, tp.getLong(i));
                        continue;
                    }
                    if (columnType == Float.TYPE) {
                        folder.fill(i, tp.getFloat(i));
                        continue;
                    }
                    if (columnType == Double.TYPE) {
                        folder.fill(i, tp.getDouble(i));
                        continue;
                    }
                    if (columnType == Boolean.TYPE) {
                        folder.fill(i, tp.getBoolean(i));
                        continue;
                    }
                    if (columnType == Byte.TYPE) {
                        folder.fill(i, tp.getByte(i));
                        continue;
                    }
                    if (columnType == Character.TYPE) {
                        folder.fill(i, tp.getChar(i));
                        continue;
                    }
                    if (columnType == ITuple.class) {
                        Tuple tOld = (Tuple)tp.getObject(i);
                        folder.fill(i, (Object)tOld);
                        continue;
                    }
                    folder.fill(i, tp.getObject(i));
                }
                folder.addRow();
            }
        }

        public ITuple value() {
            return (ITuple)this.tuple().getObject(this.index());
        }

        public ITuple defaultValue() {
            return (ITuple)this.tuple().columnDefaultValue(this.index());
        }

        public ITuple fillableObject() {
            return this.tuple().findTuple(this.index());
        }

        @Override
        protected boolean hasStatistics() {
            return false;
        }

        @Override
        private int getColumnLength() {
            return -1;
        }

        @Override
        private int getFilledRows() {
            return -1;
        }

        @Override
        private boolean isOpenEnded() {
            return false;
        }

        @Override
        protected void setCurrentArray(int index) {
            throw new RuntimeException("Unsupported method");
        }

        @Override
        public void addRow() {
        }

        @Override
        public void resetRow() {
        }

        @Override
        public void resetRows(int numberOfRows) {
        }

        @Override
        public void reset() {
        }

        @Override
        public void defaultValue(Value value) {
            value.set(this.getDefaultValue().getObject());
        }

        @Override
        protected void currentArrayUpdated() {
        }
    }

    public static class TupleColumnString
    extends TupleColumn
    implements ITupleColumn.String {
        private String[] data;

        TupleColumnString(String name, Value value, String options, Tuple tuple) {
            super(name, String.class, value, options, tuple);
        }

        @Override
        protected void createArray(int size) {
            String[] data = new String[size];
            if (this.hasDefaultValue()) {
                for (int i = 0; i < size; ++i) {
                    data[i] = this.getDefaultValue().getString();
                }
            }
            this.arrayList.add(data);
        }

        @Override
        public void value(int index, Value value) {
            this.setCurrentArray(index);
            value.set(this.data[index % this.arraySize]);
        }

        @Override
        public void setValue(int index, Value value) {
            try {
                this.setCurrentArray(index);
                this.data[index % this.arraySize] = value.getString();
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("Wrong argument for TupleColumnString");
            }
        }

        @Override
        protected boolean hasStatistics() {
            return false;
        }

        @Override
        public void defaultValue(Value value) {
            if (this.hasDefaultValue()) {
                value.set(this.getDefaultValue().getString());
            }
        }

        @Override
        protected void currentArrayUpdated() {
            this.data = (String[])this.currentArray;
        }

        public void fill(String value) throws IllegalArgumentException {
            this.colValue().set(value);
            this.fill(this.colValue());
        }

        public String value() {
            this.value(this.tuple().internalCursor(), this.colValue());
            return this.colValue().getString();
        }

        public String defaultValue() {
            this.defaultValue(this.colValue());
            return this.colValue().getString();
        }

        public String fillableObject() {
            return this.defaultValue();
        }
    }

    public static class TupleColumnChar
    extends TupleColumn
    implements ITupleColumn.C {
        private char[] data;

        TupleColumnChar(String name, Value value, String options, Tuple tuple) {
            super(name, Character.TYPE, value, options, tuple);
        }

        @Override
        protected void createArray(int size) {
            char[] data = new char[size];
            if (this.hasDefaultValue()) {
                for (int i = 0; i < size; ++i) {
                    data[i] = this.getDefaultValue().getChar();
                }
            }
            this.arrayList.add(data);
        }

        @Override
        public void value(int index, Value value) {
            this.setCurrentArray(index);
            value.set(this.data[index % this.arraySize]);
        }

        @Override
        public void setValue(int index, Value value) {
            try {
                this.setCurrentArray(index);
                this.data[index % this.arraySize] = value.getChar();
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("Wrong argument for TupleColumnChar");
            }
        }

        @Override
        protected boolean hasStatistics() {
            return false;
        }

        @Override
        public void defaultValue(Value value) {
            if (this.hasDefaultValue()) {
                value.set(this.getDefaultValue().getChar());
            }
        }

        @Override
        protected void currentArrayUpdated() {
            this.data = (char[])this.currentArray;
        }

        public void fill(char value) throws IllegalArgumentException {
            this.colValue().set(value);
            this.fill(this.colValue());
        }

        public char value() {
            this.value(this.tuple().internalCursor(), this.colValue());
            return this.colValue().getChar();
        }

        public char defaultValue() {
            this.defaultValue(this.colValue());
            return this.colValue().getChar();
        }

        public char fillableObject() {
            return this.defaultValue();
        }
    }

    public static class TupleColumnLong
    extends TupleColumn
    implements ITupleColumn.L {
        private long[] data;

        TupleColumnLong(String name, Value value, String options, Tuple tuple) {
            super(name, Long.TYPE, value, options, tuple);
        }

        @Override
        protected void createArray(int size) {
            long[] data = new long[size];
            if (this.hasDefaultValue()) {
                for (int i = 0; i < size; ++i) {
                    data[i] = this.getDefaultValue().getLong();
                }
            }
            this.arrayList.add(data);
        }

        @Override
        public void value(int index, Value value) {
            this.setCurrentArray(index);
            value.set(this.data[index % this.arraySize]);
        }

        @Override
        public void setValue(int index, Value value) {
            try {
                this.setCurrentArray(index);
                this.data[index % this.arraySize] = value.getLong();
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("Wrong argument for TupleColumnLong");
            }
        }

        @Override
        protected boolean hasStatistics() {
            return true;
        }

        @Override
        public void defaultValue(Value value) {
            if (this.hasDefaultValue()) {
                value.set(this.getDefaultValue().getLong());
            }
        }

        @Override
        protected void currentArrayUpdated() {
            this.data = (long[])this.currentArray;
        }

        public void fill(long value) throws IllegalArgumentException {
            this.colValue().set(value);
            this.fill(this.colValue());
        }

        public long value() {
            this.value(this.tuple().internalCursor(), this.colValue());
            return this.colValue().getInt();
        }

        public long defaultValue() {
            this.defaultValue(this.colValue());
            return this.colValue().getInt();
        }

        public long fillableObject() {
            return this.defaultValue();
        }
    }

    public static class TupleColumnInt
    extends TupleColumn
    implements ITupleColumn.I {
        private int[] data;

        TupleColumnInt(String name, Value value, String options, Tuple tuple) {
            super(name, Integer.TYPE, value, options, tuple);
        }

        @Override
        protected void createArray(int size) {
            int[] data = new int[size];
            if (this.hasDefaultValue()) {
                for (int i = 0; i < size; ++i) {
                    data[i] = this.getDefaultValue().getInt();
                }
            }
            this.arrayList.add(data);
        }

        @Override
        public void value(int index, Value value) {
            this.setCurrentArray(index);
            value.set(this.data[index % this.arraySize]);
        }

        @Override
        public void setValue(int index, Value value) {
            try {
                this.setCurrentArray(index);
                this.data[index % this.arraySize] = value.getInt();
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("Wrong argument for TupleColumnInt");
            }
        }

        @Override
        protected boolean hasStatistics() {
            return true;
        }

        @Override
        public void defaultValue(Value value) {
            if (this.hasDefaultValue()) {
                value.set(this.getDefaultValue().getInt());
            }
        }

        @Override
        protected void currentArrayUpdated() {
            this.data = (int[])this.currentArray;
        }

        public void fill(int value) throws IllegalArgumentException {
            this.colValue().set(value);
            this.fill(this.colValue());
        }

        public int value() {
            this.value(this.tuple().internalCursor(), this.colValue());
            return this.colValue().getInt();
        }

        public int defaultValue() {
            this.defaultValue(this.colValue());
            return this.colValue().getInt();
        }

        public int fillableObject() {
            return this.defaultValue();
        }
    }

    public static class TupleColumnShort
    extends TupleColumn
    implements ITupleColumn.S {
        private short[] data;

        TupleColumnShort(String name, Value value, String options, Tuple tuple) {
            super(name, Short.TYPE, value, options, tuple);
        }

        @Override
        protected void createArray(int size) {
            short[] data = new short[size];
            if (this.hasDefaultValue()) {
                for (int i = 0; i < size; ++i) {
                    data[i] = this.getDefaultValue().getShort();
                }
            }
            this.arrayList.add(data);
        }

        @Override
        public void value(int index, Value value) {
            this.setCurrentArray(index);
            short[] data = (short[])this.currentArray;
            value.set(data[index % this.arraySize]);
        }

        @Override
        public void setValue(int index, Value value) {
            try {
                this.setCurrentArray(index);
                short[] data = (short[])this.currentArray;
                data[index % this.arraySize] = value.getShort();
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("Wrong argument for TupleColumnShort");
            }
        }

        @Override
        protected boolean hasStatistics() {
            return true;
        }

        @Override
        public void defaultValue(Value value) {
            if (this.hasDefaultValue()) {
                value.set(this.getDefaultValue().getShort());
            }
        }

        @Override
        protected void currentArrayUpdated() {
            this.data = (short[])this.currentArray;
        }

        public void fill(short value) throws IllegalArgumentException {
            this.colValue().set(value);
            this.fill(this.colValue());
        }

        public short value() {
            this.value(this.tuple().internalCursor(), this.colValue());
            return this.colValue().getShort();
        }

        public short defaultValue() {
            this.defaultValue(this.colValue());
            return this.colValue().getShort();
        }

        public short fillableObject() {
            return this.defaultValue();
        }
    }

    public static class TupleColumnByte
    extends TupleColumn
    implements ITupleColumn.B {
        private byte[] data;

        TupleColumnByte(String name, Value value, String options, Tuple tuple) {
            super(name, Byte.TYPE, value, options, tuple);
        }

        @Override
        protected void createArray(int size) {
            byte[] data = new byte[size];
            if (this.hasDefaultValue()) {
                for (int i = 0; i < size; ++i) {
                    data[i] = this.getDefaultValue().getByte();
                }
            }
            this.arrayList.add(data);
        }

        @Override
        public void value(int index, Value value) {
            this.setCurrentArray(index);
            value.set(this.data[index % this.arraySize]);
        }

        @Override
        public void setValue(int index, Value value) {
            try {
                this.setCurrentArray(index);
                this.data[index % this.arraySize] = value.getByte();
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("Wrong argument for TupleColumnByte " + cce.getMessage());
            }
        }

        @Override
        protected boolean hasStatistics() {
            return true;
        }

        @Override
        public void defaultValue(Value value) {
            if (this.hasDefaultValue()) {
                value.set(this.getDefaultValue().getByte());
            }
        }

        @Override
        protected void currentArrayUpdated() {
            this.data = (byte[])this.currentArray;
        }

        public void fill(byte value) throws IllegalArgumentException {
            this.colValue().set(value);
            this.fill(this.colValue());
        }

        public byte value() {
            this.value(this.tuple().internalCursor(), this.colValue());
            return this.colValue().getByte();
        }

        public byte defaultValue() {
            this.defaultValue(this.colValue());
            return this.colValue().getByte();
        }

        public byte fillableObject() {
            return this.defaultValue();
        }
    }

    public static class TupleColumnDouble
    extends TupleColumn
    implements ITupleColumn.D {
        private double[] data;

        TupleColumnDouble(String name, Value value, String options, Tuple tuple) {
            super(name, Double.TYPE, value, options, tuple);
        }

        @Override
        protected void createArray(int size) {
            double[] data = new double[size];
            if (this.hasDefaultValue()) {
                for (int i = 0; i < size; ++i) {
                    data[i] = this.getDefaultValue().getDouble();
                }
            }
            this.arrayList.add(data);
        }

        @Override
        public void value(int index, Value value) {
            this.setCurrentArray(index);
            value.set(this.data[index % this.arraySize]);
        }

        @Override
        public void setValue(int index, Value value) {
            try {
                this.setCurrentArray(index);
                this.data[index % this.arraySize] = value.getDouble();
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("Wrong argument for TupleColumnDouble");
            }
        }

        @Override
        protected boolean hasStatistics() {
            return true;
        }

        @Override
        public void defaultValue(Value value) {
            if (this.hasDefaultValue()) {
                value.set(this.getDefaultValue().getDouble());
            }
        }

        @Override
        protected void currentArrayUpdated() {
            this.data = (double[])this.currentArray;
        }

        public void fill(double value) throws IllegalArgumentException {
            this.colValue().set(value);
            this.fill(this.colValue());
        }

        public double value() {
            this.value(this.tuple().internalCursor(), this.colValue());
            return this.colValue().getDouble();
        }

        public double defaultValue() {
            this.defaultValue(this.colValue());
            return this.colValue().getDouble();
        }

        public double fillableObject() {
            return this.defaultValue();
        }
    }

    public static class TupleColumnFloat
    extends TupleColumn
    implements ITupleColumn.F {
        private float[] data;

        TupleColumnFloat(String name, Value value, String options, Tuple tuple) {
            super(name, Float.TYPE, value, options, tuple);
        }

        @Override
        protected void createArray(int size) {
            float[] data = new float[size];
            if (this.hasDefaultValue()) {
                for (int i = 0; i < size; ++i) {
                    data[i] = this.getDefaultValue().getFloat();
                }
            }
            this.arrayList.add(data);
        }

        @Override
        public void value(int index, Value value) {
            this.setCurrentArray(index);
            value.set(this.data[index % this.arraySize]);
        }

        @Override
        public void setValue(int index, Value value) {
            try {
                this.setCurrentArray(index);
                this.data[index % this.arraySize] = value.getFloat();
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("Wrong argument for TupleColumnFloat");
            }
        }

        @Override
        protected boolean hasStatistics() {
            return true;
        }

        @Override
        public void defaultValue(Value value) {
            if (this.hasDefaultValue()) {
                value.set(this.getDefaultValue().getFloat());
            }
        }

        @Override
        protected void currentArrayUpdated() {
            this.data = (float[])this.currentArray;
        }

        public void fill(float value) throws IllegalArgumentException {
            this.colValue().set(value);
            this.fill(this.colValue());
        }

        public float value() {
            this.value(this.tuple().internalCursor(), this.colValue());
            return this.colValue().getFloat();
        }

        public float defaultValue() {
            this.defaultValue(this.colValue());
            return this.colValue().getFloat();
        }

        public float fillableObject() {
            return this.defaultValue();
        }
    }

    public static class TupleColumnBoolean
    extends TupleColumn
    implements ITupleColumn.Z {
        private boolean[] data;

        TupleColumnBoolean(String name, Value value, String options, Tuple tuple) {
            super(name, Boolean.TYPE, value, options, tuple);
        }

        @Override
        protected void createArray(int size) {
            boolean[] data = new boolean[size];
            if (this.hasDefaultValue()) {
                for (int i = 0; i < size; ++i) {
                    data[i] = this.getDefaultValue().getBoolean();
                }
            }
            this.arrayList.add(data);
        }

        @Override
        public void value(int index, Value value) {
            this.setCurrentArray(index);
            value.set(this.data[index % this.arraySize]);
        }

        @Override
        public void setValue(int index, Value value) {
            try {
                this.setCurrentArray(index);
                this.data[index % this.arraySize] = value.getBoolean();
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("Wrong argument for TupleColumnBoolean");
            }
        }

        @Override
        protected boolean hasStatistics() {
            return false;
        }

        @Override
        public void defaultValue(Value value) {
            if (this.hasDefaultValue()) {
                value.set(this.getDefaultValue().getBoolean());
            }
        }

        @Override
        protected void currentArrayUpdated() {
            this.data = (boolean[])this.currentArray;
        }

        public void fill(boolean value) throws IllegalArgumentException {
            this.colValue().set(value);
            this.fill(this.colValue());
        }

        public boolean value() {
            this.value(this.tuple().internalCursor(), this.colValue());
            return this.colValue().getBoolean();
        }

        public boolean defaultValue() {
            this.defaultValue(this.colValue());
            return this.colValue().getBoolean();
        }

        public boolean fillableObject() {
            return this.defaultValue();
        }
    }
}

