/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.registry;

import hep.aida.ref.plotter.style.registry.IStyleStore;
import hep.aida.ref.plotter.style.registry.StyleStoreXMLReader;
import hep.aida.ref.plotter.style.registry.XMLStyleStore;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.freehep.application.RecentItemTextField;
import org.freehep.application.studio.Studio;
import org.jdom.JDOMException;

public class CreateStyleStorePanel
extends JPanel {
    private Component parent;
    private String title;
    private JPanel thisPanel;
    private JPanel dbPanel;
    private JTextField storeName = new JTextField(15);
    private RecentItemTextField inputFile;
    private JFileChooser inputChooser = new JFileChooser();
    private JButton browse;
    private RecentItemTextField inputDB;
    private JTextField inputUser = new JTextField(20);
    private JPasswordField inputPass = new JPasswordField(20);
    private JTextField inputTable = new JTextField(20);
    private JTextField inputColumn = new JTextField(20);
    private JRadioButton createNew;
    private JRadioButton createFromFile;
    private JRadioButton createFromDB;

    public CreateStyleStorePanel() {
        this(null, "Create Style Store");
    }

    public CreateStyleStorePanel(Component parent) {
        this(parent, "Create Style Store");
    }

    public CreateStyleStorePanel(Component parent, String title) {
        this(parent, title, new String[]{XMLStyleStore.TYPE});
    }

    public CreateStyleStorePanel(String title, String[] types) {
        this(null, title, types);
    }

    public CreateStyleStorePanel(Component parent, String title, String[] types) {
        this.parent = parent;
        this.title = title;
        this.thisPanel = this;
        this.initComponents();
    }

    private void initComponents() {
        this.inputFile = new RecentItemTextField("hep.aida.ref.plotter.style.registry.CreateStyleStorePanel.InputFile", 15, false);
        this.inputFile.setMinWidth(30);
        if (this.inputFile.getItemCount() <= 0) {
            this.inputFile.setText("ftp://ftp.slac.stanford.edu/software/jas/JAS3/XMLStyleStore.xml");
            this.inputFile.saveState();
        }
        this.inputDB = new RecentItemTextField("hep.aida.ref.plotter.style.registry.CreateStyleStorePanel.InputDB", 15, false);
        this.inputDB.setMinWidth(30);
        if (this.inputDB.getItemCount() <= 0) {
            this.inputDB.setText("jdbc:oracle:thin:@glast-oracle01.slac.stanford.edu:1521:GLASTP");
            this.inputDB.saveState();
        }
        this.browse = new JButton("Browse...");
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String fileName = CreateStyleStorePanel.this.inputFile.getText();
                int returnVal = CreateStyleStorePanel.this.inputChooser.showOpenDialog(CreateStyleStorePanel.this.thisPanel);
                if (returnVal == 0) {
                    File file = CreateStyleStorePanel.this.inputChooser.getSelectedFile();
                    fileName = file.getAbsolutePath();
                    CreateStyleStorePanel.this.inputFile.setText(fileName);
                }
            }
        });
        this.createNew = new JRadioButton("Create New StyleStore.  Name:");
        this.createNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ev.getSource() instanceof JRadioButton) {
                    boolean selected = ((JRadioButton)ev.getSource()).isSelected();
                    CreateStyleStorePanel.this.storeName.setEditable(selected);
                    if (selected) {
                        CreateStyleStorePanel.this.inputDB.setEnabled(!selected);
                        CreateStyleStorePanel.this.inputFile.setEnabled(!selected);
                        CreateStyleStorePanel.this.browse.setEnabled(!selected);
                    }
                }
            }
        });
        this.createFromFile = new JRadioButton("Read StyleStore from File ");
        this.createFromFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ev.getSource() instanceof JRadioButton) {
                    boolean selected = ((JRadioButton)ev.getSource()).isSelected();
                    CreateStyleStorePanel.this.inputFile.setEnabled(selected);
                    CreateStyleStorePanel.this.browse.setEnabled(selected);
                    if (selected) {
                        CreateStyleStorePanel.this.storeName.setEditable(!selected);
                        CreateStyleStorePanel.this.inputDB.setEnabled(!selected);
                    }
                }
            }
        });
        this.createFromDB = new JRadioButton("Read StyleStore from DB ");
        this.createFromDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ev.getSource() instanceof JRadioButton) {
                    boolean selected = ((JRadioButton)ev.getSource()).isSelected();
                    CreateStyleStorePanel.this.inputDB.setEnabled(selected);
                    if (selected) {
                        CreateStyleStorePanel.this.inputFile.setEnabled(!selected);
                        CreateStyleStorePanel.this.browse.setEnabled(!selected);
                        CreateStyleStorePanel.this.storeName.setEditable(!selected);
                    }
                }
            }
        });
        ButtonGroup rbg = new ButtonGroup();
        rbg.add(this.createNew);
        rbg.add(this.createFromFile);
        rbg.add(this.createFromDB);
        this.createNew.setSelected(true);
        this.inputFile.setEnabled(false);
        this.inputDB.setEnabled(false);
        this.browse.setEnabled(false);
        this.storeName.setEditable(true);
        this.setBorder(new TitledBorder(new EtchedBorder(), this.title));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.add((Component)this.createNew, gbc);
        gbc.gridx = 1;
        this.add((Component)this.storeName, gbc);
        gbc.gridy = 1;
        gbc.gridx = 0;
        this.add((Component)this.createFromFile, gbc);
        gbc.gridx = 1;
        this.add((Component)this.inputFile, gbc);
        gbc.gridx = 2;
        this.add((Component)this.browse, gbc);
        gbc.gridy = 2;
        gbc.gridx = 0;
        this.add((Component)this.createFromDB, gbc);
        gbc.gridx = 1;
        this.add((Component)this.inputDB, gbc);
        this.inputUser.setText("GLASTGEN");
        this.inputTable.setText("STYLES");
        this.inputColumn.setText("STYLE");
        this.dbPanel = new JPanel();
        this.dbPanel.setLayout(new GridBagLayout());
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.dbPanel.add((Component)new JLabel("User Name: "), gbc);
        gbc.gridx = 1;
        this.dbPanel.add((Component)this.inputUser, gbc);
        gbc.gridy = 1;
        gbc.gridx = 0;
        this.dbPanel.add((Component)new JLabel("Password: "), gbc);
        gbc.gridx = 1;
        this.dbPanel.add((Component)this.inputPass, gbc);
        gbc.gridy = 2;
        gbc.gridx = 0;
        this.dbPanel.add((Component)new JLabel("Table: "), gbc);
        gbc.gridx = 1;
        this.dbPanel.add((Component)this.inputTable, gbc);
        gbc.gridy = 3;
        gbc.gridx = 0;
        this.dbPanel.add((Component)new JLabel("Column: "), gbc);
        gbc.gridx = 1;
        this.dbPanel.add((Component)this.inputColumn, gbc);
    }

    IStyleStore createStoreAction() {
        String sn = this.storeName.getText();
        if (sn == null || sn.trim().equals("")) {
            throw new IllegalArgumentException("Store Name can not be Empty, please correct");
        }
        XMLStyleStore store = new XMLStyleStore(this.storeName.getText(), XMLStyleStore.TYPE, false);
        return store;
    }

    IStyleStore readStoreAction() throws IOException, JDOMException {
        IStyleStore store = null;
        Object file = null;
        String fileName = this.inputFile.getText();
        store = StyleStoreXMLReader.restoreFromFile(fileName);
        return store;
    }

    IStyleStore dbStoreAction() throws Exception {
        IStyleStore store = null;
        String dbTitle = "DB Connection";
        String fileName = this.inputDB.getText();
        int reply = JOptionPane.showOptionDialog(this, this.dbPanel, dbTitle, 0, -1, null, new String[]{"Ok", "Cancel"}, "Cancel");
        if (reply == 0) {
            String user = this.inputUser.getText();
            String pass = this.inputPass.getText();
            String table = this.inputTable.getText();
            String col = this.inputColumn.getText();
            store = StyleStoreXMLReader.restoreFromDB(fileName, user, pass, table, col);
        }
        return store;
    }

    public IStyleStore createStore() throws IOException, JDOMException {
        IStyleStore store = null;
        Component comp = this.parent;
        if (comp == null) {
            comp = SwingUtilities.getAncestorOfClass(Frame.class, this);
        }
        boolean wrongInput = true;
        while (wrongInput) {
            int reply = JOptionPane.showOptionDialog(comp, this, this.title, 0, -1, null, new String[]{"Ok", "Cancel"}, "Cancel");
            try {
                if (reply == 0) {
                    String fileName = this.inputFile.getText();
                    if (this.createNew.isSelected()) {
                        store = this.createStoreAction();
                    } else if (this.createFromFile.isSelected()) {
                        store = this.readStoreAction();
                        this.inputFile.saveState();
                    } else if (this.createFromDB.isSelected()) {
                        store = this.dbStoreAction();
                        this.inputDB.saveState();
                    }
                }
                wrongInput = false;
            }
            catch (Exception e) {
                String message = "Error: " + e.getMessage();
                if (this.parent != null && this.parent instanceof Studio) {
                    Studio cfr_ignored_0 = (Studio)this.parent;
                    Studio.error((Component)this, (String)message, (Throwable)e);
                }
                e.printStackTrace();
            }
        }
        return store;
    }
}

