/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram.binner;

import hep.aida.ref.histogram.binner.AbstractBinner2D;
import hep.aida.ref.histogram.binner.EfficiencyBinnerUtils;

public class EfficiencyBinner2D
extends AbstractBinner2D {
    private int[][] entries;
    private double[][] heights;
    private double[][] meansX;
    private double[][] rmssX;
    private double[][] meansY;
    private double[][] rmssY;
    private int xBins;
    private int yBins;

    public EfficiencyBinner2D(int xBins, int yBins) {
        if (xBins < 0) {
            throw new IllegalArgumentException("Number of bins cannot be negative!!! " + xBins);
        }
        if (yBins < 0) {
            throw new IllegalArgumentException("Number of bins cannot be negative!!! " + yBins);
        }
        this.setNumberOfBins(xBins, yBins);
    }

    @Override
    public void fill(int xBin, int yBin, double x, double y, double weight) {
        if (weight < 0.0 || weight > 1.0) {
            throw new IllegalArgumentException("Wrong weight " + weight + " !! It has to be between 0 and 1");
        }
        int[] nArray = this.entries[xBin];
        int n = yBin;
        nArray[n] = nArray[n] + 1;
        double[] dArray = this.heights[xBin];
        int n2 = yBin;
        dArray[n2] = dArray[n2] + weight;
        double[] dArray2 = this.meansX[xBin];
        int n3 = yBin;
        dArray2[n3] = dArray2[n3] + x * weight;
        double[] dArray3 = this.rmssX[xBin];
        int n4 = yBin;
        dArray3[n4] = dArray3[n4] + x * x * weight;
        double[] dArray4 = this.meansY[xBin];
        int n5 = yBin;
        dArray4[n5] = dArray4[n5] + y * weight;
        double[] dArray5 = this.rmssY[xBin];
        int n6 = yBin;
        dArray5[n6] = dArray5[n6] + y * y * weight;
    }

    @Override
    public void clear() {
        this.createArrays(this.xBins, this.yBins);
    }

    private void setNumberOfBins(int xBins, int yBins) {
        this.xBins = xBins;
        this.yBins = yBins;
        this.createArrays(xBins, yBins);
    }

    @Override
    public int entries(int xBin, int yBin) {
        return this.entries[xBin][yBin];
    }

    @Override
    public double height(int xBin, int yBin) {
        if (this.entries(xBin, yBin) > 0) {
            return this.heights[xBin][yBin] / (double)this.entries(xBin, yBin);
        }
        return 0.0;
    }

    @Override
    public double plusError(int xBin, int yBin) {
        return EfficiencyBinnerUtils.H95CL(this.heights[xBin][yBin], this.entries[xBin][yBin], 1);
    }

    @Override
    public double minusError(int xBin, int yBin) {
        return EfficiencyBinnerUtils.H95CL(this.heights[xBin][yBin], this.entries[xBin][yBin], 2);
    }

    @Override
    public double meanX(int xBin, int yBin) {
        double h = this.heights[xBin][yBin];
        if (h != 0.0) {
            return this.meansX[xBin][yBin] / h;
        }
        return Double.NaN;
    }

    @Override
    public double meanY(int xBin, int yBin) {
        double h = this.heights[xBin][yBin];
        if (h != 0.0) {
            return this.meansY[xBin][yBin] / h;
        }
        return Double.NaN;
    }

    @Override
    public double rmsX(int xBin, int yBin) {
        double h = this.heights[xBin][yBin];
        double m = this.meanX(xBin, yBin);
        if (h != 0.0) {
            return Math.sqrt(Math.abs(this.rmssX[xBin][yBin] / h - m * m));
        }
        return Double.NaN;
    }

    @Override
    public double rmsY(int xBin, int yBin) {
        double h = this.heights[xBin][yBin];
        double m = this.meanY(xBin, yBin);
        if (h != 0.0) {
            return Math.sqrt(Math.abs(this.rmssY[xBin][yBin] / h - m * m));
        }
        return Double.NaN;
    }

    @Override
    public void setBinContent(int xBin, int yBin, int entries, double height, double plusError, double minusError, double meanX, double rmsX, double meanY, double rmsY) {
        this.entries[xBin][yBin] = entries;
        this.heights[xBin][yBin] = !Double.isNaN(height) ? height * (double)entries : (double)(entries * entries);
        this.meansX[xBin][yBin] = 0.0;
        this.rmssX[xBin][yBin] = 0.0;
        this.meansY[xBin][yBin] = 0.0;
        this.rmssY[xBin][yBin] = 0.0;
        if (this.heights[xBin][yBin] != 0.0) {
            this.meansX[xBin][yBin] = meanX * this.heights[xBin][yBin];
            this.rmssX[xBin][yBin] = rmsX * rmsX * this.heights[xBin][yBin] + meanX * meanX * this.heights[xBin][yBin];
            this.meansY[xBin][yBin] = meanY * this.heights[xBin][yBin];
            this.rmssY[xBin][yBin] = rmsY * rmsY * this.heights[xBin][yBin] + meanY * meanY * this.heights[xBin][yBin];
        }
    }

    @Override
    public void scale(double scaleFactor) {
        for (int xBin = 0; xBin < this.xBins; ++xBin) {
            int yBin = 0;
            while (yBin < this.yBins) {
                double[] dArray = this.heights[xBin];
                int n = yBin;
                dArray[n] = dArray[n] * scaleFactor;
                double[] dArray2 = this.meansX[xBin];
                int n2 = yBin;
                dArray2[n2] = dArray2[n2] * scaleFactor;
                double[] dArray3 = this.rmssX[xBin];
                int n3 = yBin;
                dArray3[n3] = dArray3[n3] * scaleFactor;
                double[] dArray4 = this.meansY[xBin];
                int n4 = yBin;
                dArray4[n4] = dArray4[n4] * scaleFactor;
                double[] dArray5 = this.rmssY[xBin];
                int n5 = yBin++;
                dArray5[n5] = dArray5[n5] * scaleFactor;
            }
        }
    }

    private void createArrays(int xBins, int yBins) {
        this.entries = new int[xBins][yBins];
        this.heights = new double[xBins][yBins];
        this.meansX = new double[xBins][yBins];
        this.rmssX = new double[xBins][yBins];
        this.meansY = new double[xBins][yBins];
        this.rmssY = new double[xBins][yBins];
    }
}

