/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.IAnnotation;
import hep.aida.IAxis;
import hep.aida.IBaseHistogram;
import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IHistogramFactory;
import hep.aida.IManagedObject;
import hep.aida.IProfile1D;
import hep.aida.IProfile2D;
import hep.aida.ITree;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.Annotation;
import hep.aida.ref.ManagedObject;
import hep.aida.ref.histogram.Cloud1D;
import hep.aida.ref.histogram.Cloud2D;
import hep.aida.ref.histogram.Cloud3D;
import hep.aida.ref.histogram.FixedAxis;
import hep.aida.ref.histogram.HistMath;
import hep.aida.ref.histogram.Histogram1D;
import hep.aida.ref.histogram.Histogram2D;
import hep.aida.ref.histogram.Histogram3D;
import hep.aida.ref.histogram.Profile1D;
import hep.aida.ref.histogram.Profile2D;
import hep.aida.ref.histogram.VariableAxis;
import hep.aida.ref.tree.Tree;

public class HistogramFactory
implements IHistogramFactory {
    private Tree tree;
    private static final int defaultMaxEntries = 100000;
    private HistMath histMath;

    private String nameInPath(String path) {
        return AidaUtils.parseName(path);
    }

    private String parentPath(String path) {
        return AidaUtils.parseDirName(path);
    }

    public HistogramFactory(ITree tree) {
        this((Tree)tree);
    }

    public HistogramFactory(Tree tree) {
        this.tree = tree;
        this.histMath = new HistMath();
    }

    public void destroy(IBaseHistogram hist) throws IllegalArgumentException {
        if (this.tree != null) {
            String path = this.tree.findPath((IManagedObject)hist);
            this.tree.rm(path);
        }
    }

    public ICloud1D createCloud1D(String path, String title, int nMax, String options) {
        Cloud1D result = new Cloud1D(this.nameInPath(path), title, nMax, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public ICloud1D createCloud1D(String path, String title, int nMax) {
        return this.createCloud1D(path, title, nMax, "");
    }

    public ICloud1D createCloud1D(String path, String title) {
        return this.createCloud1D(path, title, 100000);
    }

    public ICloud1D createCloud1D(String pathAndTitle) {
        return this.createCloud1D(pathAndTitle, this.nameInPath(pathAndTitle));
    }

    public ICloud1D createCopy(String path, ICloud1D cloud) {
        Cloud1D newCloud = this.copy(this.nameInPath(path), cloud);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)newCloud);
        }
        return newCloud;
    }

    private Cloud1D copy(String path, ICloud1D cloud) {
        boolean hAida = !(cloud instanceof Cloud1D);
        String options = null;
        if (!hAida) {
            options = ((Cloud1D)cloud).getOptions();
        }
        Cloud1D newCloud = new Cloud1D(this.nameInPath(path), cloud.title(), cloud.maxEntries(), options);
        HistogramFactory.copy(newCloud.annotation(), cloud.annotation());
        if (cloud.isConverted()) {
            newCloud.setHistogram(this.copy(this.nameInPath(path), cloud.histogram()));
        } else {
            for (int i = 0; i < cloud.entries(); ++i) {
                newCloud.fill(cloud.value(i), cloud.weight(i));
            }
        }
        newCloud.setLowerEdge(cloud.lowerEdge());
        newCloud.setUpperEdge(cloud.upperEdge());
        if (cloud instanceof ManagedObject) {
            newCloud.setFillable(((ManagedObject)cloud).isFillable());
        }
        HistogramFactory.copy(newCloud.annotation(), cloud.annotation());
        return newCloud;
    }

    public ICloud2D createCloud2D(String path, String title, int nMax, String options) {
        Cloud2D result = new Cloud2D(this.nameInPath(path), title, nMax, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public ICloud2D createCloud2D(String path, String title, int nMax) {
        return this.createCloud2D(path, title, nMax, "");
    }

    public ICloud2D createCloud2D(String path, String title) {
        return this.createCloud2D(path, title, 100000);
    }

    public ICloud2D createCloud2D(String pathAndTitle) {
        return this.createCloud2D(pathAndTitle, this.nameInPath(pathAndTitle));
    }

    public ICloud2D createCopy(String path, ICloud2D cloud) {
        Cloud2D newCloud = this.copy(this.nameInPath(path), cloud);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)newCloud);
        }
        return newCloud;
    }

    private Cloud2D copy(String path, ICloud2D cloud) {
        boolean hAida = !(cloud instanceof Cloud2D);
        String options = null;
        if (!hAida) {
            options = ((Cloud2D)cloud).getOptions();
        }
        Cloud2D newCloud = new Cloud2D(this.nameInPath(path), cloud.title(), cloud.maxEntries(), options);
        HistogramFactory.copy(newCloud.annotation(), cloud.annotation());
        if (cloud.isConverted()) {
            newCloud.setHistogram(this.copy(this.nameInPath(path), cloud.histogram()));
        } else {
            for (int i = 0; i < cloud.entries(); ++i) {
                newCloud.fill(cloud.valueX(i), cloud.valueY(i), cloud.weight(i));
            }
        }
        newCloud.setLowerEdgeX(cloud.lowerEdgeX());
        newCloud.setUpperEdgeX(cloud.upperEdgeX());
        newCloud.setLowerEdgeY(cloud.lowerEdgeY());
        newCloud.setUpperEdgeY(cloud.upperEdgeY());
        if (cloud instanceof ManagedObject) {
            newCloud.setFillable(((ManagedObject)cloud).isFillable());
        }
        HistogramFactory.copy(newCloud.annotation(), cloud.annotation());
        return newCloud;
    }

    public ICloud3D createCloud3D(String path, String title, int nMax, String options) {
        Cloud3D result = new Cloud3D(this.nameInPath(path), title, nMax, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public ICloud3D createCloud3D(String path, String title, int nMax) {
        return this.createCloud3D(path, title, nMax, "");
    }

    public ICloud3D createCloud3D(String path, String title) {
        return this.createCloud3D(path, title, 100000);
    }

    public ICloud3D createCloud3D(String pathAndTitle) {
        return this.createCloud3D(pathAndTitle, this.nameInPath(pathAndTitle));
    }

    public ICloud3D createCopy(String path, ICloud3D cloud) {
        Cloud3D newCloud = this.copy(this.nameInPath(path), cloud);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)newCloud);
        }
        return newCloud;
    }

    private Cloud3D copy(String path, ICloud3D cloud) {
        boolean hAida = !(cloud instanceof Cloud3D);
        String options = null;
        if (!hAida) {
            options = ((Cloud3D)cloud).getOptions();
        }
        Cloud3D newCloud = new Cloud3D(this.nameInPath(path), cloud.title(), cloud.maxEntries(), options);
        HistogramFactory.copy(newCloud.annotation(), cloud.annotation());
        if (cloud.isConverted()) {
            newCloud.setHistogram(this.copy(this.nameInPath(path), cloud.histogram()));
        } else {
            for (int i = 0; i < cloud.entries(); ++i) {
                newCloud.fill(cloud.valueX(i), cloud.valueY(i), cloud.valueZ(i), cloud.weight(i));
            }
        }
        newCloud.setLowerEdgeX(cloud.lowerEdgeX());
        newCloud.setUpperEdgeX(cloud.upperEdgeX());
        newCloud.setLowerEdgeY(cloud.lowerEdgeY());
        newCloud.setUpperEdgeY(cloud.upperEdgeY());
        newCloud.setLowerEdgeZ(cloud.lowerEdgeZ());
        newCloud.setUpperEdgeZ(cloud.upperEdgeZ());
        if (cloud instanceof ManagedObject) {
            newCloud.setFillable(((ManagedObject)cloud).isFillable());
        }
        HistogramFactory.copy(newCloud.annotation(), cloud.annotation());
        return newCloud;
    }

    private IAxis copy(IAxis axis) {
        if (axis.isFixedBinning()) {
            return new FixedAxis(axis.bins(), axis.lowerEdge(), axis.upperEdge());
        }
        double[] edges = new double[axis.bins() + 1];
        edges[0] = axis.binLowerEdge(0);
        for (int i = 0; i < axis.bins(); ++i) {
            edges[i + 1] = axis.binUpperEdge(i);
        }
        return new VariableAxis(edges);
    }

    public static void copy(IAnnotation newAn, IAnnotation an) {
        int size = an.size();
        for (int i = 0; i < size; ++i) {
            String key = an.key(i);
            if (key.equals(Annotation.titleKey) || key.equals(Annotation.aidaPathKey) || key.equals(Annotation.fullPathKey)) continue;
            String val = an.value(key);
            boolean sticky = an.isSticky(key);
            if (newAn.hasKey(key)) {
                newAn.setValue(key, val);
                newAn.setSticky(key, sticky);
                continue;
            }
            newAn.addItem(key, val, sticky);
        }
    }

    public IHistogram1D createHistogram1D(String path, String title, int nBins, double lowerEdge, double upperEdge, String options) {
        FixedAxis axis = new FixedAxis(nBins, lowerEdge, upperEdge);
        Histogram1D result = new Histogram1D(this.nameInPath(path), title, axis, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D createHistogram1D(String path, String title, int nBins, double lowerEdge, double upperEdge) {
        return this.createHistogram1D(path, title, nBins, lowerEdge, upperEdge, "");
    }

    public IHistogram1D createHistogram1D(String pathAndTitle, int nBins, double lowerEdge, double upperEdge) {
        return this.createHistogram1D(pathAndTitle, this.nameInPath(pathAndTitle), nBins, lowerEdge, upperEdge);
    }

    public IHistogram1D createHistogram1D(String path, String title, double[] binEdges, String options) {
        VariableAxis axis = new VariableAxis(binEdges);
        Histogram1D result = new Histogram1D(this.nameInPath(path), title, axis, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D createHistogram1D(String path, String title, double[] binEdges) {
        return this.createHistogram1D(path, title, binEdges, "");
    }

    public IHistogram1D createCopy(String path, IHistogram1D hist) {
        Histogram1D newHist = this.copy(this.nameInPath(path), hist);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)newHist);
        }
        return newHist;
    }

    private Histogram1D copy(String name, IHistogram1D hist) {
        IAxis axis = hist.axis();
        boolean hAida = !(hist instanceof Histogram1D);
        String options = null;
        if (!hAida) {
            options = ((Histogram1D)hist).options();
        }
        Histogram1D newHist = new Histogram1D(name, hist.title(), this.copy(axis), options);
        HistogramFactory.copy(newHist.annotation(), hist.annotation());
        if (!hAida) {
            newHist.binner().initBinner(((Histogram1D)hist).binner());
            newHist.initHistogram1D(((Histogram1D)hist).binner());
            newHist.setNEntries(hist.allEntries());
            newHist.setValidEntries(hist.entries());
            if (((Histogram1D)hist).isMeanAndRmsSet()) {
                newHist.setMeanAndRms(hist.mean(), hist.rms());
            }
        } else {
            int bins = axis.bins() + 2;
            double[] heights = new double[bins];
            double[] errors = new double[bins];
            double[] means = new double[bins];
            double[] rmss = new double[bins];
            int[] entries = new int[bins];
            for (int i = -2; i < bins - 2; ++i) {
                int bin = newHist.mapBinNumber(i, axis);
                heights[bin] = hist.binHeight(i);
                errors[bin] = hist.binError(i);
                entries[bin] = hist.binEntries(i);
                means[bin] = hist.binMean(i);
                rmss[bin] = (hist.axis().binUpperEdge(i) - hist.axis().binLowerEdge(i)) / Math.sqrt(12.0);
            }
            newHist.setContents(heights, errors, entries, means, rmss);
            newHist.setNEntries(hist.allEntries());
            newHist.setValidEntries(hist.entries());
            newHist.setMeanAndRms(hist.mean(), hist.rms());
        }
        if (hist instanceof ManagedObject) {
            newHist.setFillable(((ManagedObject)hist).isFillable());
        }
        HistogramFactory.copy(newHist.annotation(), hist.annotation());
        return newHist;
    }

    public IHistogram2D createHistogram2D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, String options) {
        FixedAxis xAxis = new FixedAxis(nBinsX, lowerEdgeX, upperEdgeX);
        FixedAxis yAxis = new FixedAxis(nBinsY, lowerEdgeY, upperEdgeY);
        Histogram2D result = new Histogram2D(this.nameInPath(path), title, xAxis, yAxis, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D createHistogram2D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY) {
        return this.createHistogram2D(path, title, nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY, "");
    }

    public IHistogram2D createHistogram2D(String pathAndTitle, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY) {
        return this.createHistogram2D(pathAndTitle, this.nameInPath(pathAndTitle), nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY);
    }

    public IHistogram2D createHistogram2D(String path, String title, double[] binEdgesX, double[] binEdgesY, String options) {
        VariableAxis xAxis = new VariableAxis(binEdgesX);
        VariableAxis yAxis = new VariableAxis(binEdgesY);
        Histogram2D result = new Histogram2D(this.nameInPath(path), title, xAxis, yAxis, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D createHistogram2D(String path, String title, double[] binEdgesX, double[] binEdgesY) {
        return this.createHistogram2D(path, title, binEdgesX, binEdgesY, "");
    }

    public IHistogram2D createCopy(String path, IHistogram2D hist) {
        Histogram2D newHist = this.copy(this.nameInPath(path), hist);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)newHist);
        }
        return newHist;
    }

    private Histogram2D copy(String name, IHistogram2D hist) {
        IAxis xAxis = hist.xAxis();
        IAxis yAxis = hist.yAxis();
        boolean hAida = !(hist instanceof Histogram2D);
        String options = null;
        if (!hAida) {
            options = ((Histogram2D)hist).options();
        }
        Histogram2D newHist = new Histogram2D(name, hist.title(), this.copy(xAxis), this.copy(yAxis), options);
        HistogramFactory.copy(newHist.annotation(), hist.annotation());
        int xBins = xAxis.bins() + 2;
        int yBins = yAxis.bins() + 2;
        double[][] heights = new double[xBins][yBins];
        double[][] errors = new double[xBins][yBins];
        double[][] meanXs = new double[xBins][yBins];
        double[][] rmsXs = new double[xBins][yBins];
        double[][] meanYs = new double[xBins][yBins];
        double[][] rmsYs = new double[xBins][yBins];
        int[][] entries = new int[xBins][yBins];
        for (int i = -2; i < xBins - 2; ++i) {
            for (int j = -2; j < yBins - 2; ++j) {
                int xbin = newHist.mapBinNumber(i, xAxis);
                int ybin = newHist.mapBinNumber(j, yAxis);
                heights[xbin][ybin] = hist.binHeight(i, j);
                errors[xbin][ybin] = hist.binError(i, j);
                entries[xbin][ybin] = hist.binEntries(i, j);
                meanXs[xbin][ybin] = hist.binMeanX(i, j);
                meanYs[xbin][ybin] = hist.binMeanY(i, j);
                if (hAida) {
                    rmsXs[xbin][ybin] = (hist.xAxis().binUpperEdge(i) - hist.xAxis().binLowerEdge(i)) / Math.sqrt(12.0);
                    rmsYs[xbin][ybin] = (hist.yAxis().binUpperEdge(j) - hist.yAxis().binLowerEdge(j)) / Math.sqrt(12.0);
                    continue;
                }
                rmsXs[xbin][ybin] = ((Histogram2D)hist).binRmsX(i, j);
                rmsYs[xbin][ybin] = ((Histogram2D)hist).binRmsY(i, j);
            }
        }
        newHist.setContents(heights, errors, entries, meanXs, rmsXs, meanYs, rmsYs);
        newHist.setMeanX(hist.meanX());
        newHist.setRmsX(hist.rmsX());
        newHist.setMeanY(hist.meanY());
        newHist.setRmsY(hist.rmsY());
        newHist.setNEntries(hist.allEntries());
        newHist.setValidEntries(hist.entries());
        if (hist instanceof ManagedObject) {
            newHist.setFillable(((ManagedObject)hist).isFillable());
        }
        HistogramFactory.copy(newHist.annotation(), hist.annotation());
        return newHist;
    }

    public IHistogram3D createHistogram3D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, int nBinsZ, double lowerEdgeZ, double upperEdgeZ, String options) {
        FixedAxis xAxis = new FixedAxis(nBinsX, lowerEdgeX, upperEdgeX);
        FixedAxis yAxis = new FixedAxis(nBinsY, lowerEdgeY, upperEdgeY);
        FixedAxis zAxis = new FixedAxis(nBinsZ, lowerEdgeZ, upperEdgeZ);
        Histogram3D result = new Histogram3D(this.nameInPath(path), title, xAxis, yAxis, zAxis, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram3D createHistogram3D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, int nBinsZ, double lowerEdgeZ, double upperEdgeZ) {
        return this.createHistogram3D(path, title, nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY, nBinsZ, lowerEdgeZ, upperEdgeZ, "");
    }

    public IHistogram3D createHistogram3D(String pathAndTitle, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, int nBinsZ, double lowerEdgeZ, double upperEdgeZ) {
        return this.createHistogram3D(pathAndTitle, this.nameInPath(pathAndTitle), nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY, nBinsZ, lowerEdgeZ, upperEdgeZ, "");
    }

    public IHistogram3D createHistogram3D(String path, String title, double[] binEdgesX, double[] binEdgesY, double[] binEdgesZ, String options) {
        VariableAxis xAxis = new VariableAxis(binEdgesX);
        VariableAxis yAxis = new VariableAxis(binEdgesY);
        VariableAxis zAxis = new VariableAxis(binEdgesZ);
        Histogram3D result = new Histogram3D(this.nameInPath(path), title, xAxis, yAxis, zAxis, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram3D createHistogram3D(String path, String title, double[] binEdgesX, double[] binEdgesY, double[] binEdgesZ) {
        return this.createHistogram3D(path, title, binEdgesX, binEdgesY, binEdgesZ, "");
    }

    public IHistogram3D createCopy(String path, IHistogram3D hist) {
        Histogram3D newHist = this.copy(this.nameInPath(path), hist);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)newHist);
        }
        return newHist;
    }

    private Histogram3D copy(String name, IHistogram3D hist) {
        IAxis xAxis = hist.xAxis();
        IAxis yAxis = hist.yAxis();
        IAxis zAxis = hist.zAxis();
        boolean hAida = !(hist instanceof Histogram3D);
        String options = null;
        if (!hAida) {
            options = ((Histogram3D)hist).options();
        }
        Histogram3D newHist = new Histogram3D(name, hist.title(), this.copy(xAxis), this.copy(yAxis), this.copy(zAxis), options);
        HistogramFactory.copy(newHist.annotation(), hist.annotation());
        int xBins = xAxis.bins() + 2;
        int yBins = yAxis.bins() + 2;
        int zBins = zAxis.bins() + 2;
        double[][][] heights = new double[xBins][yBins][zBins];
        double[][][] errors = new double[xBins][yBins][zBins];
        double[][][] meanXs = new double[xBins][yBins][zBins];
        double[][][] rmsXs = new double[xBins][yBins][zBins];
        double[][][] meanYs = new double[xBins][yBins][zBins];
        double[][][] rmsYs = new double[xBins][yBins][zBins];
        double[][][] meanZs = new double[xBins][yBins][zBins];
        double[][][] rmsZs = new double[xBins][yBins][zBins];
        int[][][] entries = new int[xBins][yBins][zBins];
        for (int i = -2; i < xBins - 2; ++i) {
            for (int j = -2; j < yBins - 2; ++j) {
                for (int k = -2; k < zBins - 2; ++k) {
                    int xbin = newHist.mapBinNumber(i, xAxis);
                    int ybin = newHist.mapBinNumber(j, yAxis);
                    int zbin = newHist.mapBinNumber(k, zAxis);
                    heights[xbin][ybin][zbin] = hist.binHeight(i, j, k);
                    errors[xbin][ybin][zbin] = hist.binError(i, j, k);
                    entries[xbin][ybin][zbin] = hist.binEntries(i, j, k);
                    meanXs[xbin][ybin][zbin] = hist.binMeanX(i, j, k);
                    meanYs[xbin][ybin][zbin] = hist.binMeanY(i, j, k);
                    meanZs[xbin][ybin][zbin] = hist.binMeanZ(i, j, k);
                    if (hAida) {
                        rmsXs[xbin][ybin][zbin] = (hist.xAxis().binUpperEdge(i) - hist.xAxis().binLowerEdge(i)) / Math.sqrt(12.0);
                        rmsYs[xbin][ybin][zbin] = (hist.yAxis().binUpperEdge(j) - hist.yAxis().binLowerEdge(j)) / Math.sqrt(12.0);
                        rmsZs[xbin][ybin][zbin] = (hist.zAxis().binUpperEdge(k) - hist.zAxis().binLowerEdge(k)) / Math.sqrt(12.0);
                        continue;
                    }
                    rmsXs[xbin][ybin][zbin] = ((Histogram3D)hist).binRmsX(i, j, k);
                    rmsYs[xbin][ybin][zbin] = ((Histogram3D)hist).binRmsY(i, j, k);
                    rmsZs[xbin][ybin][zbin] = ((Histogram3D)hist).binRmsZ(i, j, k);
                }
            }
        }
        newHist.setContents(heights, errors, entries, meanXs, rmsXs, meanYs, rmsYs, meanZs, rmsZs);
        newHist.setMeanX(hist.meanX());
        newHist.setRmsX(hist.rmsX());
        newHist.setMeanY(hist.meanY());
        newHist.setRmsY(hist.rmsY());
        newHist.setMeanZ(hist.meanZ());
        newHist.setRmsZ(hist.rmsZ());
        newHist.setNEntries(hist.allEntries());
        newHist.setValidEntries(hist.entries());
        if (hist instanceof ManagedObject) {
            newHist.setFillable(((ManagedObject)hist).isFillable());
        }
        HistogramFactory.copy(newHist.annotation(), hist.annotation());
        return newHist;
    }

    public IProfile1D createProfile1D(String path, String title, int nBins, double lowerEdge, double upperEdge, String options) {
        FixedAxis axis = new FixedAxis(nBins, lowerEdge, upperEdge);
        Profile1D result = new Profile1D(this.nameInPath(path), title, axis, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IProfile1D createProfile1D(String path, String title, int nBins, double lowerEdge, double upperEdge) {
        return this.createProfile1D(path, title, nBins, lowerEdge, upperEdge, "");
    }

    public IProfile1D createProfile1D(String path, String title, int nBins, double lowerEdge, double upperEdge, double lowerValue, double upperValue, String options) {
        return this.createProfile1D(path, title, nBins, lowerEdge, upperEdge, "");
    }

    public IProfile1D createProfile1D(String path, String title, int nBins, double lowerEdge, double upperEdge, double lowerValue, double upperValue) {
        return this.createProfile1D(path, title, nBins, lowerEdge, upperEdge, "");
    }

    public IProfile1D createProfile1D(String pathAndTitle, int nBins, double lowerEdge, double upperEdge) {
        return this.createProfile1D(pathAndTitle, this.nameInPath(pathAndTitle), nBins, lowerEdge, upperEdge, "");
    }

    public IProfile1D createProfile1D(String pathAndTitle, int nBins, double lowerEdge, double upperEdge, double lowerValue, double upperValue) {
        return this.createProfile1D(pathAndTitle, this.nameInPath(pathAndTitle), nBins, lowerEdge, upperEdge, "");
    }

    public IProfile1D createProfile1D(String path, String title, double[] binEdges, String options) {
        VariableAxis axis = new VariableAxis(binEdges);
        Profile1D result = new Profile1D(this.nameInPath(path), title, axis, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IProfile1D createProfile1D(String path, String title, double[] binEdges) {
        return this.createProfile1D(path, title, binEdges, "");
    }

    public IProfile1D createProfile1D(String path, String title, double[] binEdges, double lowerValue, double upperValue, String options) {
        return this.createProfile1D(path, title, binEdges, "");
    }

    public IProfile1D createProfile1D(String path, String title, double[] binEdges, double lowerValue, double upperValue) {
        return this.createProfile1D(path, title, binEdges, lowerValue, upperValue, "");
    }

    public IProfile1D createCopy(String path, IProfile1D profile) {
        Profile1D newProfile = this.copy(this.nameInPath(path), profile);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)newProfile);
        }
        return newProfile;
    }

    private Profile1D copy(String path, IProfile1D profile) {
        if (!(profile instanceof Profile1D)) {
            return this.copyAida(path, profile);
        }
        Profile1D oldProfile = (Profile1D)profile;
        Profile1D newProfile = new Profile1D(this.nameInPath(path), oldProfile.title(), this.copy(oldProfile.axis()), oldProfile.options());
        HistogramFactory.copy(newProfile.annotation(), profile.annotation());
        newProfile.setHistogram(this.copy(this.nameInPath(path), oldProfile.histogram()));
        if (profile instanceof ManagedObject) {
            newProfile.setFillable(((ManagedObject)profile).isFillable());
        }
        HistogramFactory.copy(newProfile.annotation(), profile.annotation());
        return newProfile;
    }

    private Profile1D copyAida(String path, IProfile1D profile) {
        IAxis axis = profile.axis();
        Profile1D newProfile = new Profile1D(this.nameInPath(path), profile.title(), this.copy(axis), null);
        HistogramFactory.copy(newProfile.annotation(), profile.annotation());
        int bins = axis.bins() + 2;
        double[] heights = new double[bins];
        double[] errors = new double[bins];
        double[] means = new double[bins];
        double[] rmss = new double[bins];
        int[] entries = new int[bins];
        for (int i = -2; i < bins - 2; ++i) {
            int bin = newProfile.mapBinNumber(i, axis);
            heights[bin] = profile.binHeight(i);
            errors[bin] = profile.binError(i);
            entries[bin] = profile.binEntries(i);
            means[bin] = profile.binMean(i);
            rmss[bin] = profile.binRms(i);
        }
        newProfile.setContents(heights, errors, entries, rmss, means);
        newProfile.setMean(profile.mean());
        newProfile.setRms(profile.rms());
        newProfile.setNEntries(profile.allEntries());
        if (profile instanceof ManagedObject) {
            newProfile.setFillable(((ManagedObject)profile).isFillable());
        }
        HistogramFactory.copy(newProfile.annotation(), profile.annotation());
        return newProfile;
    }

    public IProfile2D createProfile2D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, String options) {
        FixedAxis xAxis = new FixedAxis(nBinsX, lowerEdgeX, upperEdgeX);
        FixedAxis yAxis = new FixedAxis(nBinsY, lowerEdgeY, upperEdgeY);
        Profile2D result = new Profile2D(this.nameInPath(path), title, xAxis, yAxis, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IProfile2D createProfile2D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY) {
        return this.createProfile2D(path, title, nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY, "");
    }

    public IProfile2D createProfile2D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, double lowerValue, double upperValue, String options) {
        return this.createProfile2D(path, title, nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY, "");
    }

    public IProfile2D createProfile2D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, double lowerValue, double upperValue) {
        return this.createProfile2D(path, title, nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY, "");
    }

    public IProfile2D createProfile2D(String pathAndTitle, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY) {
        return this.createProfile2D(pathAndTitle, this.nameInPath(pathAndTitle), nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY, "");
    }

    public IProfile2D createProfile2D(String pathAndTitle, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, double lowerValue, double upperValue) {
        return this.createProfile2D(pathAndTitle, this.nameInPath(pathAndTitle), nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY, "");
    }

    public IProfile2D createProfile2D(String path, String title, double[] binEdgesX, double[] binEdgesY, String options) {
        VariableAxis xAxis = new VariableAxis(binEdgesX);
        VariableAxis yAxis = new VariableAxis(binEdgesY);
        Profile2D result = new Profile2D(this.nameInPath(path), title, xAxis, yAxis, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IProfile2D createProfile2D(String path, String title, double[] binEdgesX, double[] binEdgesY) {
        return this.createProfile2D(path, title, binEdgesX, binEdgesY, "");
    }

    public IProfile2D createProfile2D(String path, String title, double[] binEdgesX, double[] binEdgesY, double lowerValue, double upperValue, String options) {
        return this.createProfile2D(path, title, binEdgesX, binEdgesY, "");
    }

    public IProfile2D createProfile2D(String path, String title, double[] binEdgesX, double[] binEdgesY, double lowerValue, double upperValue) {
        return this.createProfile2D(path, title, binEdgesX, binEdgesY, lowerValue, upperValue, "");
    }

    public IProfile2D createCopy(String path, IProfile2D profile) {
        Profile2D newProfile = this.copy(path, profile);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)newProfile);
        }
        return newProfile;
    }

    private Profile2D copy(String path, IProfile2D profile) {
        if (!(profile instanceof Profile2D)) {
            return this.copyAida(path, profile);
        }
        Profile2D oldProfile = (Profile2D)profile;
        Profile2D newProfile = new Profile2D(this.nameInPath(path), oldProfile.title(), this.copy(oldProfile.xAxis()), this.copy(oldProfile.yAxis()), oldProfile.options());
        HistogramFactory.copy(newProfile.annotation(), profile.annotation());
        newProfile.setHistogram(this.copy(this.nameInPath(path), oldProfile.histogram()));
        if (profile instanceof ManagedObject) {
            newProfile.setFillable(((ManagedObject)profile).isFillable());
        }
        HistogramFactory.copy(newProfile.annotation(), profile.annotation());
        return newProfile;
    }

    private Profile2D copyAida(String path, IProfile2D profile) {
        IAxis xAxis = profile.xAxis();
        IAxis yAxis = profile.yAxis();
        Profile2D newProfile = new Profile2D(this.nameInPath(path), profile.title(), this.copy(xAxis), this.copy(yAxis), null);
        HistogramFactory.copy(newProfile.annotation(), profile.annotation());
        int xBins = xAxis.bins() + 2;
        int yBins = yAxis.bins() + 2;
        double[][] heights = new double[xBins][yBins];
        double[][] errors = new double[xBins][yBins];
        double[][] meanXs = new double[xBins][yBins];
        double[][] meanYs = new double[xBins][yBins];
        double[][] rmss = new double[xBins][yBins];
        int[][] entries = new int[xBins][yBins];
        for (int i = -2; i < xBins - 2; ++i) {
            for (int j = -2; j < yBins - 2; ++j) {
                int xbin = newProfile.mapBinNumber(i, xAxis);
                int ybin = newProfile.mapBinNumber(j, yAxis);
                heights[xbin][ybin] = profile.binHeight(i, j);
                errors[xbin][ybin] = profile.binError(i, j);
                entries[xbin][ybin] = profile.binEntries(i, j);
                meanXs[xbin][ybin] = profile.binMeanX(i, j);
                meanYs[xbin][ybin] = profile.binMeanY(i, j);
                rmss[xbin][ybin] = profile.binRms(i, j);
            }
        }
        newProfile.setContents(heights, errors, entries, rmss, meanXs, meanYs);
        newProfile.setMeanX(profile.meanX());
        newProfile.setRmsX(profile.rmsX());
        newProfile.setMeanY(profile.meanY());
        newProfile.setRmsY(profile.rmsY());
        newProfile.setNEntries(profile.allEntries());
        if (profile instanceof ManagedObject) {
            newProfile.setFillable(((ManagedObject)profile).isFillable());
        }
        HistogramFactory.copy(newProfile.annotation(), profile.annotation());
        return newProfile;
    }

    public IHistogram1D add(String path, IHistogram1D a, IHistogram1D b) throws IllegalArgumentException {
        IHistogram1D result = this.histMath.add(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D subtract(String path, IHistogram1D a, IHistogram1D b) throws IllegalArgumentException {
        IHistogram1D result = this.histMath.sub(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D multiply(String path, IHistogram1D a, IHistogram1D b) throws IllegalArgumentException {
        IHistogram1D result = this.histMath.mul(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D divide(String path, IHistogram1D a, IHistogram1D b) throws IllegalArgumentException {
        IHistogram1D result = this.histMath.div(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D add(String path, IHistogram2D a, IHistogram2D b) throws IllegalArgumentException {
        IHistogram2D result = this.histMath.add(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D subtract(String path, IHistogram2D a, IHistogram2D b) throws IllegalArgumentException {
        IHistogram2D result = this.histMath.sub(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D multiply(String path, IHistogram2D a, IHistogram2D b) throws IllegalArgumentException {
        IHistogram2D result = this.histMath.mul(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D divide(String path, IHistogram2D a, IHistogram2D b) throws IllegalArgumentException {
        IHistogram2D result = this.histMath.div(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram3D add(String path, IHistogram3D a, IHistogram3D b) throws IllegalArgumentException {
        IHistogram3D result = this.histMath.add(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram3D subtract(String path, IHistogram3D a, IHistogram3D b) throws IllegalArgumentException {
        IHistogram3D result = this.histMath.sub(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram3D multiply(String path, IHistogram3D a, IHistogram3D b) throws IllegalArgumentException {
        IHistogram3D result = this.histMath.mul(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram3D divide(String path, IHistogram3D a, IHistogram3D b) throws IllegalArgumentException {
        IHistogram3D result = this.histMath.div(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D projectionX(String path, IHistogram2D h) {
        IHistogram1D result = this.histMath.sliceX(h, this.nameInPath(path), -2, -1);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D projectionY(String path, IHistogram2D h) {
        IHistogram1D result = this.histMath.sliceY(h, this.nameInPath(path), -2, -1);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D sliceX(String path, IHistogram2D h, int indexY) {
        IHistogram1D result = this.histMath.sliceX(h, this.nameInPath(path), indexY, indexY);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D sliceY(String path, IHistogram2D h, int indexX) {
        IHistogram1D result = this.histMath.sliceY(h, this.nameInPath(path), indexX, indexX);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D sliceX(String path, IHistogram2D h, int indexY1, int indexY2) {
        IHistogram1D result = this.histMath.sliceX(h, this.nameInPath(path), indexY1, indexY2);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D sliceY(String path, IHistogram2D h, int indexX1, int indexX2) {
        IHistogram1D result = this.histMath.sliceY(h, this.nameInPath(path), indexX1, indexX2);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D projectionXY(String path, IHistogram3D h) {
        IHistogram2D result = this.histMath.sliceXY(h, this.nameInPath(path), -2, -1);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D projectionXZ(String path, IHistogram3D h) {
        IHistogram2D result = this.histMath.sliceXZ(h, this.nameInPath(path), -2, -1);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D projectionYZ(String path, IHistogram3D h) {
        IHistogram2D result = this.histMath.sliceYZ(h, this.nameInPath(path), -2, -1);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D sliceXY(String path, IHistogram3D h, int indexZ1, int indexZ2) {
        IHistogram2D result = this.histMath.sliceXY(h, this.nameInPath(path), indexZ1, indexZ2);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D sliceXZ(String path, IHistogram3D h, int indexY1, int indexY2) {
        IHistogram2D result = this.histMath.sliceXZ(h, this.nameInPath(path), indexY1, indexY2);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D sliceYZ(String path, IHistogram3D h, int indexX1, int indexX2) {
        IHistogram2D result = this.histMath.sliceYZ(h, this.nameInPath(path), indexX1, indexX2);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }
}

