/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.utils;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;

public class TrendingConnectionUtils {
    private final Client client = Client.create((ClientConfig)new DefaultClientConfig());
    private final String baseUrl;
    private final WebResource serv;

    public TrendingConnectionUtils(String serverName, int serverPort) {
        this(serverName, serverPort, "/rest/data");
    }

    public TrendingConnectionUtils(String serverName, int serverPort, String entryPoint) {
        this.baseUrl = String.format("http://%s:%d%s", serverName, serverPort, entryPoint);
        this.serv = this.client.resource(this.baseUrl).path("dataserver");
    }

    public DataChannel.DataChannelList getChannelList() {
        return (DataChannel.DataChannelList)this.serv.path("listchannels").accept(new String[]{"text/xml"}).get(DataChannel.DataChannelList.class);
    }

    public TrendingData getLatestData(String path) {
        return (TrendingData)this.serv.path("data/latest").queryParam("path", path).accept(new String[]{"text/xml"}).get(TrendingData.class);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

