/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class CreateDefaultDataGroups {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb");

    public static void main(String[] args) throws SQLException {
        Properties p = BootstrapResourceUtils.getBootstrapProperties((String)"statusPersister");
        String url = p.getProperty("hibernate.connection.url");
        String username = p.getProperty("hibernate.connection.username");
        String password = p.getProperty("hibernate.connection.password");
        String[] connSplit = url.split("/");
        String schemaName = connSplit[connSplit.length - 1];
        try (Connection connection = DriverManager.getConnection(url + "?user=" + username + "&password=" + password);){
            connection.setSchema(schemaName);
            PreparedStatement ps = connection.prepareStatement("SELECT * from INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA=\"" + schemaName + "\" and TABLE_NAME='ccs_dataGroup';");
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                log.info((Object)"creating a data group for each dataDesc");
                connection.prepareStatement("CREATE TABLE `ccs_dataGroup` ( `id` bigint(20) NOT NULL AUTO_INCREMENT,`agentName` varchar(255) DEFAULT NULL,`groupName` varchar(255) DEFAULT NULL,PRIMARY KEY (`id`),UNIQUE KEY `ccs_dataGr_agentNa_groupNa_u` (`agentName`,`groupName`))").execute();
                connection.prepareStatement("CREATE TABLE `ccs_dataGr_dataDe_b` (\n  `dataGroupId` bigint(20) NOT NULL,\n  `membersId` bigint(20) NOT NULL,\n  PRIMARY KEY (`dataGroupId`,`membersId`),\n  KEY `ccs_dataGrDe_membersId_dataDe_fk` (`membersId`),\n  CONSTRAINT `ccs_dataGrDe_dataGrId_dataGr_fk` FOREIGN KEY (`dataGroupId`) REFERENCES `ccs_dataGroup` (`id`),\n  CONSTRAINT `ccs_dataGrDe_membersId_dataDe_fk` FOREIGN KEY (`membersId`) REFERENCES `ccs_dataDesc` (`id`)\n)").execute();
                connection.prepareStatement("alter table ccs_metaDataData drop foreign key ccs_metaDaDa_dataDeId_dataDe_fk").execute();
                connection.prepareStatement("insert into ccs_dataGroup(id, agentName, groupName) select id, agentName, dataName from ccs_dataDesc").execute();
                connection.prepareStatement("insert into ccs_dataGr_dataDe_b (dataGroupId,membersId) select id, id from ccs_dataDesc").execute();
                connection.prepareStatement("alter table ccs_metaDataData add constraint ccs_metaDaDa_dataDeId_dataGr_fk foreign key (dataDescId) references ccs_dataGroup(id)").execute();
            }
            System.out.println("done");
        }
    }
}

