/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.model;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import org.hibernate.annotations.Immutable;
import org.lsst.ccs.localdb.configdb.model.PathObject;

@Embeddable
@Immutable
public class ParameterPath
implements PathObject,
Serializable {
    private static final long serialVersionUID = -1012785409109930223L;
    private String componentName;
    private String parameterName;

    protected ParameterPath() {
    }

    public ParameterPath(String componentName, String parameterName) {
        if (componentName == null || parameterName == null) {
            throw new IllegalArgumentException("null argument in ParameterPath");
        }
        this.componentName = componentName;
        this.parameterName = parameterName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterPath that = (ParameterPath)o;
        if (!this.componentName.equals(that.componentName)) {
            return false;
        }
        return this.parameterName.equals(that.parameterName);
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + Objects.hashCode(this.componentName);
        hash = 79 * hash + Objects.hashCode(this.parameterName);
        return hash;
    }

    public String toString() {
        return this.componentName + '/' + this.parameterName;
    }

    public static ParameterPath valueOf(String pathString) {
        String[] elements = pathString.split("/");
        if (elements.length != 2) {
            throw new IllegalArgumentException("PathString should be componentName/parameterName");
        }
        ParameterPath path = new ParameterPath(elements[0], elements[1]);
        return path;
    }

    @Override
    @Transient
    public ParameterPath getPath() {
        return this;
    }
}

