/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.logging;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.lsst.ccs.utilities.logging.LogPropertiesLoader;
import org.lsst.ccs.utilities.logging.TextFormatter;

public class DailyRollingFileHandler
extends Handler {
    private String pattern = "/tmp/output.log";
    private int count = 1;
    private FileHandler innerFileHandler;
    private long nextRollover = -1L;

    public DailyRollingFileHandler() {
        String className = this.getClass().getCanonicalName();
        this.pattern = LogPropertiesLoader.loaderGetStringProperty(className + ".pattern", this.pattern);
        this.count = LogPropertiesLoader.loaderGetIntProperty(className + ".count", 1);
        Formatter formatter = LogPropertiesLoader.loaderGetFormatterProperty(className + ".formatter", new TextFormatter());
        this.setFormatter(formatter);
        Level level = LogPropertiesLoader.loaderGetLevelProperty(className + ".level", Level.WARNING);
        this.setLevel(level);
    }

    private synchronized void createFileHandlerForTodayIfNeeded(long millis) {
        if (millis < this.nextRollover) {
            return;
        }
        Instant instant = Instant.ofEpochMilli(millis);
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, zoneId);
        ZonedDateTime zdtStart = zdt.toLocalDate().atStartOfDay(zoneId);
        ZonedDateTime zdtTomorrowStart = zdtStart.plusDays(1L);
        this.nextRollover = zdtTomorrowStart.toInstant().toEpochMilli();
        try {
            if (this.innerFileHandler != null) {
                this.innerFileHandler.close();
            }
            this.innerFileHandler = new FileHandler(this.fileName(millis), 0, this.count, this.count == 1);
            this.innerFileHandler.setLevel(this.getLevel());
            this.innerFileHandler.setEncoding(this.getEncoding());
            this.innerFileHandler.setFilter(this.getFilter());
            if (this.getFormatter() != null) {
                this.innerFileHandler.setFormatter(this.getFormatter());
            }
            this.innerFileHandler.setErrorManager(this.getErrorManager());
        }
        catch (IOException e) {
            this.reportError(null, e, 1);
        }
    }

    @Override
    public synchronized void publish(LogRecord r) {
        if (this.isLoggable(r)) {
            this.createFileHandlerForTodayIfNeeded(r.getMillis());
            this.innerFileHandler.publish(r);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        super.setLevel(Level.OFF);
        if (this.innerFileHandler != null) {
            this.innerFileHandler.close();
        }
    }

    String fileName(long millis) {
        String date = new SimpleDateFormat("yyyyMMdd").format(new Date(millis));
        return this.pattern.replace(".log", "-" + date + ".log");
    }

    long getNextRollover() {
        return this.nextRollover;
    }
}

