/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.dsp;

import java.util.Arrays;
import org.lsst.ccs.utilities.dsp.DigitalFilter;

public class MedianFilter
implements DigitalFilter {
    private static final long serialVersionUID = 4525960504716400209L;
    int sz;
    double[] history;
    double[] tmp;
    int ip;

    public MedianFilter(int sz) {
        if (sz % 2 == 0) {
            ++sz;
        }
        this.sz = sz;
        this.history = new double[sz];
        this.tmp = new double[sz];
    }

    @Override
    public void reset() {
        Arrays.fill(this.history, 0.0);
        this.ip = 0;
    }

    @Override
    public int getDelay() {
        return this.sz / 2;
    }

    @Override
    public double flush() {
        return this.apply(0.0);
    }

    @Override
    public double apply(double signal) {
        ++this.ip;
        if (this.ip >= this.sz) {
            this.ip = 0;
        }
        this.history[this.ip] = signal;
        System.arraycopy(this.history, 0, this.tmp, 0, this.tmp.length);
        Arrays.sort(this.tmp);
        return this.tmp[this.sz / 2];
    }

    @Override
    public double freqResp(double freq) {
        return 0.0;
    }

    @Override
    public int getOrder() {
        return this.sz;
    }

    @Override
    public Object clone() {
        try {
            MedianFilter f = (MedianFilter)super.clone();
            f.history = new double[this.sz];
            f.tmp = new double[this.sz];
            return f;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

