/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.monitor.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.monitor.ui.CommandSender;

public class MonitorPanel
extends JPanel {
    static final Font f = new Font("Tahoma", 1, 12);
    static final Color RED = new Color(150, 0, 0);
    static final Color GREEN = new Color(0, 150, 0);
    CommandSender gui;
    Map<String, SubsysDesc> subsysMap = new HashMap<String, SubsysDesc>();
    private JButton limitsButton;
    private JLabel timeLabel;
    private JLabel timeValue;
    private static final long serialVersionUID = 1L;

    public MonitorPanel(CommandSender gui) {
        this.gui = gui;
        this.initComponents();
        this.timeLabel.setFont(f);
        this.timeValue.setFont(f);
        this.limitsButton.setFont(f);
        new UpdateStatus().run();
    }

    private void initComponents() {
        this.limitsButton = new JButton();
        this.timeValue = new JLabel();
        this.timeLabel = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.limitsButton.setText("Save Limits");
        this.limitsButton.setEnabled(false);
        this.limitsButton.setFocusable(false);
        this.limitsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MonitorPanel.this.limitsButtonActionPerformed(evt);
            }
        });
        this.timeValue.setText("0000-00-00  00:00:00");
        this.timeLabel.setText("Last Update:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.timeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.timeValue, -2, 146, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 50, Short.MAX_VALUE).addComponent(this.limitsButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.limitsButton).addComponent(this.timeLabel).addComponent(this.timeValue)).addGap(0, 4, Short.MAX_VALUE)));
    }

    private void limitsButtonActionPerformed(ActionEvent evt) {
        for (SubsysDesc desc : this.subsysMap.values()) {
            if (!desc.limitChanged) continue;
            this.gui.sendCommand(desc.name, null, "saveConfig", new Object[0]);
        }
        this.limitsButton.setEnabled(false);
    }

    public void setSubsystems(String ... sNames) {
        for (String sName : sNames) {
            SubsysDesc desc = new SubsysDesc();
            desc.name = sName;
            this.subsysMap.put(sName, desc);
        }
    }

    public void updatePanel(String sName, Boolean limitChanged) {
        if (limitChanged == null) {
            return;
        }
        SubsysDesc desc = this.subsysMap.get(sName);
        if (desc == null) {
            return;
        }
        desc.limitChanged = limitChanged;
        SwingUtilities.invokeLater(new UpdateStatus());
    }

    public void updateTime() {
        SwingUtilities.invokeLater(new UpdateTime());
    }

    public void disableSystem(String sName) {
        this.updatePanel(sName, false);
    }

    JButton getLimitsButton() {
        return this.limitsButton;
    }

    private void showTime() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(System.currentTimeMillis());
        this.timeValue.setText(String.format("%tY-%<tm-%<td  %<tH:%<tM:%<tS", cal));
    }

    class UpdateTime
    implements Runnable {
        UpdateTime() {
        }

        @Override
        public void run() {
            MonitorPanel.this.showTime();
        }
    }

    class UpdateStatus
    implements Runnable {
        UpdateStatus() {
        }

        @Override
        public void run() {
            boolean limitsChanged = false;
            for (SubsysDesc desc : MonitorPanel.this.subsysMap.values()) {
                limitsChanged |= desc.limitChanged;
            }
            MonitorPanel.this.limitsButton.setEnabled(limitsChanged);
        }
    }

    class SubsysDesc {
        String name;
        boolean limitChanged;

        SubsysDesc() {
        }
    }
}

