package org.lsst.ccs.subsystem.monitor.ui;

import java.awt.BorderLayout;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystem.monitor.data.MonMainFullState;
import org.lsst.ccs.subsystem.monitor.data.MonMainState;

/**
 ******************************************************************************
 **
 **  Implements the generic monitor control panel / monitor panel assembly.
 **
 **  @author Owen Saxton
 **
 ******************************************************************************
 */
public class MonMainAssembly extends MonitorGui.Panel {

    MonitorAssembly mon;
    MonMainPanel panel;
    
    public MonMainAssembly(MonMainGui gui) {
        setLayout(new java.awt.BorderLayout());
        mon = new MonitorAssembly(gui);
        add(mon, BorderLayout.CENTER);
        panel = new MonMainPanel(gui);
        add(panel, BorderLayout.SOUTH);
    }

    public void setSubsystems(String[] names) {
        mon.setSubsystems(names);
        panel.setSubsystems(names);
    }

    @Override
    public void disableSystem(String name, int id) {
        panel.disableSystem(id);
        mon.disableSystem(name);
    }

    @Override
    public void updatePanel(String name, int id, Object d) {
        if (d instanceof MonMainFullState) {
            MonMainFullState mm = (MonMainFullState)d;
            mon.updateTableModel(name, mm.getMonitorFullState());
            panel.updateControlPanel(id, mm.getMonMainState());
        }
    }

    @Override
    public void handleStatusData(String name, int id, long time, String key,
                                 Object d) {
        if (key.equals(MonMainState.KEY)) {
            panel.updateControlPanel(id, (MonMainState)((KeyValueData)d).getValue());
        }
        else {
            mon.handleData(name, key, d);
        }
    }

    private static final long serialVersionUID = 1L;
}
