package org.lsst.ccs.subsystem.common.data;

import java.io.Serializable;

/**
 *  Contains data for a monitoring task.
 * 
 *  @author saxton
 */
public class MonitorTask implements Serializable {

    private final String name;       // The name of the task
    private final int index;         // The task index
    private int period;              // The period (ms) of the task
    private boolean active = false;  // Whether task is using this period
    private boolean changed = true;  // Whether a field has changed

    public MonitorTask(String name, int index, int period)
    {
        this.name = name;
        this.index = index;
        this.period = period;
    }

    public String getName()
    {
        return name;
    }

    public int getIndex()
    {
        return index;
    }

    public synchronized void setPeriod(int period)
    {
        this.period = period;
        changed = true;
    }

    public int getPeriod()
    {
        return period;
    }

    public synchronized void setActive(boolean active)
    {
        this.active = active;
        changed = true;
    }

    public boolean isActive()
    {
        return active;
    }

    public synchronized boolean hasChanged()
    {
        boolean hasChanged = changed;
        changed = false;
        return hasChanged;
    }

    private static final long serialVersionUID = -8246530043564554988L;
}
