package org.lsst.ccs.subsystem.common.devices.vacuum.states;

import java.io.Serializable;

/**
 ***************************************************************************
 **
 ** Contains the state of the vacuum device 
 ** @author Homer Neal *
 * **************************************************************************
 */
public class VDevState implements Serializable {

    private static final long serialVersionUID = -7596686997197536530L;

    public static final String KEY = "TSState";

    static int ibit = 19;
    static int LEDDEVC_ON_BIT,ACCUM_DONE_BIT,FE55_ON_BIT,CRYO_DEV_WARNING_BIT,VAC_DEV_WARNING_BIT;
    int systemState;           // Mask of state bits
    int operState;             // ordinal operating state (READY,IDLE,ACQ1,...)
    int tickMillis;            // Data status update period (ms)
    double vac;                // pressure
    double vac2;                // pressure
 
    String warning;            // any current warning string
 
    public enum onOff {

        OFF, ON;
    }

    public enum vacstates {

        NOTCONFIGURED,
        OFF,
        OK,
        ON,
        TRIPPED;
    }


    public double getVac() {
        return vac;
    }

    public void setVac(double vac) {
        this.vac = vac;
    }

    public double getVac2() {
        return vac2;
    }

    public void setVac2(double vac2) {
        this.vac2 = vac2;
    }


    @Override
    public String toString() {
        return "pressure=" + vac
                + ", pressure2=" + vac2;
    }
   

}
