package org.lsst.ccs.subsystem.common.devices.refrigeration.states;

/**
 * The thermal target to be reached. The actual set points are set on 
 * the subsystem as configuration parameters.
 * 
 * @author The LSST CCS Team
 */
public enum ThermalTarget {

    /**
     * More information is needed to assess the ThermalTarget.
     */
    UNKNOWN,
    
    /**
     * Set the current values as the ThermalTarget.
     */
    CURRENT,

    /**
     * This is the target temperature there is no cooling.
     */
    WARM,
    
    /**
     * The target temperature of the cold plate.
     */
    COLD,
    
    /**
     * The target temperature of the cryo plate.
     */
    CRYO;

}
