package org.lsst.ccs.subsystem.common.actions;

import java.io.Serializable;

/**
 * ComCam vacuum state
 * 
 * @author The LSST CCS Team.
 * 
 */
public class ComCamSharedVacState implements Serializable {

    public static final String KEY = "ComCamSharedVacState";

    public enum VacuumState { UNKNOWN, OFF, FORELINE, TURBO_OFF, TURBO_ON, ION_OFF, ION_ON,
			      VACUUM , CRYOTELCRYO_ON, CRYOTELCRYO_OFF, CRYOTELCOLD1_ON, CRYOTELCOLD1_OFF, 
			      CRYOTELCOLD2_ON, CRYOTELCOLD2_OFF};

    private VacuumState vacuumState = VacuumState.UNKNOWN;  // The vacuum state

    private int tickMillis;           // Data status update period (ms)
    
    private double pressure = -1.;           

    private boolean valveEnable = false;

    private Boolean valveOpenStateRequested = null;

    private boolean forceValveClosing = false;

    private boolean COND_CR_TRB_PRESS_10 = false;

    private boolean COND_CR_VACUUM_01 = false;

    private boolean COND_CR_VACUUM_001 = false;

    public void setTickMillis(int value) {
        tickMillis = value;
    }

    public int getTickMillis() {
        return tickMillis;
    }

    public void setVacuumState(VacuumState value) {
        vacuumState = value;
    }

    public VacuumState getVacuumState() {
        return vacuumState;
    }

    public void setPressure(double value) {
        pressure = value;
    }

    public double getPressure() {
        return pressure;
    }

    public boolean isValveEnable() {
        return valveEnable;
    }

    public void setValveEnable(boolean valveEnable) {
        this.valveEnable = valveEnable;
    }

    public Boolean isValveOpenStateRequested() {
        return valveOpenStateRequested;
    }

    public void setValveOpenStateRequested(Boolean valveOpenStateRequested) {
        this.valveOpenStateRequested = valveOpenStateRequested;
    }

    public boolean isForceValveClosing() {
        return forceValveClosing;
    }

    public void setForceValveClosing(boolean forceValveClosing) {
        this.forceValveClosing = forceValveClosing;
    }

    public boolean is_COND_CR_TRB_PRESS_10() {
        return COND_CR_TRB_PRESS_10;
    }

    public void set_COND_CR_TRB_PRESS_10(boolean COND_CR_TRB_PRESS_10) {
        this.COND_CR_TRB_PRESS_10 = COND_CR_TRB_PRESS_10;
    }

    public boolean is_COND_CR_VACUUM_01() {
        return COND_CR_VACUUM_01;
    }

    public void set_COND_CR_VACUUM_01(boolean COND_CR_VACUUM_01) {
        this.COND_CR_VACUUM_01 = COND_CR_VACUUM_01;
    }

    public boolean is_COND_CR_VACUUM_001() {
        return COND_CR_VACUUM_001;
    }

    public void set_COND_CR_VACUUM_001(boolean COND_CR_VACUUM_001) {
        this.COND_CR_VACUUM_001 = COND_CR_VACUUM_001;
    }

    private static final long serialVersionUID = 4107717663109830598L;    
}
