package org.lsst.ccs.subsystem.common.devices.vacuum.states;

/**
 *  State of TwisTorr Turbo Pump
 *  Intended to reflect pump status as read from hardware
 *
 * @author Al Eisner
 */
public enum TurboState {

    STOP         ("Pump not running"),
    WAIT_INTLK   ("Pump blocked by external interlock"),
    STARTING     ("Pump speeding up from stop to normal"),
    AUTOTUNING   ("Pump frequency reduced due to stress"),
    BRAKING      ("Pump braking"),
    NORMAL       ("Pump running at requested setting"),
    FAIL         ("Pump failure, check failure code");

    private final String description;

    TurboState(String description) {
        this.description = description;
    }

    public String getDescription() {return description;}

    /* Return state corresponding to provided ordinal */
    public static TurboState getState(int ord) {
        TurboState state = null;
        for (TurboState st : TurboState.values()) {
            if (st.ordinal() == ord) {
                state = st;
                break;
            }
        }
        if (state == null) {
            throw new IllegalArgumentException("Invalid Turbo Status value " + ord + " for TurboState.getState");
        }
        return state;
    }

}
