package org.lsst.ccs.subsystem.common.actions;

import java.io.Serializable;
import org.lsst.ccs.bus.data.Alert;

/**
 * An descriptions of the Actions that can be taken by the Power Supply Agent.
 * This enumeration, when sent as an Alarm payload, will trigger a response
 * from the Reb Power Subsystem
 * 
 * @author The LSST CCS Team.
 * 
 */
public class RebPowerAction implements Serializable {

    /**
     * The type of Actions that can be taken.
     */
    public enum Type {
        TURN_REB_OFF, 
        TURN_REB_HVBIAS_OFF;
    }
    
    /**
     * Add a given RebPowrAction payload to a given Alert.
     * @param alert      The Alert to which the payload is to be added
     * @param actionType The action to be taken.
     * @param rebPath    The path of the Reb to take the action on. 
     *                   This is in the form Rij/Reb[0-2]
     * 
     */
    public static void addRebPowerActionPayloadToAlert(Alert alert, Type actionType, String rebPath) {
        RebPowerAction action = new RebPowerAction(actionType, rebPath);
        alert.addAlertData(RebPowerAction.class.getSimpleName(), action);
    }
    
    /**
     * Get a RebPowerAction payload from the provided Alert.
     * @param alert The Alert that might contain the payload
     * @return      The contained RebPowerAction payload. null if there is no payload.
     */
    public static RebPowerAction getRebPowerActionPayloadFromAlert(Alert alert) {
        if ( alert.getAlertDataNames().contains(RebPowerAction.class.getSimpleName()) ) {
            return (RebPowerAction)alert.getAlertData(RebPowerAction.class.getSimpleName());
        }
        return null;
    }
    
    private final Type actionType;
    private final String rebPath;
    
    RebPowerAction(Type actionType, String rebPath) {
        this.actionType = actionType;
        this.rebPath = rebPath;
    }
    
    public Type getType() {
        return actionType;
    }
    
    public String getRebPath() {
        return rebPath;
    }
            
    
}
