/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.comcamvacuum;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.twistorr.TwisTorr84;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.AgentStatusAggregatorService;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.comcamvacuum.CryoTurboDevice;
import org.lsst.ccs.subsystem.comcamvacuum.IonPumpDevice;
import org.lsst.ccs.subsystem.comcamvacuum.SwitchNames;
import org.lsst.ccs.subsystem.comcamvacuum.VacPlutoDevice;
import org.lsst.ccs.subsystem.comcamvacuum.alerts.ComCamVacuumAlerts;
import org.lsst.ccs.subsystem.comcamvacuum.constants.ConditionState;
import org.lsst.ccs.subsystem.comcamvacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.comcamvacuum.constants.LatchState;
import org.lsst.ccs.subsystem.comcamvacuum.constants.PLCState;
import org.lsst.ccs.subsystem.comcamvacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.comcamvacuum.constants.SwitchState;
import org.lsst.ccs.subsystem.comcamvacuum.constants.VacuumState;
import org.lsst.ccs.subsystem.comcamvacuum.data.ComCamVacuumAgentProperties;
import org.lsst.ccs.subsystem.comcamvacuum.data.VacSysState;
import org.lsst.ccs.subsystem.comcamvacuum.data.VacuumException;
import org.lsst.ccs.subsystem.common.actions.ComCamSharedVacState;
import org.lsst.ccs.subsystem.common.devices.refrigeration.AVCCryoDevice;
import org.lsst.ccs.subsystem.common.devices.refrigeration.data.RefrigerationConfig;
import org.lsst.ccs.subsystem.common.devices.turbopump.TwisTorr84Device;
import org.lsst.ccs.subsystem.common.devices.vacuum.GPVacMon835Device;
import org.lsst.ccs.utilities.logging.Logger;

public class ComCamVacuumSubsystem
extends Subsystem
implements HasLifecycle,
Monitor.AlarmHandler,
ClearAlertHandler,
AlertListener {
    private static final double PRESS_ATMOS = 759.0;
    private static final double PRESS_TURBO_LOW = 5.0;
    private static final double PRESS_FORELINE_LOW = 5.0;
    private static final double PRESS_DIFF_LOW = 0.09;
    private static final double PRESS_DIFF_HIGH = 20.0;
    private static final double PRESS_ION_OFF = 1.1E-5;
    private static final double PRESS_ION_ENABLE = 1.2E-6;
    private static final double PRESS_VACUUM = 1.0E-7;
    private static final double DELAY_ION_OFF = 10000.0;
    private static final double COMCAM_PRESS_HIGH = 20.0;
    private static final double TURBO_MAX = 81000.0;
    private static final double TURBO_LOW = 8100.0;
    private static final double TURBO_HIGH = 40500.0;
    private static final int[] switchChannels = new int[9];
    private static final Map<TwisTorr84.PumpStatus, DeviceState> turboStateMap;
    private static final Map<Integer, ComCamVacuumAlerts> alertMap;
    private static final Map<String, Integer> revAlertMap;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Monitor.AlarmHandler alarmHandler;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService apts;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService ass;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private VacPlutoDevice plutoDevc = null;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private CryoTurboDevice cryoTurboDevc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private IonPumpDevice ionPumpDevc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    Map<String, AVCCryoDevice> avcMap = new HashMap<String, AVCCryoDevice>();
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final Map<String, Channel> channelMap = new LinkedHashMap<String, Channel>();
    private String cryoPressChan;
    private String turboPressChan;
    private String turboSpeedChan;
    private String forelinePressChan;
    private String CryoTempChan;
    private String Cold1TempChan;
    private String Cold2TempChan;
    private String IonPumpVoltageChan;
    private List<Integer> switches;
    private static final Logger LOG;
    private final VacSysState vacState = new VacSysState();
    private final ComCamSharedVacState comCamSharedVacState = new ComCamSharedVacState();
    private Set<Integer> switchSet;
    private final Device[] switchDevices = new Device[9];
    private Channel cryoPressure;
    private Channel turboPressure;
    private Channel turboSpeed;
    private Channel forelinePressure;
    private Channel CryoTemp;
    private Channel Cold1Temp;
    private Channel Cold2Temp;
    private boolean running = true;
    private final Map<String, Integer> switchNameMap = new LinkedHashMap<String, Integer>();
    private final Map<String, Boolean> activeAlertMap = new HashMap<String, Boolean>();
    private long ionOverStartTime = 0L;
    private boolean plcActive = true;
    private volatile boolean alertResponseEnabled = true;
    private boolean monAlertEnabledVATShut = false;
    private String last_alertStr;
    private boolean useInfoAlerts = System.getProperty("org.lsst.ccs.subsystem.comcamvacuumPowerInfoAlerts", "false").contains("true");
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentStatusAggregatorService aggregatorService;

    public ComCamVacuumSubsystem() {
        super("comcam-vacuum", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void postInit() {
        this.alertService.addListener((AlertListener)this);
        this.agentPropertiesService.setAgentProperty(ComCamVacuumAgentProperties.COMCAMVACUUM_TYPE_AGENT_PROPERTY, ComCamVacuumSubsystem.class.getCanonicalName());
        if (this.switches != null) {
            this.switchSet = new HashSet<Integer>(this.switches);
        } else {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Switch list", (String)"not specified");
        }
        if (this.plutoDevc != null) {
            for (int cond : this.plutoDevc.getLatchIds()) {
                this.vacState.addLatch(cond);
                this.vacState.setLatch(cond, LatchState.CLEAR);
                LOG.info((Object)("Cleared latch cond  " + cond));
            }
            for (int cond : this.plutoDevc.getConditionIds()) {
                this.vacState.addCondition(cond);
                this.vacState.setCondition(cond, ConditionState.NO);
            }
        } else {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Pluto device", (String)"not specified");
        }
        if (this.cryoTurboDevc == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Cryo turbo pump device", (String)"not specified");
        }
        if (this.ionPumpDevc == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Ion pump device", (String)"not specified");
        }
        if (this.forelinePressChan != null) {
            this.forelinePressure = this.channelMap.get(this.forelinePressChan);
        }
        if (this.cryoPressChan != null) {
            this.cryoPressure = this.channelMap.get(this.cryoPressChan);
        }
        if (this.cryoPressure == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Cryo pressure channel", (String)"not specified or not defined");
        }
        if (this.turboPressChan != null) {
            this.turboPressure = this.channelMap.get(this.turboPressChan);
        }
        if (this.turboPressure == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Turbo pump pressure channel", (String)"not specified or not defined");
        }
        if (this.turboSpeedChan != null) {
            this.turboSpeed = this.channelMap.get(this.turboSpeedChan);
        }
        if (this.turboSpeed == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Turbo pump speed channel", (String)"not specified or not defined");
        }
        List<Integer> ipChannels = this.ionPumpDevc.getChannelNumbers();
        LOG.info((Object)("ipChannel Names = " + this.ionPumpDevc.getChannelNames()));
        LOG.info((Object)("ipChannel Numbers = " + this.ionPumpDevc.getChannelNumbers()));
        Iterator<Integer> swIter = this.switchSet.iterator();
        while (swIter.hasNext()) {
            int sw = swIter.next();
            switch (sw) {
                case 0: {
                    this.switchDevices[sw] = this.cryoTurboDevc;
                    break;
                }
                case 2: {
                    this.switchDevices[sw] = null;
                    break;
                }
                case 1: {
                    this.switchDevices[sw] = this.ionPumpDevc;
                    if (ipChannels.contains(switchChannels[sw])) break;
                    swIter.remove();
                    break;
                }
                case 6: {
                    LOG.info((Object)"attempting to setup switch for CryoTelCryo");
                    this.switchDevices[sw] = (Device)this.avcMap.get("cryo");
                    break;
                }
                case 7: {
                    this.switchDevices[sw] = (Device)this.avcMap.get("cold1");
                    break;
                }
                case 8: {
                    this.switchDevices[sw] = (Device)this.avcMap.get("cold2");
                }
            }
        }
        Iterator<Object> sw = this.switchSet.iterator();
        while (sw.hasNext()) {
            int sw2 = sw.next();
            this.vacState.addSwitch(sw2);
            this.vacState.setSwitchState(sw2, SwitchState.OFFLINE);
            this.vacState.setSwitchEnable(sw2, SwitchEnable.OFF);
        }
        for (String swName : SwitchNames.NAME_MAP.keySet()) {
            int sw3 = SwitchNames.NAME_MAP.get(swName);
            if (!this.switchSet.contains(sw3)) continue;
            this.switchNameMap.put(swName, sw3);
        }
        GPVacMon835Device vqm = new GPVacMon835Device();
        LOG.info((Object)("Configured the status aggregator to listen to subsystems: " + System.getProperty("org.lsst.ccs.subsystem.teststand", "ts") + " " + System.getProperty("org.lsst.ccs.subsystem.rebps", "ccs-rebps") + " " + System.getProperty("org.lsst.ccs.subsystem.comcamvacuum", "comcamvacuum")));
    }

    public void build() {
        AgentPeriodicTask pt = new AgentPeriodicTask("vacuum-state", () -> this.updateVacuumState()).withPeriod(Duration.ofMillis(1000L));
        this.apts.scheduleAgentPeriodicTask(pt);
        this.ass.registerState(VacuumState.class, "ComCam Vacuum state", (Object)this);
        this.ass.updateAgentState(new Enum[]{VacuumState.UNKNOWN});
        for (ComCamVacuumAlerts alert : ComCamVacuumAlerts.values()) {
            this.activeAlertMap.put(alert.getId(), false);
        }
    }

    public void postStart() {
        LOG.info((Object)"ComCamVacuum subsystem started");
    }

    public boolean processAlarm(int event, int parm, String cause, String alarmName) {
        if (this.alarmHandler != null) {
            return this.alarmHandler.processAlarm(event, parm, cause, alarmName);
        }
        return false;
    }

    public void Sleep(double secs) {
        if (secs <= 0.0) {
            return;
        }
        try {
            Thread.sleep((int)(secs * 1000.0));
        }
        catch (InterruptedException ex) {
            LOG.error((Object)("Rude awakening!" + ex));
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the vacuum system state")
    public VacSysState getVacuumState() {
        this.vacState.setTickMillis(this.getTickPeriod());
        return this.vacState;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the vacuum system state")
    public ComCamSharedVacState getComCamSharedVacState() {
        this.comCamSharedVacState.setTickMillis(this.getTickPeriod());
        return this.comCamSharedVacState;
    }

    @Command(type=Command.CommandType.QUERY, description="Get switch names")
    public List<String> getSwitchNames() throws VacuumException {
        return new ArrayList<String>(this.switchNameMap.keySet());
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on/off a switch")
    public void setSwitchOn(@Argument(description="The switch number") int sw, @Argument(description="Whether to turn on") boolean on) throws VacuumException {
        try {
            if (!this.switchSet.contains(sw)) {
                throw new VacuumException("Invalid switch number: " + sw);
            }
            this.setSwitch(sw, on);
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Turn on/off a named switch")
    public void setNamedSwitchOn(@Argument(description="The switch name") String name, @Argument(description="Whether to turn on") boolean on) throws VacuumException {
        Integer sw = this.switchNameMap.get(name);
        try {
            if (sw == null) {
                throw new VacuumException("Invalid switch name: " + name);
            }
            this.setSwitch(sw, on);
        }
        finally {
            this.publishState();
        }
    }

    private void setSwitch(int sw, boolean on) throws VacuumException {
        SwitchState state = this.vacState.getSwitchState(sw);
        LOG.info((Object)("setSwitch called for sw = " + sw));
        if (state == SwitchState.OFFLINE) {
            LOG.info((Object)("Switch sw = " + sw + " is offline"));
            if (sw != 2) {
                return;
            }
            LOG.info((Object)"proceeding exceptionally for the VAT valve switch which will directly set the state as a request");
        }
        SwitchEnable enable = this.vacState.getSwitchEnable(sw);
        if (on && enable != SwitchEnable.ON && enable != SwitchEnable.WAS_ON) {
            LOG.info((Object)("enable = " + (Object)((Object)enable) + " SwitchEnable.ON = " + (Object)((Object)SwitchEnable.ON) + " SwitchEnable.WAS_ON = " + (Object)((Object)SwitchEnable.WAS_ON)));
            return;
        }
        LOG.info((Object)("proceeding with setting switch sw = " + sw));
        Device swDevice = this.switchDevices[sw];
        try {
            if (swDevice instanceof TwisTorr84Device) {
                if (on) {
                    ((TwisTorr84Device)swDevice).startTurboPump();
                } else {
                    ((TwisTorr84Device)swDevice).stopTurboPump();
                }
            } else if (swDevice == this.ionPumpDevc) {
                this.ionPumpDevc.setChannelOn(switchChannels[sw], on);
            } else if (sw == 2) {
                LOG.info((Object)"Setting VAT valve REQUEST state");
                if (on) {
                    this.vacState.setSwitchState(sw, SwitchState.ON);
                    this.setMonAlertEnabledVATShut(false);
                } else {
                    this.vacState.setSwitchState(sw, SwitchState.OFF);
                }
            } else if (sw == 6 || sw == 7 || sw == 8) {
                LOG.info((Object)("setting CryoTel (sw = " + sw + " ) to state " + (on ? "ON" : "OFF")));
                ((AVCCryoDevice)swDevice).setMode(on ? "ON" : "OFF");
            } else {
                LOG.info((Object)("swDevice not identified for sw=" + sw));
            }
        }
        catch (DriverException e) {
            throw new VacuumException((Exception)((Object)e));
        }
    }

    private Boolean isSwitchOn(int sw) {
        Boolean value = false;
        Device swDevice = this.switchDevices[sw];
        if (swDevice instanceof TwisTorr84Device) {
            try {
                DeviceState st = turboStateMap.get(((TwisTorr84Device)swDevice).readTurboStatus());
                value = st != DeviceState.STOPPED && st != DeviceState.BRAKING;
            }
            catch (DriverException e) {
                value = null;
            }
        } else if (swDevice == this.plutoDevc) {
            if (this.plutoDevc != null) {
                value = this.plutoDevc.isSwitchOn(switchChannels[sw]);
            }
        } else if (swDevice == this.ionPumpDevc) {
            value = this.ionPumpDevc.isChannelOn(switchChannels[sw]);
        } else if (sw == 6 || sw == 7 || sw == 8) {
            try {
                value = ((AVCCryoDevice)swDevice).getMode().contains("ON") || ((AVCCryoDevice)swDevice).getMode().contains("POWER");
            }
            catch (DriverException ex) {
                LOG.error((Object)ex);
            }
        } else if (sw == 2) {
            value = null;
            if (this.vacState.getSwitchState(sw) != SwitchState.OFFLINE) {
                value = this.vacState.getSwitchState(sw) == SwitchState.ON;
            }
        }
        return value;
    }

    @Command(type=Command.CommandType.ACTION, description="Clear a condition")
    public void clearLatch(@Argument(description="The condition number") int cond) throws VacuumException {
        try {
            this.plutoDevc.clearLatch(cond);
        }
        finally {
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update interval")
    public void setUpdatePeriod(@Argument(description="The tick period (ms)") int value) {
        this.setTickPeriod(value);
        this.vacState.setTickMillis(this.getTickPeriod());
        this.publishState();
    }

    private void updateVacuumState() {
        ComCamSharedVacState.VacuumState cvState;
        VacuumState vState;
        Boolean active;
        int cond;
        Enum oldState;
        double cryoPr;
        if (!this.running) {
            return;
        }
        Boolean plcActive = this.plutoDevc.isPLCActive();
        if (plcActive == null) {
            if (this.vacState.getPlcState() != PLCState.OFFLINE) {
                this.raiseAlert(ComCamVacuumAlerts.VACUUM_PLC_NOT_ALIVE, "Vacuum PLC is offline");
                this.vacState.setPlcState(PLCState.OFFLINE);
            }
        } else if (!plcActive.booleanValue()) {
            if (this.vacState.getPlcState() != PLCState.DEAD) {
                this.raiseAlert(ComCamVacuumAlerts.VACUUM_PLC_NOT_ALIVE, "Vacuum PLC has died");
                this.vacState.setPlcState(PLCState.DEAD);
            }
        } else if (this.vacState.getPlcState() != PLCState.ALIVE) {
            this.lowerAlert(ComCamVacuumAlerts.VACUUM_PLC_NOT_ALIVE, "Vacuum PLC is alive");
            this.vacState.setPlcState(PLCState.ALIVE);
        }
        double forelinePr = 0.0;
        if (this.forelinePressChan != null) {
            this.forelinePressure.readValue();
        }
        double turboPr = cryoPr = this.cryoPressure.readValue();
        double turboSp = this.turboSpeed.readValue();
        boolean changed = false;
        boolean forcedVATclosing = false;
        for (int sw = 0; sw < 9; ++sw) {
            SwitchEnable enabled;
            Boolean isOn;
            if (!this.vacState.hasSwitch(sw)) continue;
            Boolean enable = false;
            boolean turnOff = false;
            DeviceState devState = null;
            switch (sw) {
                case 2: {
                    if (!(Double.isNaN(cryoPr) || Double.isNaN(turboPr) || Double.isNaN(turboSp))) {
                        double prDiff = Math.abs(turboPr - cryoPr);
                        enable = prDiff <= 20.0 && turboSp < 8100.0 || prDiff <= 0.09 && turboSp > 40500.0;
                    }
                    boolean enable2 = !Double.isNaN(forelinePr) && !Double.isNaN(turboSp) && (forelinePr < 5.0 || turboSp < 8100.0);
                    enable = enable & enable2;
                    boolean enable3 = turboPr > 20.0 || turboSp > 40500.0;
                    enable = enable & enable3;
                    if (!Double.isNaN(turboPr)) {
                        turnOff = !enable2;
                    }
                    forcedVATclosing = turnOff;
                    break;
                }
                case 0: {
                    LOG.fine((Object)("turboPr = " + turboPr + " forelinePr = " + forelinePr + " turboSp = " + turboSp));
                    if (!(Double.isNaN(turboPr) || Double.isNaN(forelinePr) || Double.isNaN(turboSp))) {
                        enable = turboPr < 5.0 && (forelinePr < 5.0 || turboSp < 8100.0);
                        LOG.fine((Object)("turbo enable = " + enable + " turboPr = " + turboPr + " PRESS_TURBO_LOW =" + 5.0));
                    }
                    if (!Double.isNaN(turboPr)) {
                        turnOff = enable == false;
                    }
                    try {
                        devState = turboStateMap.get(((CryoTurboDevice)this.switchDevices[sw]).readTurboStatus());
                    }
                    catch (DriverException driverException) {}
                    break;
                }
                case 1: {
                    if (!Double.isNaN(cryoPr)) {
                        enable = cryoPr < 1.2E-6;
                        if (cryoPr >= 1.1E-5) {
                            if (this.ionOverStartTime == 0L) {
                                this.ionOverStartTime = System.currentTimeMillis();
                                break;
                            }
                            turnOff = (double)(System.currentTimeMillis() - this.ionOverStartTime) >= 10000.0;
                            break;
                        }
                        this.ionOverStartTime = 0L;
                        break;
                    }
                    turnOff = true;
                    break;
                }
                case 6: {
                    enable = true;
                    break;
                }
                case 7: {
                    enable = true;
                    break;
                }
                case 8: {
                    enable = true;
                }
            }
            oldState = this.vacState.getSwitchState(sw);
            if (turnOff && oldState == SwitchState.ON) {
                try {
                    this.setSwitch(sw, false);
                }
                catch (VacuumException e) {
                    LOG.error((Object)("Error setting switch: " + e));
                }
            }
            SwitchState state = (isOn = this.isSwitchOn(sw)) != null ? (isOn.booleanValue() ? SwitchState.ON : SwitchState.OFF) : SwitchState.OFFLINE;
            SwitchEnable switchEnable = enabled = enable != false ? SwitchEnable.ON : SwitchEnable.OFF;
            if (state != oldState || enabled != this.vacState.getSwitchEnable(sw)) {
                LOG.info((Object)("Enabling switch sw=" + sw + " enabled = " + (Object)((Object)enabled)));
                this.vacState.setSwitchState(sw, state);
                this.vacState.setSwitchEnable(sw, enabled);
                changed = true;
            }
            if (devState == this.vacState.getDeviceState(sw)) continue;
            this.vacState.setDeviceState(sw, devState);
            changed = true;
        }
        for (cond = 0; cond < 8; ++cond) {
            LatchState state;
            if (!this.vacState.hasLatch(cond)) continue;
            active = this.plutoDevc.isLatchActive(cond);
            Boolean latched = this.plutoDevc.isLatchLatched(cond);
            if (cond == 1 || cond == 2) {
                active = forcedVATclosing;
            }
            if ((state = active == null || latched == null ? LatchState.OFFLINE : (latched != false ? LatchState.LATCHED : (active != false ? LatchState.ACTIVE : LatchState.CLEAR))) == (oldState = this.vacState.getLatch(cond))) continue;
            this.vacState.setLatch(cond, state);
            ComCamVacuumAlerts alert = alertMap.get(cond);
            if (state == LatchState.ACTIVE) {
                this.raiseAlert(alert, "Vacuum PLC error condition set");
            } else if (state != LatchState.OFFLINE && oldState == LatchState.ACTIVE) {
                this.lowerAlert(alert, "Vacuum PLC error condition cleared");
            }
            changed = true;
        }
        for (cond = 0; cond < 14; ++cond) {
            ConditionState state;
            if (!this.vacState.hasCondition(cond)) continue;
            active = this.plutoDevc.isConditionActive(cond);
            if (cond == 2) {
                active = cryoPr < 10.0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            if (cond == 3) {
                active = cryoPr < 0.1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            if (cond == 4) {
                active = cryoPr < 0.001 ? Boolean.valueOf(true) : Boolean.valueOf(false);
            }
            ConditionState conditionState = active == null ? ConditionState.OFF : (state = active != false ? ConditionState.YES : ConditionState.NO);
            if (state == this.vacState.getCondition(cond)) continue;
            this.vacState.setCondition(cond, state);
            changed = true;
        }
        if (Double.isNaN(cryoPr)) {
            vState = VacuumState.UNKNOWN;
            cvState = ComCamSharedVacState.VacuumState.UNKNOWN;
        } else if (cryoPr <= 1.0E-7 && this.vacState.getSwitchEnable(2) == SwitchEnable.ON) {
            vState = VacuumState.VACUUM;
            cvState = ComCamSharedVacState.VacuumState.VACUUM;
        } else if (this.vacState.getSwitchState(1) == SwitchState.ON && this.vacState.getSwitchEnable(2) == SwitchEnable.ON) {
            vState = VacuumState.ION_ON;
            cvState = ComCamSharedVacState.VacuumState.ION_ON;
        } else if (this.vacState.getSwitchEnable(1) == SwitchEnable.ON && this.vacState.getSwitchEnable(2) == SwitchEnable.ON) {
            vState = VacuumState.ION_OFF;
            cvState = ComCamSharedVacState.VacuumState.ION_OFF;
        } else if (this.vacState.getSwitchState(0) == SwitchState.ON && this.vacState.getSwitchEnable(2) == SwitchEnable.ON) {
            vState = VacuumState.TURBO_ON;
            cvState = ComCamSharedVacState.VacuumState.TURBO_ON;
        } else if (this.vacState.getSwitchEnable(0) == SwitchEnable.ON && this.vacState.getSwitchEnable(2) == SwitchEnable.ON) {
            vState = VacuumState.TURBO_OFF;
            cvState = ComCamSharedVacState.VacuumState.TURBO_OFF;
        } else if (cryoPr < 759.0) {
            vState = VacuumState.FORELINE;
            cvState = ComCamSharedVacState.VacuumState.FORELINE;
        } else {
            vState = VacuumState.OFF;
            cvState = ComCamSharedVacState.VacuumState.OFF;
        }
        if (vState != this.vacState.getVacuumState()) {
            this.vacState.setVacuumState(vState);
            this.ass.updateAgentState(new Enum[]{vState});
            changed = true;
        }
        if (changed) {
            this.publishState();
        }
        if (cvState != this.comCamSharedVacState.getVacuumState()) {
            this.comCamSharedVacState.setVacuumState(cvState);
        }
        this.comCamSharedVacState.setPressure(cryoPr);
        this.comCamSharedVacState.setForceValveClosing(forcedVATclosing || this.isMonAlertEnabledVATShut());
        if (forcedVATclosing || this.isMonAlertEnabledVATShut()) {
            this.vacState.setSwitchState(2, SwitchState.OFF);
        }
        if (this.vacState.getSwitchState(2) != SwitchState.OFFLINE) {
            this.comCamSharedVacState.setValveOpenStateRequested(Boolean.valueOf(this.vacState.getSwitchState(2) == SwitchState.ON));
        } else {
            this.comCamSharedVacState.setValveOpenStateRequested(null);
        }
        this.comCamSharedVacState.set_COND_CR_TRB_PRESS_10(this.vacState.getCondition(2) == ConditionState.YES);
        this.comCamSharedVacState.set_COND_CR_VACUUM_01(this.vacState.getCondition(3) == ConditionState.YES);
        this.comCamSharedVacState.set_COND_CR_VACUUM_001(this.vacState.getCondition(4) == ConditionState.YES);
        this.comCamSharedVacState.setValveEnable(this.vacState.getSwitchEnable(2) == SwitchEnable.ON);
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("ComCamSharedVacState", (Serializable)this.getComCamSharedVacState()));
    }

    @Command(type=Command.CommandType.ACTION, description="Enable/disable alert response")
    public void enableAlertResponse(boolean enable) {
        this.alertResponseEnabled = enable;
    }

    @Command(type=Command.CommandType.QUERY, description="Get true/false if the alert response is enabled")
    public boolean isAlertResponseEnabled() {
        return this.alertResponseEnabled;
    }

    @Command(type=Command.CommandType.ACTION, description="Enable/disable vacuum monitoring VAT shutting action")
    public void setMonAlertEnabledVATShut(boolean enable) {
        this.monAlertEnabledVATShut = enable;
    }

    @Command(type=Command.CommandType.QUERY, description="Get true/false if the alert response is enabled")
    public boolean isMonAlertEnabledVATShut() {
        return this.monAlertEnabledVATShut;
    }

    private void raiseAlert(ComCamVacuumAlerts alert, String cond) {
        this.alertService.raiseAlert(alert.getAlert(), AlertState.ALARM, cond);
        this.activeAlertMap.put(alert.getId(), true);
    }

    private boolean isAlertRaised(ComCamVacuumAlerts alert) {
        return this.activeAlertMap.get(alert.getId()).equals(Boolean.TRUE);
    }

    private void lowerAlert(ComCamVacuumAlerts alert, String cond) {
        this.alertService.raiseAlert(alert.getAlert(), AlertState.NOMINAL, cond);
        this.activeAlertMap.put(alert.getId(), false);
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
        Boolean active = this.activeAlertMap.get(alert.getAlertId());
        return active == null ? ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT : (active != false ? ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.CLEAR_ALERT);
    }

    public void onAlert(AlertEvent event) {
        if (event.getType() != AlertEvent.AlertEventType.ALERT_CLEARED) {
            return;
        }
        for (String id : event.getClearedIds()) {
            Integer cond = revAlertMap.get(id);
            if (cond == null) continue;
            try {
                this.clearLatch(cond);
            }
            catch (VacuumException e) {
                LOG.log(Level.SEVERE, "Error clearing latched PLC condition ({0}): {1}", new Object[]{cond, e});
            }
        }
    }

    private void publishState() {
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("ComCamVacuumState", (Serializable)this.getVacuumState()));
        this.subsys.publishSubsystemDataOnStatusBus(new KeyValueData("ComCamSharedVacState", (Serializable)this.getComCamSharedVacState()));
    }

    private void setTickPeriod(long period) {
        this.apts.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.apts.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    static {
        ComCamVacuumSubsystem.switchChannels[1] = 2;
        ComCamVacuumSubsystem.switchChannels[5] = 3;
        ComCamVacuumSubsystem.switchChannels[2] = 0;
        ComCamVacuumSubsystem.switchChannels[6] = RefrigerationConfig.CryoTelType.CRYO.ordinal();
        ComCamVacuumSubsystem.switchChannels[7] = RefrigerationConfig.CryoTelType.COLD1.ordinal();
        ComCamVacuumSubsystem.switchChannels[8] = RefrigerationConfig.CryoTelType.COLD2.ordinal();
        turboStateMap = new HashMap<TwisTorr84.PumpStatus, DeviceState>();
        turboStateMap.put(TwisTorr84.PumpStatus.STOP, DeviceState.STOPPED);
        turboStateMap.put(TwisTorr84.PumpStatus.WAIT_INTLK, DeviceState.WAITING);
        turboStateMap.put(TwisTorr84.PumpStatus.STARTING, DeviceState.STARTNG);
        turboStateMap.put(TwisTorr84.PumpStatus.NORMAL, DeviceState.NORMAL);
        turboStateMap.put(TwisTorr84.PumpStatus.BRAKING, DeviceState.BRAKING);
        turboStateMap.put(TwisTorr84.PumpStatus.FAIL, DeviceState.FAILED);
        turboStateMap.put(TwisTorr84.PumpStatus.AUTO_TUNING, DeviceState.AUTOTUN);
        alertMap = new HashMap<Integer, ComCamVacuumAlerts>();
        alertMap.put(0, ComCamVacuumAlerts.CRYO_VACUUM_BAD);
        alertMap.put(1, ComCamVacuumAlerts.CRYO_GATE_FORCED_SHUT);
        alertMap.put(2, ComCamVacuumAlerts.CRYO_GATE_CANNOT_OPEN);
        alertMap.put(3, ComCamVacuumAlerts.CRYO_TURBO_PUMP_BAD);
        alertMap.put(4, ComCamVacuumAlerts.HX_VACUUM_BAD);
        alertMap.put(5, ComCamVacuumAlerts.HX_GATE_FORCED_SHUT);
        alertMap.put(6, ComCamVacuumAlerts.HX_GATE_CANNOT_OPEN);
        alertMap.put(7, ComCamVacuumAlerts.HX_TURBO_PUMP_BAD);
        revAlertMap = new HashMap<String, Integer>();
        for (int cond : alertMap.keySet()) {
            revAlertMap.put(alertMap.get(cond).getId(), cond);
        }
        LOG = Logger.getLogger((String)ComCamVacuumSubsystem.class.getName());
    }
}

