/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataManager;
import jas.hist.JASHist;
import jas.hist.JASHistAxis;
import jas.hist.JASHistData;
import jas.hist.StatisticsBlock;
import jas.hist.SupportsFunctions;
import jas.plot.DataArea;
import jas.plot.EditableLabel;
import jas.plot.Legend;
import jas.plot.MovableObject;
import jas.plot.Title;
import jas.util.ColorConverter;
import jas.util.ScientificFormat;
import jas.util.border.ShadowBorder;
import jas.util.xml.XMLWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.io.Writer;
import java.text.Format;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

final class XMLPrintWriter
extends XMLWriter {
    XMLPrintWriter(Writer w) {
        super(w);
    }

    void print(JASHist plot, boolean snapshot) {
        DataArea d;
        this.printPlotHeader();
        Title t = plot.getTitleObject();
        if (t != null && t.isVisible()) {
            this.print(t);
        }
        this.print(plot.getLegend(), plot.getShowLegend());
        StatisticsBlock s = plot.getStats();
        if (s != null && s.isVisible()) {
            this.print(s);
        }
        if ((d = plot.getDataArea()) != null && d.isVisible()) {
            this.print(d, plot.getDataManager(), snapshot);
        }
        this.setAttribute("width", plot.getWidth());
        this.setAttribute("height", plot.getHeight());
        this.printTag("bounds");
        this.printColorScheme(plot);
        this.printPlotFooter();
    }

    void printColorScheme(Component c) {
        Container pp = c.getParent();
        Color fg = c.getForeground();
        Color bg = c.getBackground();
        if (pp == null || fg != pp.getForeground() || bg != pp.getBackground()) {
            if (pp == null || fg != pp.getForeground()) {
                this.setAttribute("foregroundColor", ColorConverter.colorToString(fg));
            }
            if (pp == null || bg != pp.getBackground()) {
                this.setAttribute("backgroundColor", ColorConverter.colorToString(bg));
            }
            this.printTag("colorScheme");
        }
    }

    void print(Title t) {
        this.openTag("title");
        this.print(t.getInsideBorder());
        this.printBounds(t);
        this.print(t.getLabel());
        this.printColorScheme(t);
        this.closeTag();
    }

    void print(JASHistAxis a, String p_location) {
        int type = a.getAxisType();
        this.setAttribute("location", p_location);
        this.setAttribute("type", XMLPrintWriter.convertAxisTypeToString(type));
        this.setAttribute("showOverflows", a.getShowOverflows());
        if (a.isBinned()) {
            this.setAttribute("numberOfBins", a.getBins());
        }
        if (type != 2) {
            this.setAttribute("logarithmic", a.isLogarithmic());
            this.setAttribute("allowSuppressedZero", a.getAllowSuppressedZero());
            if (!a.getRangeAutomatic()) {
                this.setAttribute("min", a.getMin());
                this.setAttribute("max", a.getMax());
            }
        }
        this.openTag("axis");
        EditableLabel label = a.getLabelObject();
        if (label != null) {
            this.print(label);
        }
        this.print(a.getFont());
        this.closeTag();
    }

    void print(EditableLabel label) {
        this.setAttribute("text", label.getText());
        this.openTag("label");
        this.print(label.getFont());
        this.closeTag();
    }

    void print(Legend legend, int visibility) {
        this.setAttribute("visible", XMLPrintWriter.convertLegendToString(visibility));
        this.openTag("legend");
        if (legend != null && legend.isVisible()) {
            this.print(legend.getInsideBorder());
            this.printBounds(legend);
            this.printColorScheme(legend);
            this.print(legend.getFont());
            int n = legend.getNEntries();
            for (int i = 0; i < n; ++i) {
                String title = legend.getCurrentTitle(i);
                if (!legend.isTitleChanged(i)) continue;
                this.setAttribute("title", title);
                this.setAttribute("index", String.valueOf(i));
                this.printTag("legendEntry");
            }
        }
        this.closeTag();
    }

    void print(StatisticsBlock stats) {
        String[] elements;
        this.setAttribute("showTitles", XMLPrintWriter.convertShowTitleToString(stats.getShowTitles()));
        this.setAttribute("alignment", XMLPrintWriter.convertAlignmentToString(stats.getSplitStringAlign()));
        this.openTag("stats");
        this.print(stats.getInsideBorder());
        this.printBounds(stats);
        this.printColorScheme(stats);
        this.print(stats.getFont());
        Format format = stats.getFormat();
        if (format instanceof ScientificFormat) {
            this.print((ScientificFormat)stats.getFormat());
        }
        if ((elements = stats.getSelectedEntries()) != null) {
            for (int i = 0; i < elements.length; ++i) {
                this.setAttribute("name", elements[i]);
                this.printTag("statsEntry");
            }
        }
        this.closeTag();
    }

    void print(ScientificFormat format) {
        this.setAttribute("maximumWidth", format.getMaxWidth());
        this.setAttribute("significantDigits", format.getSigDigits());
        if (format.getScientificNotationStyle()) {
            this.setAttribute("style", "pure");
        }
        this.printTag("format");
    }

    void printBinnedDataAxisAttributes(String axis, String min, String max, String numberOfBins, String type) {
        this.setAttribute("axis", axis);
        this.setAttribute("min", min);
        this.setAttribute("max", max);
        this.setAttribute("numberOfBins", numberOfBins);
        this.setAttribute("type", type);
        this.printTag("binnedDataAxisAttributes");
    }

    void printPointDataAxisAttributes(String axis, String type) {
        this.setAttribute("axis", axis);
        this.setAttribute("type", type);
        this.printTag("pointDataAxisAttributes");
    }

    void print(DataArea da, DataManager dm, boolean snapshot) {
        JASHistData theData;
        this.openTag("dataArea");
        this.print(da.getInsideBorder());
        this.printBounds(da);
        this.printColorScheme(da);
        Enumeration e = dm.getDataSources();
        while (e.hasMoreElements()) {
            theData = (JASHistData)e.nextElement();
            if (!theData.isShowing()) continue;
            this.print(theData, snapshot);
        }
        if (dm instanceof SupportsFunctions) {
            e = ((SupportsFunctions)((Object)dm)).getFunctions();
            while (e.hasMoreElements()) {
                theData = (JASHistData)e.nextElement();
                if (!theData.isShowing()) continue;
                this.print(theData, snapshot);
            }
        }
        JASHistAxis theXAxis = dm.getXAxis();
        this.print(theXAxis, "x0");
        JASHistAxis[] theYAxes = dm.getYAxes();
        for (int i = 0; i < theYAxes.length; ++i) {
            if (theYAxes[i] == null) continue;
            this.print(theYAxes[i], "y" + i);
        }
        this.closeTag();
    }

    void print(JASHistData data, boolean snapshot) {
        data.writeAsXML(this, snapshot);
    }

    void printPlotHeader() {
        this.openDoc("1.0", "ISO-8859-1", false);
        this.referToDTD("plotML", "plotML.dtd");
        this.openTag("plotML");
        this.openTag("plot");
    }

    void printPlotFooter() {
        this.closeTag();
        this.closeTag();
    }

    void printBounds(MovableObject t) {
        if (!t.hasDefaultLayout()) {
            this.setAttribute("x", t.getX());
            this.setAttribute("y", t.getY());
            this.setAttribute("width", t.getWidth());
            this.setAttribute("height", t.getHeight());
            this.printTag("bounds");
        }
    }

    void print(Border b) {
        if (b == null) {
            this.setAttribute("type", "None");
        } else if (b == BorderFactory.createLoweredBevelBorder()) {
            this.setAttribute("type", "Bevel In");
        } else if (b == BorderFactory.createRaisedBevelBorder()) {
            this.setAttribute("type", "Bevel Out");
        } else if (b == BorderFactory.createEtchedBorder()) {
            this.setAttribute("type", "Etched");
        } else if (b instanceof ShadowBorder) {
            this.setAttribute("type", "Shadow");
        } else if (b instanceof LineBorder) {
            this.setAttribute("type", "Line");
            this.setAttribute("color", ColorConverter.colorToString(((LineBorder)b).getLineColor()));
        } else {
            this.setAttribute("type", "None");
        }
        this.printTag("border");
    }

    void print(Font f) {
        String theStyle;
        switch (f.getStyle()) {
            default: {
                theStyle = "PLAIN";
                break;
            }
            case 1: {
                theStyle = "BOLD";
                break;
            }
            case 2: {
                theStyle = "ITALIC";
                break;
            }
            case 3: {
                theStyle = "BOLD+ITALIC";
            }
        }
        this.setAttribute("face", f.getName());
        this.setAttribute("points", f.getSize());
        this.setAttribute("style", theStyle);
        this.printTag("font");
    }

    static String convertStyleToString(int style) {
        switch (style) {
            case 1: {
                return "box";
            }
            case 8: {
                return "circle";
            }
            case 7: {
                return "cross";
            }
            case 3: {
                return "diamond";
            }
            case 0: {
                return "dot";
            }
            case 6: {
                return "horiz line";
            }
            case 9: {
                return "square";
            }
            case 4: {
                return "star";
            }
            case 2: {
                return "triangle";
            }
            case 5: {
                return "vert line";
            }
        }
        System.err.println("ERROR: unrecognized style, using default instead.");
        return "box";
    }

    static int convertStringToStyle(String s) {
        if (s.equalsIgnoreCase("box")) {
            return 1;
        }
        if (s.equalsIgnoreCase("circle")) {
            return 8;
        }
        if (s.equalsIgnoreCase("cross")) {
            return 7;
        }
        if (s.equalsIgnoreCase("diamond")) {
            return 3;
        }
        if (s.equalsIgnoreCase("dot")) {
            return 0;
        }
        if (s.equalsIgnoreCase("horiz line")) {
            return 6;
        }
        if (s.equalsIgnoreCase("square")) {
            return 9;
        }
        if (s.equalsIgnoreCase("star")) {
            return 4;
        }
        if (s.equalsIgnoreCase("triangle")) {
            return 2;
        }
        if (s.equalsIgnoreCase("vert line")) {
            return 5;
        }
        System.err.println("ERROR: unrecognized style, using default instead.");
        return 1;
    }

    static String convertAxisTypeToString(int type) {
        switch (type) {
            case 2: {
                return "string";
            }
            case 1: {
                return "double";
            }
            case 3: {
                return "date";
            }
            case 5: {
                return "time";
            }
        }
        System.err.println("ERROR: unrecognized axis type, using double instead.");
        return "double";
    }

    static int convertStringToAxisType(String s) {
        if (s.equalsIgnoreCase("string")) {
            return 2;
        }
        if (s.equalsIgnoreCase("double")) {
            return 1;
        }
        if (s.equalsIgnoreCase("date")) {
            return 3;
        }
        if (s.equalsIgnoreCase("time")) {
            return 5;
        }
        System.err.println("ERROR: unrecognized axis type, using double instead.");
        return 1;
    }

    private static String convertLegendToString(int legend) {
        switch (legend) {
            case 1: {
                return "automatic";
            }
            case 0: {
                return "never";
            }
            case 2: {
                return "always";
            }
        }
        System.err.println("ERROR: unrecognized legend type, using AUTOMATIC instead.");
        return "automatic";
    }

    static int convertStringToLegend(String s) {
        if (s.equalsIgnoreCase("automatic")) {
            return 1;
        }
        if (s.equalsIgnoreCase("always")) {
            return 2;
        }
        if (s.equalsIgnoreCase("never")) {
            return 0;
        }
        if (s.equalsIgnoreCase("true")) {
            return 2;
        }
        if (s.equalsIgnoreCase("false")) {
            return 0;
        }
        System.err.println("ERROR: unrecognized legend type, using AUTOMATIC instead");
        return 1;
    }

    private static String convertShowTitleToString(int showTitle) {
        switch (showTitle) {
            case 3: {
                return "automatic";
            }
            case 2: {
                return "never";
            }
            case 1: {
                return "always";
            }
        }
        System.err.println("ERROR: unrecognized showTitles type, using AUTOMATIC instead.");
        return "automatic";
    }

    static int convertStringToShowTitle(String s) {
        if (s.equalsIgnoreCase("automatic")) {
            return 3;
        }
        if (s.equalsIgnoreCase("never")) {
            return 2;
        }
        if (s.equalsIgnoreCase("always")) {
            return 1;
        }
        System.err.println("ERROR: unrecognized showTitle type, using SHOWTITLES_AUTOMATIC instead");
        return 3;
    }

    private static String convertAlignmentToString(int alignment) {
        switch (alignment) {
            case 1: {
                return "left";
            }
            case 2: {
                return "right";
            }
            case 3: {
                return "none";
            }
        }
        System.err.println("ERROR: unrecognized alignment type, using NONE instead.");
        return "none";
    }

    static int convertStringToAlignment(String s) {
        if (s.equalsIgnoreCase("left")) {
            return 1;
        }
        if (s.equalsIgnoreCase("right")) {
            return 2;
        }
        if (s.equalsIgnoreCase("none")) {
            return 3;
        }
        System.err.println("ERROR: unrecognized alignment type, using NOALIGNSPLIT instead");
        return 3;
    }
}

