/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.monitor;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class Control
implements HasLifecycle {
    protected String description = "";
    protected int hwChan = 0;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    protected Device devc;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected Monitor mon;
    protected Logger log;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;

    @Override
    public void init() {
        this.log = this.subsys.getLogger();
        this.configure(this.mon, this.devc);
    }

    protected void configure(Monitor mon, Device devc) {
    }

    public String getDescription() {
        return this.description;
    }

    public int getHwChan() {
        return this.hwChan;
    }

    protected void checkOnline() {
        this.devc.checkOnline();
    }

    protected boolean testOnline() {
        return this.devc.testOnline();
    }

    protected void checkTimeout(Exception e, Class<?> eClass) throws Exception {
        this.devc.checkTimeout(e, eClass);
    }

    public String getName() {
        return this.name;
    }

    public Subsystem getSubsystem() {
        return this.subsys;
    }
}

