/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.jas3;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import org.freehep.application.Application;
import org.freehep.application.ApplicationEvent;
import org.freehep.jas.JAS3;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.jas3.Jas3Console;
import org.lsst.ccs.gconsole.util.ThreadUtil;
import org.openide.util.Lookup;

public class ConsoleApplication
extends JAS3 {
    private final AtomicBoolean exiting = new AtomicBoolean(false);
    private final TreeMap<Integer, Action> toolBar = new TreeMap();

    public ConsoleApplication() {
        super("CCS_Console");
    }

    public static void main(String[] args) {
        ThreadUtil.invokeLater(() -> {
            try {
                JFrame top = new ConsoleApplication().createFrame(args);
                top.setTitle("CCS Console : " + System.getProperty("user.name", ""));
                top.setVisible(true);
            }
            catch (HeadlessException x) {
                System.out.println("Fatal Error: " + x.getMessage());
            }
            catch (Throwable t) {
                System.out.println("Fatal Error: " + t.getMessage());
                ConsoleApplication.error(null, (String)"Fatal Error", (Throwable)t);
                System.exit(1);
            }
        });
    }

    protected void init() {
        super.init();
        Properties pp = this.getUserProperties();
        try {
            int x = Integer.parseInt(pp.getProperty("window-x"));
            int y = Integer.parseInt(pp.getProperty("window-y"));
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            int w = gd.getDisplayMode().getWidth();
            int h = gd.getDisplayMode().getHeight();
            if (x < 0 || x > w - 50) {
                pp.setProperty("window-x", "0");
            }
            if (y < 0 || y > h - 50) {
                pp.setProperty("window-y", "0");
            }
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireApplicationVisible(ApplicationEvent event) {
        super.fireApplicationVisible(event);
        TreeMap<Integer, Action> treeMap = this.toolBar;
        synchronized (treeMap) {
            JToolBar tb = new JToolBar();
            tb.setFloatable(false);
            this.toolBar.values().forEach(action -> tb.add((Action)action));
            this.addToolBar(tb, "CCS");
        }
    }

    public void exit() {
        if (this.exiting.getAndSet(true)) {
            return;
        }
        try {
            ThreadUtil.invokeAndWait(() -> {
                try {
                    Collection plugins = this.getLookup().lookup(new Lookup.Template(ConsolePlugin.class, null, null)).allInstances();
                    plugins.forEach(plugin -> {
                        try {
                            plugin.stop();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                    plugins.forEach(plugin -> {
                        try {
                            plugin.shutdown();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    });
                    Console.getConsole().shutdownAgent();
                }
                catch (Throwable t) {
                    System.out.println(t);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
        ((Jas3Console)Console.getConsole()).superShutdownAgent();
        super.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertToolbarAction(Action action, int position) {
        TreeMap<Integer, Action> treeMap = this.toolBar;
        synchronized (treeMap) {
            this.toolBar.put(position, action);
        }
    }

    protected Properties createAppProperties() throws Application.InitializationException {
        String appName;
        Properties appProp = super.createAppProperties();
        Properties ccsProp = BootstrapResourceUtils.getBootstrapProperties((String)"gui.properties");
        String prefName = ccsProp.getProperty("org.lsst.ccs.gui.preferences", appName = ccsProp.getProperty("org.lsst.ccs.application.name"));
        if (prefName != null) {
            if (!prefName.endsWith(".properties")) {
                prefName = prefName + ".properties";
            }
            appProp.setProperty("userPrefDir", appProp.getProperty("org.lsst.ccs.gui.home") + "/" + prefName);
        }
        ccsProp.stringPropertyNames().forEach(key -> appProp.setProperty((String)key, ccsProp.getProperty((String)key)));
        return appProp;
    }
}

