/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.Prepared;
import org.h2.command.dml.SetTypes;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.expression.Expression;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.LocalResultFactory;
import org.h2.result.ResultInterface;
import org.h2.result.RowFactory;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.security.auth.AuthenticatorFactory;
import org.h2.table.Table;
import org.h2.tools.CompressTool;
import org.h2.util.JdbcUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.ValueInt;

public class Set
extends Prepared {
    private final int type;
    private Expression expression;
    private String stringValue;
    private String[] stringValueList;

    public Set(Session session, int n) {
        super(session);
        this.type = n;
    }

    public void setString(String string) {
        this.stringValue = string;
    }

    @Override
    public boolean isTransactional() {
        switch (this.type) {
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 20: 
            case 25: 
            case 27: 
            case 33: 
            case 34: 
            case 38: 
            case 44: 
            case 51: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int update() {
        Database database = this.session.getDatabase();
        String string = SetTypes.getTypeName(this.type);
        block51 : switch (this.type) {
            case 24: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n < 0 || n > 2) {
                    throw DbException.getInvalidValueException("ALLOW_LITERALS", n);
                }
                Database database2 = database;
                synchronized (database2) {
                    database.setAllowLiterals(n);
                    this.addOrUpdateSetting(string, null, n);
                    break;
                }
            }
            case 8: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n < 0) {
                    throw DbException.getInvalidValueException("CACHE_SIZE", n);
                }
                Database database3 = database;
                synchronized (database3) {
                    database.setCacheSize(n);
                    this.addOrUpdateSetting(string, null, n);
                    break;
                }
            }
            case 13: {
                Session session;
                String string2;
                if ("TRUE".equals(this.stringValue) || (string2 = StringUtils.quoteStringSQL(this.stringValue)).equals(database.getCluster())) break;
                if (!string2.equals("''")) {
                    this.session.getUser().checkAdmin();
                }
                database.setCluster(string2);
                Session session2 = session = database.getSystemSession();
                synchronized (session2) {
                    Database database4 = database;
                    synchronized (database4) {
                        this.addOrUpdateSetting(session, string, string2, 0);
                        session.commit(true);
                        break;
                    }
                }
            }
            case 12: {
                CompareMode compareMode;
                this.session.getUser().checkAdmin();
                CompareMode compareMode2 = database.getCompareMode();
                boolean bl = compareMode2.isBinaryUnsigned();
                boolean bl2 = compareMode2.isUuidUnsigned();
                StringBuilder stringBuilder = new StringBuilder(this.stringValue);
                if (this.stringValue.equals("OFF")) {
                    compareMode = CompareMode.getInstance(null, 0, bl, bl2);
                } else {
                    int n = this.getIntValue();
                    stringBuilder.append(" STRENGTH ");
                    if (n == 3) {
                        stringBuilder.append("IDENTICAL");
                    } else if (n == 0) {
                        stringBuilder.append("PRIMARY");
                    } else if (n == 1) {
                        stringBuilder.append("SECONDARY");
                    } else if (n == 2) {
                        stringBuilder.append("TERTIARY");
                    }
                    compareMode = CompareMode.getInstance(this.stringValue, n, bl, bl2);
                }
                Database database5 = database;
                synchronized (database5) {
                    CompareMode compareMode3 = database.getCompareMode();
                    if (compareMode3.equals(compareMode)) {
                        break;
                    }
                    Table table = database.getFirstUserTable();
                    if (table != null) {
                        throw DbException.get(90089, table.getSQL(false));
                    }
                    this.addOrUpdateSetting(string, stringBuilder.toString(), 0);
                    database.setCompareMode(compareMode);
                    break;
                }
            }
            case 36: {
                boolean bl;
                this.session.getUser().checkAdmin();
                if (this.stringValue.equals("SIGNED")) {
                    bl = false;
                } else {
                    if (!this.stringValue.equals("UNSIGNED")) {
                        throw DbException.getInvalidValueException("BINARY_COLLATION", this.stringValue);
                    }
                    bl = true;
                }
                Database database6 = database;
                synchronized (database6) {
                    Object object;
                    CompareMode compareMode = database.getCompareMode();
                    if (compareMode.isBinaryUnsigned() != bl && (object = database.getFirstUserTable()) != null) {
                        throw DbException.get(90089, ((SchemaObjectBase)object).getSQL(false));
                    }
                    object = CompareMode.getInstance(compareMode.getName(), compareMode.getStrength(), bl, compareMode.isUuidUnsigned());
                    this.addOrUpdateSetting(string, this.stringValue, 0);
                    database.setCompareMode((CompareMode)object);
                    break;
                }
            }
            case 49: {
                boolean bl;
                this.session.getUser().checkAdmin();
                if (this.stringValue.equals("SIGNED")) {
                    bl = false;
                } else {
                    if (!this.stringValue.equals("UNSIGNED")) {
                        throw DbException.getInvalidValueException("UUID_COLLATION", this.stringValue);
                    }
                    bl = true;
                }
                Database database7 = database;
                synchronized (database7) {
                    Object object;
                    CompareMode compareMode = database.getCompareMode();
                    if (compareMode.isUuidUnsigned() != bl && (object = database.getFirstUserTable()) != null) {
                        throw DbException.get(90089, ((SchemaObjectBase)object).getSQL(false));
                    }
                    object = CompareMode.getInstance(compareMode.getName(), compareMode.getStrength(), compareMode.isBinaryUnsigned(), bl);
                    this.addOrUpdateSetting(string, this.stringValue, 0);
                    database.setCompareMode((CompareMode)object);
                    break;
                }
            }
            case 23: {
                this.session.getUser().checkAdmin();
                int n = CompressTool.getCompressAlgorithm(this.stringValue);
                Database database8 = database;
                synchronized (database8) {
                    database.setLobCompressionAlgorithm(n == 0 ? null : this.stringValue);
                    this.addOrUpdateSetting(string, this.stringValue, 0);
                    break;
                }
            }
            case 32: {
                this.session.getUser().checkAdmin();
                if (!database.isStarting()) break;
                int n = this.getIntValue();
                Database database9 = database;
                synchronized (database9) {
                    this.addOrUpdateSetting(string, null, n);
                    break;
                }
            }
            case 15: {
                this.session.getUser().checkAdmin();
                database.setEventListenerClass(this.stringValue);
                break;
            }
            case 18: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n != -1 && n < 0) {
                    throw DbException.getInvalidValueException("DB_CLOSE_DELAY", n);
                }
                Database database10 = database;
                synchronized (database10) {
                    database.setCloseDelay(n);
                    this.addOrUpdateSetting(string, null, n);
                    break;
                }
            }
            case 6: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n < 0) {
                    throw DbException.getInvalidValueException("DEFAULT_LOCK_TIMEOUT", n);
                }
                Database database11 = database;
                synchronized (database11) {
                    this.addOrUpdateSetting(string, null, n);
                    break;
                }
            }
            case 7: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                Database database12 = database;
                synchronized (database12) {
                    database.setDefaultTableType(n);
                    this.addOrUpdateSetting(string, null, n);
                    break;
                }
            }
            case 31: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                switch (n) {
                    case 0: {
                        if (database.unsetExclusiveSession(this.session)) break block51;
                        throw DbException.get(90135);
                    }
                    case 1: {
                        if (database.setExclusiveSession(this.session, false)) break block51;
                        throw DbException.get(90135);
                    }
                    case 2: {
                        if (database.setExclusiveSession(this.session, true)) break block51;
                        throw DbException.get(90135);
                    }
                    default: {
                        throw DbException.getInvalidValueException("EXCLUSIVE", n);
                    }
                }
            }
            case 37: {
                this.session.getUser().checkAdmin();
                Database database13 = database;
                synchronized (database13) {
                    Table table = database.getFirstUserTable();
                    if (table != null) {
                        throw DbException.get(90141, table.getSQL(false));
                    }
                    database.setJavaObjectSerializerName(this.stringValue);
                    this.addOrUpdateSetting(string, this.stringValue, 0);
                    break;
                }
            }
            case 1: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                Database database14 = database;
                synchronized (database14) {
                    database.setIgnoreCase(n == 1);
                    this.addOrUpdateSetting(string, null, n);
                    break;
                }
            }
            case 17: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                Database database15 = database;
                synchronized (database15) {
                    database.setLockMode(n);
                    this.addOrUpdateSetting(string, null, n);
                    break;
                }
            }
            case 5: {
                int n = this.getIntValue();
                if (n < 0) {
                    throw DbException.getInvalidValueException("LOCK_TIMEOUT", n);
                }
                this.session.setLockTimeout(n);
                break;
            }
            case 19: {
                int n = this.getIntValue();
                if (!database.isPersistent() || n == database.getLogMode()) break;
                this.session.getUser().checkAdmin();
                database.setLogMode(n);
                break;
            }
            case 22: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n < 0) {
                    throw DbException.getInvalidValueException("MAX_LENGTH_INPLACE_LOB", n);
                }
                Database database16 = database;
                synchronized (database16) {
                    database.setMaxLengthInplaceLob(n);
                    this.addOrUpdateSetting(string, null, n);
                    break;
                }
            }
            case 2: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n < 0) {
                    throw DbException.getInvalidValueException("MAX_LOG_SIZE", n);
                }
                Database database17 = database;
                synchronized (database17) {
                    database.setMaxLogSize((long)n * 0x100000L);
                    this.addOrUpdateSetting(string, null, n);
                    break;
                }
            }
            case 16: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n < 0) {
                    throw DbException.getInvalidValueException("MAX_MEMORY_ROWS", n);
                }
                Database database18 = database;
                synchronized (database18) {
                    database.setMaxMemoryRows(n);
                    this.addOrUpdateSetting(string, null, n);
                    break;
                }
            }
            case 21: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n < 0) {
                    throw DbException.getInvalidValueException("MAX_MEMORY_UNDO", n);
                }
                Database database19 = database;
                synchronized (database19) {
                    database.setMaxMemoryUndo(n);
                    this.addOrUpdateSetting(string, null, n);
                    break;
                }
            }
            case 30: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n < 0) {
                    throw DbException.getInvalidValueException("MAX_OPERATION_MEMORY", n);
                }
                database.setMaxOperationMemory(n);
                break;
            }
            case 3: {
                Mode mode = Mode.getInstance(this.stringValue);
                if (mode == null) {
                    throw DbException.get(90088, this.stringValue);
                }
                if (database.getMode() == mode) break;
                this.session.getUser().checkAdmin();
                database.setMode(mode);
                this.session.getColumnNamerConfiguration().configure(mode.getEnum());
                break;
            }
            case 26: {
                this.session.getUser().checkAdmin();
                database.setOptimizeReuseResults(this.getIntValue() != 0);
                break;
            }
            case 34: {
                int n = this.getIntValue();
                if (n < 0) {
                    throw DbException.getInvalidValueException("QUERY_TIMEOUT", n);
                }
                this.session.setQueryTimeout(n);
                break;
            }
            case 35: {
                int n = this.getIntValue();
                this.session.setRedoLogBinary(n == 1);
                break;
            }
            case 29: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n < 0 || n > 1) {
                    throw DbException.getInvalidValueException("REFERENTIAL_INTEGRITY", n);
                }
                database.setReferentialIntegrity(n == 1);
                break;
            }
            case 39: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n < 0 || n > 1) {
                    throw DbException.getInvalidValueException("QUERY_STATISTICS", n);
                }
                database.setQueryStatistics(n == 1);
                break;
            }
            case 40: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n < 1) {
                    throw DbException.getInvalidValueException("QUERY_STATISTICS_MAX_ENTRIES", n);
                }
                database.setQueryStatisticsMaxEntries(n);
                break;
            }
            case 25: {
                Schema schema = database.getSchema(this.expression.optimize(this.session).getValue(this.session).getString());
                this.session.setCurrentSchema(schema);
                break;
            }
            case 27: {
                this.session.setSchemaSearchPath(this.stringValueList);
                break;
            }
            case 51: {
                String string3 = database.getShortName();
                String string4 = this.expression.optimize(this.session).getValue(this.session).getString();
                if (string4 != null && (database.equalsIdentifiers(string3, string4) || database.equalsIdentifiers(string3, string4.trim()))) break;
                throw DbException.get(90013, this.stringValue);
            }
            case 10: {
                this.session.getUser().checkAdmin();
                if (this.getPersistedObjectId() != 0) break;
                database.getTraceSystem().setLevelFile(this.getIntValue());
                break;
            }
            case 9: {
                this.session.getUser().checkAdmin();
                if (this.getPersistedObjectId() != 0) break;
                database.getTraceSystem().setLevelSystemOut(this.getIntValue());
                break;
            }
            case 11: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n < 0) {
                    throw DbException.getInvalidValueException("TRACE_MAX_FILE_SIZE", n);
                }
                int n2 = n * 0x100000;
                Database database20 = database;
                synchronized (database20) {
                    database.getTraceSystem().setMaxFileSize(n2);
                    this.addOrUpdateSetting(string, null, n);
                    break;
                }
            }
            case 20: {
                int n = this.getIntValue();
                if (n < 0) {
                    throw DbException.getInvalidValueException("THROTTLE", n);
                }
                this.session.setThrottle(n);
                break;
            }
            case 28: {
                int n = this.getIntValue();
                if (n < 0 || n > 1) {
                    throw DbException.getInvalidValueException("UNDO_LOG", n);
                }
                this.session.setUndoLogEnabled(n == 1);
                break;
            }
            case 33: {
                Expression expression = this.expression.optimize(this.session);
                this.session.setVariable(this.stringValue, expression.getValue(this.session));
                break;
            }
            case 14: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n < 0) {
                    throw DbException.getInvalidValueException("WRITE_DELAY", n);
                }
                Database database21 = database;
                synchronized (database21) {
                    database.setWriteDelay(n);
                    this.addOrUpdateSetting(string, null, n);
                    break;
                }
            }
            case 38: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n < 0) {
                    throw DbException.getInvalidValueException("RETENTION_TIME", n);
                }
                Database database22 = database;
                synchronized (database22) {
                    database.setRetentionTime(n);
                    this.addOrUpdateSetting(string, null, n);
                    break;
                }
            }
            case 41: {
                RowFactory rowFactory;
                this.session.getUser().checkAdmin();
                String string5 = this.expression.getColumnName();
                Class clazz = JdbcUtils.loadUserClass(string5);
                try {
                    rowFactory = (RowFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    throw DbException.convert(exception);
                }
                database.setRowFactory(rowFactory);
                break;
            }
            case 42: {
                int n = this.getIntValue();
                if (n != 0 && n != 1) {
                    throw DbException.getInvalidValueException("BATCH_JOINS", n);
                }
                this.session.setJoinBatchEnabled(n == 1);
                break;
            }
            case 43: {
                int n = this.getIntValue();
                if (n != 0 && n != 1) {
                    throw DbException.getInvalidValueException("FORCE_JOIN_ORDER", n);
                }
                this.session.setForceJoinOrder(n == 1);
                break;
            }
            case 44: {
                int n = this.getIntValue();
                if (n != 0 && n != 1) {
                    throw DbException.getInvalidValueException("LAZY_QUERY_EXECUTION", n);
                }
                this.session.setLazyQueryExecution(n == 1);
                break;
            }
            case 45: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                if (n != 0 && n != 1) {
                    throw DbException.getInvalidValueException("BUILTIN_ALIAS_OVERRIDE", n);
                }
                database.setAllowBuiltinAliasOverride(n == 1);
                break;
            }
            case 46: {
                this.session.getUser().checkAdmin();
                this.session.getColumnNamerConfiguration().configure(this.expression.getColumnName());
                break;
            }
            case 47: {
                this.session.getUser().checkAdmin();
                boolean bl = this.expression.optimize(this.session).getBooleanValue(this.session);
                try {
                    Database database23 = database;
                    synchronized (database23) {
                        if (bl) {
                            database.setAuthenticator(AuthenticatorFactory.createAuthenticator());
                        } else {
                            database.setAuthenticator(null);
                        }
                        this.addOrUpdateSetting(string, bl ? "TRUE" : "FALSE", 0);
                    }
                }
                catch (Exception exception) {
                    if (!database.isStarting()) {
                        throw DbException.convert(exception);
                    }
                    database.getTrace(2).error(exception, "{0}: failed to set authenticator during database start ", this.expression.toString());
                }
                break;
            }
            case 48: {
                this.session.getUser().checkAdmin();
                String string6 = this.expression.getColumnName();
                Class clazz = JdbcUtils.loadUserClass(string6);
                try {
                    LocalResultFactory localResultFactory = (LocalResultFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    database.setResultFactory(localResultFactory);
                    break;
                }
                catch (Exception exception) {
                    throw DbException.convert(exception);
                }
            }
            case 50: {
                this.session.getUser().checkAdmin();
                int n = this.getIntValue();
                Database database24 = database;
                synchronized (database24) {
                    database.setIgnoreCatalogs(n == 1);
                    this.addOrUpdateSetting(string, null, n);
                    break;
                }
            }
            default: {
                DbException.throwInternalError("type=" + this.type);
            }
        }
        database.getNextModificationDataId();
        database.getNextModificationMetaId();
        return 0;
    }

    private int getIntValue() {
        this.expression = this.expression.optimize(this.session);
        return this.expression.getValue(this.session).getInt();
    }

    public void setInt(int n) {
        this.expression = ValueExpression.get(ValueInt.get(n));
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    private void addOrUpdateSetting(String string, String string2, int n) {
        this.addOrUpdateSetting(this.session, string, string2, n);
    }

    private void addOrUpdateSetting(Session session, String string, String string2, int n) {
        Database database = session.getDatabase();
        assert (Thread.holdsLock(database));
        if (database.isReadOnly()) {
            return;
        }
        Setting setting = database.findSetting(string);
        boolean bl = false;
        if (setting == null) {
            bl = true;
            int n2 = this.getObjectId();
            setting = new Setting(database, n2, string);
        }
        if (string2 != null) {
            if (!bl && setting.getStringValue().equals(string2)) {
                return;
            }
            setting.setStringValue(string2);
        } else {
            if (!bl && setting.getIntValue() == n) {
                return;
            }
            setting.setIntValue(n);
        }
        if (bl) {
            database.addDatabaseObject(session, setting);
        } else {
            database.updateMeta(session, setting);
        }
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    public void setStringArray(String[] stringArray) {
        this.stringValueList = stringArray;
    }

    @Override
    public int getType() {
        return 67;
    }
}

