/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.Application;
import jas.util.BooleanCommandTarget;
import jas.util.CommandSource;
import jas.util.CommandTarget;
import jas.util.JASCheckboxState;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBoxMenuItem;

public class JASCheckboxMenuItem
extends JCheckBoxMenuItem
implements Observer,
ActionListener,
JASCheckboxState,
CommandSource {
    private boolean correspondingToolBarFloating = false;
    private BooleanCommandTarget m_target = null;

    public JASCheckboxMenuItem() {
        this.setEnabled(false);
        Application.getApplication().getCommandManager().add(this);
        this.addActionListener(this);
    }

    public JASCheckboxMenuItem(String s, char mnemonic) {
        super(s);
        this.setMnemonic(mnemonic);
        this.setEnabled(false);
        Application.getApplication().getCommandManager().add(this);
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.m_target.invoke(this.getState());
    }

    @Override
    public void setCheckbox(boolean state) {
        this.setState(state);
    }

    @Override
    public boolean setTarget(CommandTarget t) {
        if (t instanceof BooleanCommandTarget) {
            this.m_target = (BooleanCommandTarget)t;
            this.m_target.enable(this);
            return true;
        }
        return false;
    }

    @Override
    public void clearTarget() {
        this.m_target = null;
        this.setEnabled(false);
    }

    @Override
    public CommandTarget getTarget() {
        return this.m_target;
    }

    @Override
    public String getCommand() {
        return this.getText();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.m_target.enable(this);
    }

    @Override
    public void setEnabled(boolean state) {
        if (this.correspondingToolBarFloating) {
            super.setEnabled(false);
        } else {
            super.setEnabled(state);
        }
    }

    public void setCorrespondingToolBarFloating(boolean state) {
        this.correspondingToolBarFloating = state;
    }
}

