/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui.jas;

import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.lsst.ccs.gconsole.agent.command.CommandHandle;
import org.lsst.ccs.gconsole.agent.command.CommandTask;
import org.lsst.ccs.gconsole.services.command.CommandService;
import org.lsst.ccs.gconsole.services.command.DefaultCommandHandle;

public class CommandSender {
    private final String dest;
    private final CommandService service = CommandService.getService();
    private final CommandHandler cmndHandler = new CommandHandler();
    private final Set<ReplyHandler> handlers = Collections.synchronizedSet(new HashSet());
    private int defTimeout = 5000;

    public CommandSender(String dest) {
        this(dest, null);
    }

    public CommandSender(String dest, ReplyHandler handler) {
        this.dest = dest;
        this.handlers.add(handler);
    }

    public void sendCommand(String path, String cmnd, Object ... args) {
        this.sendCommand(false, this.defTimeout, path, cmnd, args);
    }

    public void sendCommand(int timeout, String path, String cmnd, Object ... args) {
        this.sendCommand(false, timeout, path, cmnd, args);
    }

    public void sendCommand(boolean reply, String path, String cmnd, Object ... args) {
        this.sendCommand(reply, this.defTimeout, path, cmnd, args);
    }

    public void sendCommand(boolean reply, int timeout, String path, String cmnd, Object ... args) {
        String cmd = this.dest + (path == null ? "" : "/" + path) + "/" + cmnd;
        this.service.execute((CommandHandle)(reply ? this.cmndHandler : null), Duration.ofMillis(timeout), cmd, args);
    }

    public void setTimeout(int timeout) {
        this.defTimeout = timeout;
    }

    public void addHandler(ReplyHandler handler) {
        this.handlers.add(handler);
    }

    public void removeHandler(ReplyHandler handler) {
        this.handlers.remove(handler);
    }

    public class CommandHandler
    extends DefaultCommandHandle {
        public void onSuccess(Object reply, CommandTask task) {
            int last;
            String command = task.getCommand();
            int first = command.indexOf(47);
            String path = first == (last = command.lastIndexOf(47)) ? null : command.substring(first + 1, last);
            String cmnd = command.substring(last + 1);
            for (ReplyHandler handler : CommandSender.this.handlers) {
                handler.onCommandReply(reply, path, cmnd, task.getArguments());
            }
        }
    }

    public static interface ReplyHandler {
        public void onCommandReply(Object var1, String var2, String var3, Object[] var4);
    }
}

