/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.localdb.configdb.model.BaseDescription;
import org.lsst.ccs.localdb.configdb.model.Configuration;
import org.lsst.ccs.localdb.configdb.model.ConfigurationInfoData;
import org.lsst.ccs.localdb.configdb.model.ConfigurationParameter;
import org.lsst.ccs.localdb.configdb.model.ConfigurationParameterValue;
import org.lsst.ccs.localdb.configdb.model.ConfigurationRun;
import org.lsst.ccs.localdb.configdb.model.Description;
import org.lsst.ccs.localdb.configdb.model.GlobalConfiguration;
import org.lsst.ccs.localdb.configdb.model.PackCst;
import org.lsst.ccs.localdb.configdb.model.ParameterPath;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;
import org.lsst.ccs.utilities.logging.Logger;

public class HibernateDAO {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb.configdb");
    private final SessionFactory sessionFactory;
    private final ThreadLocal<SessionContext> context;

    public HibernateDAO(SessionFactory fac) {
        this.sessionFactory = fac;
        this.context = new ThreadLocal<SessionContext>(){

            @Override
            public SessionContext initialValue() {
                return new SessionContext(HibernateDAO.this.sessionFactory);
            }
        };
    }

    public void begin() {
        log.debug((Object)"begin transaction");
        this.context.get().beginTransaction();
    }

    public void end() throws Exception {
        log.debug((Object)"end transaction");
        this.context.get().transaction.commit();
        this.closeSession();
    }

    public void rollback() throws Exception {
        Transaction currTx = this.context.get().transaction;
        try {
            if (currTx != null && (currTx.getStatus() == TransactionStatus.ACTIVE || currTx.getStatus() == TransactionStatus.MARKED_ROLLBACK)) {
                currTx.rollback();
            }
        }
        catch (Exception rbEx) {
            log.error((Object)("Rollback of transaction failed : " + rbEx), (Throwable)rbEx);
            throw rbEx;
        }
    }

    public void closeSession() {
        if (this.getSession().isOpen()) {
            this.getSession().close();
        }
        this.context.remove();
    }

    public void persist(Object obj) {
        this.getSession().persist(obj);
    }

    private Session getSession() {
        return this.context.get().session;
    }

    public Configuration getConfigurationOrNull(BaseDescription desc, String name, String cat, int version) {
        Configuration res = null;
        Conjunction baseCriterion = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"baseDescription", (Object)desc), Restrictions.eq((String)"configName", (Object)name), Restrictions.eq((String)"category", (Object)cat)});
        switch (version) {
            case -1: {
                res = (Configuration)this.getSession().createCriteria(Configuration.class).add((Criterion)baseCriterion).add((Criterion)Restrictions.eq((String)"defaultVersion", (Object)true)).uniqueResult();
                if (res != null) break;
                log.fine((Object)("no default version for configuration " + desc.getAgentDesc() + ":" + cat + ":" + name + ". Getting the latest."));
            }
            case -2: {
                res = this.getLatestConfiguration(desc, cat, name);
                break;
            }
            default: {
                res = (Configuration)this.getSession().createQuery("from Configuration where baseDescription=:desc and configName=:configName and category=:cat and version=:ver").setEntity("desc", (Object)desc).setString("configName", name).setString("cat", cat).setInteger("ver", version).setCacheable(true).uniqueResult();
            }
        }
        if (res != null) {
            log.fine((Object)("found versioned configuration " + res.getConfigurationDescriptionString()));
        }
        return res;
    }

    private Configuration getConfigurationOrNull(BaseDescription desc, String name, String cat, byte[] md5) {
        Configuration res = (Configuration)this.getSession().createQuery("from Configuration where baseDescription=:description and configName =:tag and category=:cat and hashMD5 =:hashMD5").setEntity("description", (Object)desc).setString("tag", name).setString("cat", cat).setBinary("hashMD5", md5).setCacheable(true).uniqueResult();
        if (res != null) {
            log.fine((Object)("found matching configuration " + res.getConfigurationDescriptionString()));
        }
        return res;
    }

    public Configuration getConfigurationOrCreate(BaseDescription desc, String name, String cat, int version, List<ConfigurationParameterInfo> cpis, long date, ConfigurationRun previousRun) {
        Configuration res;
        block11: {
            String request = desc.getId() + ": \"" + cat + "\":\"" + name + "\"(" + version + ")";
            log.debug((Object)("looking for configuration " + request));
            res = null;
            if (version != -3 && (res = this.getConfigurationOrNull(desc, name, cat, version)) == null) {
                log.warn((Object)("a versioned configuration was not found : " + request + ". creating a new one"));
            }
            byte[] cs = null;
            if (res == null) {
                TreeMap<String, String> currentValues = new TreeMap<String, String>();
                for (ConfigurationParameterInfo cpi : cpis) {
                    if (cpi.isFinal()) continue;
                    currentValues.put(new ParameterPath(cpi.getComponentName(), cpi.getParameterName()).toString(), cpi.getConfiguredValue());
                }
                try {
                    cs = Configuration.computeHashMD5(desc, currentValues);
                }
                catch (Exception ex) {
                    log.error((Object)"cannot compute configuration checksum", (Throwable)ex);
                }
                if (cs != null) {
                    res = this.getConfigurationOrNull(desc, name, cat, cs);
                }
            }
            if (res != null) break block11;
            res = this.createNextConfiguration(desc, name, cat, date, cs);
            if (previousRun == null) {
                for (ConfigurationParameterInfo cpi : cpis) {
                    if (cpi.isFinal()) continue;
                    res.addConfigurationParameterValue(this.createConfigurationParameterValue(desc, cpi.getPathName(), cpi.getConfiguredValue(), date));
                }
            } else {
                for (ConfigurationParameterInfo cpi : cpis) {
                    if (cpi.isFinal()) continue;
                    ParameterPath path = ParameterPath.valueOf(cpi.getPathName());
                    ConfigurationParameter cp = desc.getConfigurationParameters().get(path);
                    ConfigurationParameterValue previousValue = previousRun.getConfigurationParameterValueForRun(path);
                    if (cpi.getCurrentValue().equals(previousValue.getValue())) {
                        res.addConfigurationParameterValue(previousValue);
                        continue;
                    }
                    log.warn((Object)("parameter : " + cp.getParameterPath() + " had the following value in the previous run : " + previousValue.getValue() + " but is now : " + cpi.getCurrentValue()));
                    res.addConfigurationParameterValue(this.createConfigurationParameterValue(desc, cpi.getPathName(), cpi.getConfiguredValue(), date));
                }
            }
        }
        return res;
    }

    public ConfigurationRun populateRunFromScratch(ConfigurationRun run, List<ConfigurationParameterInfo> changes) {
        for (ConfigurationParameterInfo cpi : changes) {
            ConfigurationParameterValue dirtyVal = this.createConfigurationParameterValue(run.getConfiguration().getBaseDescription(), cpi.getPathName(), cpi.getCurrentValue(), run.getTstart());
            run.addRuntimeChange(dirtyVal);
        }
        return this.persistNextConfigurationRun(run, null);
    }

    public ConfigurationRun populateRunFromPreviousRun(ConfigurationRun previousRun, ConfigurationRun newRun, List<ConfigurationParameterInfo> changes) {
        Configuration prevConfig = previousRun.getConfiguration();
        Configuration newConfig = newRun.getConfiguration();
        if (changes.isEmpty()) {
            GlobalConfiguration newGC = newRun.getGlobalConfiguration();
            GlobalConfiguration prevGC = previousRun.getGlobalConfiguration();
            if ((newGC != null && prevGC != null && newGC.getId() == previousRun.getId() || newGC == null && prevGC == null) && !previousRun.isDirty() && prevConfig.getConfigName().equals(newConfig.getConfigName()) && prevConfig.getVersion() == newConfig.getVersion()) {
                return previousRun;
            }
            return this.persistNextConfigurationRun(newRun, previousRun);
        }
        if (!prevConfig.getConfigName().equals(newConfig.getConfigName())) {
            log.warning((Object)"inconsistency detected");
            previousRun.setTstop(newRun.getTstart());
            return this.populateRunFromScratch(newRun, changes);
        }
        ArrayList<ConfigurationParameterValue> delta = new ArrayList<ConfigurationParameterValue>();
        for (ConfigurationParameterInfo cpi : changes) {
            ParameterPath path = ParameterPath.valueOf(cpi.getPathName());
            String currentValue = cpi.getCurrentValue();
            ConfigurationParameterValue previousChange = previousRun.getRuntimeChanges().get(path);
            if (previousChange != null && previousChange.getValue().equals(currentValue)) continue;
            ConfigurationParameterValue cpv = this.createConfigurationParameterValue(newRun.getConfiguration().getBaseDescription(), cpi.getPathName(), currentValue, newRun.getTstart());
            delta.add(cpv);
        }
        if (delta.isEmpty()) {
            return previousRun;
        }
        for (ConfigurationParameterValue cpv : delta) {
            newRun.addRuntimeChange(cpv);
        }
        return this.persistNextConfigurationRun(newRun, previousRun);
    }

    private Configuration createNextConfiguration(BaseDescription desc, String name, String cat, long date, byte[] cs) {
        Configuration latestConfiguration = this.getLatestConfiguration(desc, cat, name);
        int latestVersion = -1;
        if (latestConfiguration != null) {
            latestVersion = latestConfiguration.getVersion();
            latestConfiguration.setLatestVersion(false);
        }
        int nextVersion = latestVersion + 1;
        Configuration res = new Configuration(desc, cat, name, date, nextVersion);
        log.fine((Object)("created new configuration : " + res));
        res.setHashMD5(cs);
        this.getSession().persist((Object)res);
        return res;
    }

    private ConfigurationRun persistNextConfigurationRun(ConfigurationRun nextRun, ConfigurationRun previousRun) {
        if (previousRun != null) {
            previousRun.setTstop(nextRun.getTstart());
        }
        this.getSession().persist((Object)nextRun);
        return nextRun;
    }

    private Configuration getLatestConfiguration(BaseDescription desc, String cat, String name) {
        Configuration latestConfiguration = (Configuration)this.getSession().createQuery("from Configuration c where c.baseDescription=:desc and c.configName=:name and c.category=:cat and c.version=(select max(co.version) from Configuration co where co.baseDescription=:desc and co.configName=:name and co.category=:cat)").setEntity("desc", (Object)desc).setString("name", name).setString("cat", cat).uniqueResult();
        if (latestConfiguration == null) {
            log.debug((Object)("no configuration for \"" + cat + "\":\"" + name + "\" for description " + desc.getId()));
        }
        return latestConfiguration;
    }

    private ConfigurationParameterValue createConfigurationParameterValue(BaseDescription desc, String path, String value, long time) {
        return new ConfigurationParameterValue(desc.fetch(path), value, time);
    }

    public void cleanupConfigurationRuns(Description desc, long time) {
        Map<String, ConfigurationRun> activeRuns = this.getActiveConfigurationRuns(desc);
        for (ConfigurationRun cr : activeRuns.values()) {
            log.info((Object)("suspicious run found for " + desc.getAgentDesc().getAgentName() + ", starting at " + cr.getTstart() + " with no end date."));
            cr.setTstop(time);
            this.getSession().persist((Object)cr);
        }
    }

    public Configuration getLatestRunningConfiguration(Description desc, String category) {
        return this.getConfigRunningAt(desc, category, PackCst.STILL_VALID);
    }

    public Configuration getConfigRunningAt(Description desc, String category, long date) {
        ConfigurationRun run = this.getConfigurationRunAt(desc, category, date);
        if (run == null) {
            return null;
        }
        return run.getConfiguration();
    }

    public String getActiveValueAt(Description desc, String category, String parameterPath, long date) {
        ConfigurationRun run = this.getConfigurationRunAt(desc, category, date);
        if (run == null) {
            return null;
        }
        return run.getConfigurationParameterValueForRun(ParameterPath.valueOf(parameterPath)).getValue();
    }

    public void endRun(Description description, long endTime) {
        Map<String, ConfigurationRun> currentRuns = this.getActiveConfigurationRuns(description);
        for (ConfigurationRun cr : currentRuns.values()) {
            cr.setTstop(endTime);
            this.getSession().update((Object)cr);
        }
    }

    public ConfigurationParameter createConfigurationParameter(String agentName, String componentName, String parameterName, String description, String typeName, String categoryName, String finalValue) {
        log.fine((Object)("creating a new configuration parameter entity for " + agentName + " : " + componentName + "/" + parameterName + " cat : " + categoryName));
        ConfigurationParameter cp = new ConfigurationParameter(agentName, new ParameterPath(componentName, parameterName), typeName, description, categoryName, finalValue);
        this.getSession().setFlushMode(FlushMode.COMMIT);
        return cp;
    }

    public Map<ParameterPath, List<ConfigurationParameter>> getAllConfigurationParameters(String agentName) {
        List l = this.getSession().createQuery("from ConfigurationParameter where agentName=:agentName").setCacheMode(CacheMode.IGNORE).setFlushMode(FlushMode.COMMIT).setString("agentName", agentName).list();
        HashMap<ParameterPath, List<ConfigurationParameter>> res = new HashMap<ParameterPath, List<ConfigurationParameter>>();
        for (ConfigurationParameter cp : l) {
            ArrayList<ConfigurationParameter> list = (ArrayList<ConfigurationParameter>)res.get(cp.getParameterPath());
            if (list == null) {
                list = new ArrayList<ConfigurationParameter>();
                res.put(cp.getParameterPath(), list);
            }
            list.add(cp);
        }
        return res;
    }

    public Description getDescription(AgentDesc ad, List<ConfigurationParameter> parameters) {
        Description res = null;
        byte[] md5 = BaseDescription.computeHashMD5(ad, parameters);
        BaseDescription desc = this.getBaseDescription(md5);
        if (desc == null) {
            desc = this.createBaseDescription(ad, parameters, md5);
            res = this.createDescription(desc, parameters);
        } else {
            res = this.getDescription(desc, parameters);
        }
        if (res == null) {
            res = this.createDescription(desc, parameters);
        }
        return res;
    }

    private BaseDescription getBaseDescription(byte[] md5) {
        BaseDescription res = (BaseDescription)this.getSession().createQuery("from BaseDescription where hashMD5=:md5").setBinary("md5", md5).uniqueResult();
        if (res != null) {
            log.fine((Object)("found matching base description for " + res.getAgentDesc().getAgentName() + " : " + res.getId()));
        }
        return res;
    }

    private BaseDescription createBaseDescription(AgentDesc ad, List<ConfigurationParameter> parameters, byte[] md5) {
        this.getSession().update((Object)ad);
        BaseDescription desc = new BaseDescription(ad);
        log.fine((Object)("creating a new base description for " + ad.getAgentName()));
        desc = new BaseDescription(ad);
        HashMap<ParameterPath, ConfigurationParameter> nonFinalParameters = new HashMap<ParameterPath, ConfigurationParameter>();
        for (ConfigurationParameter cp : parameters) {
            if (cp.isFinal()) continue;
            nonFinalParameters.put(cp.getParameterPath(), cp);
        }
        desc.setConfigurationParameters(nonFinalParameters);
        desc.setHashMD5(md5);
        this.getSession().persist((Object)desc);
        return desc;
    }

    public Description getDescription(long id) {
        return (Description)this.getSession().get(Description.class, (Serializable)Long.valueOf(id));
    }

    private Description getDescription(BaseDescription desc, List<ConfigurationParameter> parameters) {
        Description res = null;
        HashMap<ParameterPath, ConfigurationParameter> finalValues = new HashMap<ParameterPath, ConfigurationParameter>();
        for (ConfigurationParameter cp : parameters) {
            if (!cp.isFinal()) continue;
            finalValues.put(cp.getParameterPath(), cp);
        }
        for (Description cd : desc.getCompatibleDescriptions()) {
            if (!finalValues.equals(cd.getFinalValues())) continue;
            res = cd;
            break;
        }
        return res;
    }

    private Description createDescription(BaseDescription desc, List<ConfigurationParameter> parameters) {
        Description res = new Description(desc);
        HashMap<ParameterPath, ConfigurationParameter> finalValues = new HashMap<ParameterPath, ConfigurationParameter>();
        for (ConfigurationParameter cp : parameters) {
            if (!cp.isFinal()) continue;
            finalValues.put(cp.getParameterPath(), cp);
        }
        res.setFinalValues(finalValues);
        this.getSession().persist((Object)res);
        return res;
    }

    public ConfigurationRun getActiveConfigurationRun(Description desc, String category) {
        ConfigurationRun cr = (ConfigurationRun)this.getSession().createQuery("from ConfigurationRun where description=:desc and configuration.category=:cat and tstop=:tstop").setEntity("desc", (Object)desc).setLong("tstop", PackCst.STILL_VALID).setString("cat", category).uniqueResult();
        return cr;
    }

    public ConfigurationInfoData getConfigurationInfoData(Description desc, long date) {
        ConfigurationInfoData res = (ConfigurationInfoData)this.getSession().createQuery("from ConfigurationInfoData cid where cid.description=:desc and cid.time <=:date order by cid.time desc").setEntity("desc", (Object)desc).setLong("date", date).setMaxResults(1).uniqueResult();
        if (res == null) {
            log.info((Object)("no ConfigurationInfoData found for date " + date));
        }
        return res;
    }

    public ConfigurationRun getConfigurationRunAt(Description desc, String category, long date) {
        ConfigurationInfoData cid = this.getConfigurationInfoData(desc, date);
        ConfigurationRun run = null;
        if (cid != null && (run = cid.getConfigurationRuns().get(category)).getTstop() <= date) {
            log.warn((Object)("for date : " + date + ", CID was found but its run ends at " + run.getTstop()));
            run = null;
        }
        if (run == null) {
            log.warning((Object)("no configuration run at " + date + " for subsystem " + desc.getAgentDesc().getAgentName() + " and category " + category));
        }
        return run;
    }

    public Map<String, ConfigurationRun> getActiveConfigurationRuns(Description desc) {
        List list = this.getSession().createQuery("from ConfigurationRun where description=:description and tstop=:tstop").setEntity("description", (Object)desc).setLong("tstop", PackCst.STILL_VALID).list();
        return list.stream().collect(Collectors.toMap(cr -> cr.getConfiguration().getCategory(), cr -> cr));
    }

    public List<String> findAvailableConfigurationsForCategory(BaseDescription desc, String category) {
        return this.getSession().createQuery("select configName from Configuration where description=:desc and category=:cat").setEntity("desc", (Object)desc).setString("cat", category).list();
    }

    public GlobalConfiguration findGlobalConfiguration(BaseDescription desc, String name, int version) {
        if (version < 0) {
            return (GlobalConfiguration)this.getSession().createQuery("from GlobalConfiguration where description=:desc and name=:name and latest=true").setEntity("desc", (Object)desc).setString("name", name).uniqueResult();
        }
        return (GlobalConfiguration)this.getSession().createQuery("from GlobalConfiguration where description=:desc and name=:name and version=:version").setEntity("desc", (Object)desc).setString("name", name).setInteger("version", version).uniqueResult();
    }

    public GlobalConfiguration findGlobalConfigurationOrCreate(BaseDescription desc, String name, Map<String, Configuration> newConfigs) {
        List list = this.getSession().createQuery("from GlobalConfiguration where description=:desc and name=:name").setEntity("desc", (Object)desc).setString("name", name).list();
        int nver = 0;
        GlobalConfiguration latestGC = null;
        if (!list.isEmpty()) {
            nver = list.size();
            for (GlobalConfiguration gc : list) {
                if (gc.isLatest()) {
                    latestGC = gc;
                }
                boolean equal = true;
                for (Configuration c : gc.getConfigurations().values()) {
                    if (newConfigs.get(c.getCategory()).getId() == c.getId()) continue;
                    equal = false;
                    break;
                }
                if (!equal) continue;
                return gc;
            }
        }
        if (latestGC != null) {
            latestGC.setLatest(false);
        }
        GlobalConfiguration gc = new GlobalConfiguration(desc, name, nver);
        gc.setConfigurations(newConfigs);
        gc.setLatest(true);
        this.getSession().persist((Object)gc);
        return gc;
    }

    private static class SessionContext {
        private final Session session;
        private Transaction transaction;

        private SessionContext(SessionFactory s) {
            this.session = s.openSession();
            this.session.setFlushMode(FlushMode.COMMIT);
        }

        private void beginTransaction() {
            this.transaction = this.session.beginTransaction();
        }
    }
}

