/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.lsst.ccs.gconsole.annotations.ConsoleLookup;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView1;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView2;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorTable;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTable;
import org.lsst.ccs.subsystem.monitor.ui.tree.MonitorDisplay;

@ConsoleLookup(id="org.lsst.ccs.gconsole.plugins.monitor.MonitorView", name="Sectioned Table View", path="Built-In/Sectioned Table", description="Monitoring view that displays data channels in a table. The table is divided into collapsible sections corresponding to pages defined by the filter associated with this view.")
public class SectionedTableView
extends AbstractMonitorView2 {
    private final JScrollPane scrollPane = new JScrollPane();
    private SectionedTable table;

    public SectionedTableView() {
        this.descriptor = new Descriptor();
        this.scrollPane.add(new MonitorDisplay.EMPTY());
    }

    @Override
    public JComponent getPanel() {
        return this.scrollPane;
    }

    @Override
    protected void resetChannels() {
        ArrayList<MonitorField> fields;
        List<String> attributes = this.getFilter() == null ? null : this.getFilter().getFields(false);
        ArrayList<MonitorField> arrayList = fields = attributes == null ? MonitorTable.DEFAULT_FIELDS : new ArrayList<MonitorField>(MonitorField.getDefaultFields(attributes));
        if (this.table != null) {
            this.save();
            this.table.destroy();
        }
        this.table = SectionedTable.getInstance(this.path2data.entrySet(), fields, this.getDescriptor().getTable());
        if (this.formatter != null) {
            this.table.setFormat(this.formatter);
        }
        this.scrollPane.setViewportView(this.table.getTable());
        this.scrollPane.revalidate();
    }

    @Override
    public Descriptor save() {
        if (this.table != null) {
            this.getDescriptor().setTable(this.table.save());
        }
        return this.getDescriptor();
    }

    @Override
    public void restore(MonitorView.Descriptor descriptor) {
        if (descriptor instanceof Descriptor) {
            this.descriptor = (Descriptor)descriptor;
        }
    }

    @Override
    protected Descriptor getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    public static class Descriptor
    extends AbstractMonitorView1.Descriptor {
        private SectionedTable.Descriptor table;

        public SectionedTable.Descriptor getTable() {
            return this.table;
        }

        public void setTable(SectionedTable.Descriptor table) {
            this.table = table;
        }
    }
}

