/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.agent.command;

import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.gconsole.agent.command.CommandHandle;
import org.lsst.ccs.gconsole.agent.command.CommandSender;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.CommandRejectedException;

public class CommandTask {
    private final CommandSender sender;
    private final CommandHandle commandHandle;
    private long timeout;
    private final String command;
    private final Object[] args;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private ScheduledFuture<?> timeoutTask;
    private boolean done;
    private boolean canceled;
    private Object result;

    public CommandTask(CommandSender sender, CommandHandle handle, Duration timeout, String command, Object ... args) {
        this.sender = sender;
        this.commandHandle = handle;
        this.timeout = timeout.toMillis();
        this.command = command;
        this.args = args;
    }

    public void send() {
        this.sender.workerExecutor.execute(() -> {
            this.lock.lock();
            try {
                if (this.done) {
                    return;
                }
            }
            finally {
                this.lock.unlock();
            }
            try {
                int i = this.command.lastIndexOf("/");
                if (i == -1) {
                    throw new IllegalArgumentException("Illegal command: " + this.command + ". Use \"agent[/component]/method\" format.");
                }
                String destination = this.command.substring(0, i);
                String com = this.command.substring(i + 1);
                CommandRequest request = new CommandRequest(destination, com, this.args);
                this.sender.messenger.sendCommandRequest(request, (CommandOriginator)new Originator());
                this.lock.lock();
                try {
                    if (!this.done && this.timeout != 0L) {
                        this.timeoutTask = this.sender.timer.schedule(this::timeOut, Math.abs(this.timeout), TimeUnit.MILLISECONDS);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (Throwable x) {
                this.lock.lock();
                try {
                    this.done = true;
                    this.result = new IllegalStateException(x);
                    if (this.commandHandle != null) {
                        this.sender.callbackExecutor.execute(() -> this.commandHandle.onSendingFailure(x, this));
                    }
                    this.condition.signalAll();
                }
                finally {
                    this.lock.unlock();
                }
            }
        });
    }

    public Object get() throws IllegalStateException, InterruptedException, CommandRejectedException, CancellationException, TimeoutException, ExecutionException {
        this.getResult();
        if (this.result instanceof Throwable) {
            if (this.result instanceof IllegalStateException) {
                throw (IllegalStateException)this.result;
            }
            if (this.result instanceof InterruptedException) {
                throw (InterruptedException)this.result;
            }
            if (this.result instanceof CommandRejectedException) {
                throw (CommandRejectedException)this.result;
            }
            if (this.result instanceof CancellationException) {
                throw (CancellationException)this.result;
            }
            if (this.result instanceof TimeoutException) {
                throw (TimeoutException)this.result;
            }
            if (this.result instanceof ExecutionException) {
                throw (ExecutionException)this.result;
            }
            throw new ExecutionException((Throwable)this.result);
        }
        return this.result;
    }

    public Object getResult() throws InterruptedException {
        this.lock.lock();
        try {
            while (!this.done) {
                this.condition.await();
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.result;
    }

    public boolean cancel() {
        this.lock.lock();
        try {
            if (this.done) {
                boolean bl = false;
                return bl;
            }
            this.canceled = true;
            this.done = true;
            if (this.timeoutTask != null) {
                this.timeoutTask.cancel(false);
            }
            this.result = new CancellationException();
            if (this.commandHandle != null) {
                this.sender.callbackExecutor.execute(() -> this.commandHandle.onCancel((CancellationException)this.result, this));
            }
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    public boolean isCancelled() {
        this.lock.lock();
        try {
            boolean bl = this.canceled;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isDone() {
        this.lock.lock();
        try {
            boolean bl = this.done;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getCommand() {
        return this.command;
    }

    public Object[] getArguments() {
        return this.args;
    }

    private void timeOut() {
        this.lock.lock();
        try {
            if (this.done) {
                return;
            }
            this.done = true;
            this.timeoutTask = null;
            this.result = new TimeoutException("Timed out after " + Math.abs(this.timeout) / 1000L + " seconds.");
            if (this.commandHandle != null) {
                this.sender.callbackExecutor.execute(() -> this.commandHandle.onTimeout((TimeoutException)this.result, this));
            }
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private class Originator
    implements CommandOriginator {
        private Originator() {
        }

        public void processNack(CommandNack nack) {
            CommandTask.this.lock.lock();
            try {
                if (CommandTask.this.done) {
                    return;
                }
                CommandTask.this.done = true;
                if (CommandTask.this.timeoutTask != null) {
                    CommandTask.this.timeoutTask.cancel(false);
                }
                CommandTask.this.result = new CommandRejectedException(nack);
                if (CommandTask.this.commandHandle != null) {
                    ((CommandTask)CommandTask.this).sender.callbackExecutor.execute(() -> CommandTask.this.commandHandle.onNack(nack, CommandTask.this));
                }
                CommandTask.this.condition.signalAll();
            }
            finally {
                CommandTask.this.lock.unlock();
            }
        }

        public void processAck(CommandAck ack) {
            CommandTask.this.lock.lock();
            try {
                Duration customTimeout;
                if (CommandTask.this.done) {
                    return;
                }
                if (ack != null && CommandTask.this.timeout > 0L && (customTimeout = ack.getTimeout()) != null && !customTimeout.isZero() && !customTimeout.isNegative()) {
                    if (CommandTask.this.timeoutTask != null) {
                        CommandTask.this.timeoutTask.cancel(false);
                    }
                    CommandTask.this.timeout = customTimeout.toMillis();
                    CommandTask.this.timeoutTask = ((CommandTask)CommandTask.this).sender.timer.schedule(() -> CommandTask.this.timeOut(), CommandTask.this.timeout, TimeUnit.MILLISECONDS);
                }
                if (CommandTask.this.commandHandle != null) {
                    ((CommandTask)CommandTask.this).sender.callbackExecutor.execute(() -> CommandTask.this.commandHandle.onAck(ack, CommandTask.this));
                }
            }
            finally {
                CommandTask.this.lock.unlock();
            }
        }

        public void processResult(CommandResult result) {
            CommandTask.this.lock.lock();
            try {
                if (CommandTask.this.done) {
                    return;
                }
                CommandTask.this.done = true;
                if (CommandTask.this.timeoutTask != null) {
                    CommandTask.this.timeoutTask.cancel(false);
                }
                CommandTask.this.result = result.getResult();
                if (CommandTask.this.commandHandle != null) {
                    if (CommandTask.this.result instanceof Throwable) {
                        ((CommandTask)CommandTask.this).sender.callbackExecutor.execute(() -> CommandTask.this.commandHandle.onExecutionFailure((Throwable)CommandTask.this.result, CommandTask.this));
                    } else {
                        ((CommandTask)CommandTask.this).sender.callbackExecutor.execute(() -> CommandTask.this.commandHandle.onSuccess(CommandTask.this.result, CommandTask.this));
                    }
                }
                CommandTask.this.condition.signalAll();
            }
            finally {
                CommandTask.this.lock.unlock();
            }
        }
    }
}

