/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.agent.command;

import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.Agent;
import org.lsst.ccs.gconsole.agent.command.CommandHandle;
import org.lsst.ccs.gconsole.agent.command.CommandTask;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class CommandSender {
    final AgentMessagingLayer messenger;
    final Executor callbackExecutor;
    final Executor workerExecutor;
    final Scheduler timer;
    private volatile Duration defaultTimeout = Duration.ofSeconds(10L);
    private volatile CommandHandle defaultCommandHandle;

    public CommandSender(AgentMessagingLayer messenger, Executor callbackExecutor, Executor workerExecutor, Scheduler timer) {
        if (messenger == null) {
            messenger = Agent.getEnvironmentMessagingAccess();
        }
        this.messenger = messenger;
        if (callbackExecutor == null || workerExecutor == null) {
            ThreadFactory threadFactory = new ThreadFactory(){
                private final ThreadFactory delegate = Executors.defaultThreadFactory();

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = this.delegate.newThread(r);
                    thread.setDaemon(true);
                    return thread;
                }
            };
            if (callbackExecutor == null) {
                callbackExecutor = Executors.newSingleThreadExecutor(threadFactory);
            }
            if (workerExecutor == null) {
                workerExecutor = new ThreadPoolExecutor(0, 2, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
            }
        }
        this.callbackExecutor = callbackExecutor;
        this.workerExecutor = workerExecutor;
        this.timer = timer;
    }

    public void setTimeout(Duration defaultTimeout) {
        if (defaultTimeout == null) {
            throw new IllegalArgumentException("Illegal default timeout value: " + defaultTimeout);
        }
        this.defaultTimeout = defaultTimeout;
    }

    public void setCommandHandle(CommandHandle defaultCommandHandle) {
        this.defaultCommandHandle = defaultCommandHandle;
    }

    public CommandTask execute(CommandHandle handle, Duration timeout, String command, Object ... args) {
        if (handle == null) {
            handle = this.defaultCommandHandle;
        }
        if (timeout == null) {
            timeout = this.defaultTimeout;
        }
        CommandTask task = new CommandTask(this, handle, timeout, command, args);
        task.send();
        return task;
    }
}

