/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.utilities;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nom.tam.util.AsciiFuncs;

public final class FitsHeaderCardParser {
    private static final Pattern KEYWORD_PATTERN = Pattern.compile("([A-Z|a-z|0-9|_|-]+)([ |\\.]*=?)");
    private static final Pattern STRING_PATTERN = Pattern.compile("'((?:[^']+(?=')|'')*)'(?!')");

    private static String deleteQuotes(String quotedString) {
        int newLength;
        int indexOfQuote = quotedString.indexOf(39);
        if (indexOfQuote < 0) {
            int newLength2;
            for (newLength2 = quotedString.length(); newLength2 > 0 && AsciiFuncs.isWhitespace(quotedString.charAt(newLength2 - 1)); --newLength2) {
            }
            return quotedString.substring(0, newLength2);
        }
        int lastIndexOfQuote = 0;
        StringBuffer sb = new StringBuffer(quotedString.length());
        while (indexOfQuote >= 0) {
            sb.append(quotedString, lastIndexOfQuote, indexOfQuote);
            lastIndexOfQuote = indexOfQuote + 1;
            indexOfQuote = quotedString.indexOf(39, lastIndexOfQuote + 1);
        }
        sb.append(quotedString, lastIndexOfQuote, quotedString.length());
        for (newLength = sb.length(); newLength > 0 && AsciiFuncs.isWhitespace(sb.charAt(newLength - 1)); --newLength) {
        }
        sb.setLength(newLength);
        return sb.toString();
    }

    private static String extractComment(String stringCard, int startPosition) {
        int startOfComment = stringCard.indexOf(47, startPosition) + 1;
        if (startOfComment > 0 && stringCard.length() > startOfComment) {
            return stringCard.substring(startOfComment).trim();
        }
        return null;
    }

    public static String parseCardKey(String card) {
        int indexOfEquals = card.indexOf(61);
        StringBuilder builder = new StringBuilder();
        Matcher kewordMatcher = KEYWORD_PATTERN.matcher(card);
        while (kewordMatcher.find() && kewordMatcher.start() < indexOfEquals) {
            if (builder.length() != 0) {
                builder.append('.');
            }
            builder.append(kewordMatcher.group(1).toUpperCase(Locale.US));
            if (!kewordMatcher.group(2).endsWith("=")) continue;
            break;
        }
        return builder.toString();
    }

    public static ParsedValue parseCardValue(String card) {
        int indexOfEquals;
        ParsedValue value = FitsHeaderCardParser.parseStringValue(card);
        if (value == null && (indexOfEquals = card.indexOf(61)) > 0) {
            value = new ParsedValue();
            int endOfValue = card.length() - 1;
            int startOfComment = card.indexOf(47, indexOfEquals);
            if (startOfComment > 0) {
                endOfValue = startOfComment - 1;
                value.comment = FitsHeaderCardParser.extractComment(card, startOfComment);
            }
            value.value = card.substring(indexOfEquals + 1, endOfValue + 1).trim();
        }
        return value;
    }

    private static ParsedValue parseStringValue(String card) {
        Matcher matcher;
        int indexOfQuote = card.indexOf(39);
        if (indexOfQuote >= 0 && (matcher = STRING_PATTERN.matcher(card)).find(indexOfQuote) && card.lastIndexOf(47, matcher.start()) < 0) {
            return new ParsedValue(FitsHeaderCardParser.deleteQuotes(matcher.group(1)), FitsHeaderCardParser.extractComment(card, matcher.end()));
        }
        return null;
    }

    private FitsHeaderCardParser() {
    }

    public static class ParsedValue {
        private String comment;
        private final boolean isString;
        private String value = null;

        public ParsedValue() {
            this.isString = false;
        }

        public ParsedValue(String value, String comment) {
            this.isString = true;
            this.value = value;
            this.comment = comment;
        }

        public String getComment() {
            return this.comment;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isString() {
            return this.isString;
        }
    }
}

