/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.test;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import org.astrogrid.samp.ErrInfo;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.HubConnection;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.httpd.UtilServer;
import org.astrogrid.samp.test.TestException;
import org.astrogrid.samp.test.Tester;

public class Calculator
extends Tester
implements CallableClient {
    private final HubConnection connection_;
    private final Map callMap_;
    private final Random random_;
    private volatile int nCalc_;
    private volatile int nCall_;
    private static final String ADD_MTYPE = "calc.int.add";
    private static final String SUB_MTYPE = "calc.int.sub";
    private static final String MUL_MTYPE = "calc.int.mul";
    private static final String DIV_MTYPE = "calc.int.div";
    private static final Logger logger_ = Logger.getLogger(Calculator.class.getName());
    private static String iconUrl_;
    public static final SendMode NOTIFY_MODE;
    public static final SendMode ASYNCH_MODE;
    public static final SendMode SYNCH_MODE;
    public static final SendMode RANDOM_MODE;

    public Calculator(HubConnection connection, Random random) throws SampException {
        this.connection_ = connection;
        this.random_ = random;
        this.callMap_ = Collections.synchronizedMap(new HashMap());
        this.connection_.setCallable(this);
        Metadata meta = new Metadata();
        meta.setName("Calculator");
        meta.setDescriptionText("Rudimentary integer arithmetic application");
        String iconUrl = Calculator.getIconUrl();
        if (iconUrl != null) {
            meta.setIconUrl(iconUrl);
        }
        this.connection_.declareMetadata(meta);
        Subscriptions subs = new Subscriptions();
        subs.addMType(ADD_MTYPE);
        subs.addMType(SUB_MTYPE);
        subs.addMType(MUL_MTYPE);
        subs.addMType(DIV_MTYPE);
        this.connection_.declareSubscriptions(subs);
    }

    public void sendMessage(String receiverId, SendMode mode) throws SampException {
        mode.send(this, receiverId, this.createRandomRequest(), this.nextCall());
    }

    public int getSendCount() {
        return this.nCall_;
    }

    public int getReceiveCount() {
        return this.nCalc_;
    }

    public HubConnection getConnection() {
        return this.connection_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        try {
            Map map = this.callMap_;
            synchronized (map) {
                while (!this.callMap_.isEmpty()) {
                    this.callMap_.wait(100L);
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted");
        }
    }

    public void receiveNotification(String senderId, Message msg) {
        this.processCall(senderId, msg);
    }

    public void receiveCall(String senderId, String msgId, Message msg) throws SampException {
        Response response;
        try {
            response = Response.createSuccessResponse(this.processCall(senderId, msg));
        }
        catch (Throwable e) {
            response = Response.createErrorResponse(new ErrInfo(e));
        }
        this.connection_.reply(msgId, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveResponse(String senderId, String msgTag, Response response) {
        CalcRequest request;
        Map map = this.callMap_;
        synchronized (map) {
            request = (CalcRequest)this.callMap_.remove(msgTag);
        }
        request.checkResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map processCall(String senderId, Message msg) {
        String mtype = msg.getMType();
        if (ADD_MTYPE.equals(mtype) || SUB_MTYPE.equals(mtype) || MUL_MTYPE.equals(mtype) || DIV_MTYPE.equals(mtype)) {
            int x;
            Calculator calculator = this;
            synchronized (calculator) {
                ++this.nCalc_;
            }
            int a = SampUtils.decodeInt((String)msg.getParam("a"));
            int b = SampUtils.decodeInt((String)msg.getParam("b"));
            if (ADD_MTYPE.equals(mtype)) {
                x = a + b;
            } else if (SUB_MTYPE.equals(mtype)) {
                x = a - b;
            } else if (MUL_MTYPE.equals(mtype)) {
                x = a * b;
            } else if (DIV_MTYPE.equals(mtype)) {
                x = a / b;
            } else {
                throw new AssertionError();
            }
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("x", SampUtils.encodeInt(x));
            return result;
        }
        throw new TestException();
    }

    private synchronized int nextCall() {
        return ++this.nCall_;
    }

    private CalcRequest createRandomRequest() {
        String mtype = (new String[]{ADD_MTYPE, SUB_MTYPE, MUL_MTYPE, DIV_MTYPE})[this.random_.nextInt(4)];
        return new CalcRequest(mtype, this.random_.nextInt(1000), 500 + this.random_.nextInt(500));
    }

    private static String getIconUrl() {
        if (iconUrl_ == null) {
            URL url;
            String resource = "/org/astrogrid/samp/images/tinycalc.gif";
            try {
                url = UtilServer.getInstance().exportResource(resource);
            }
            catch (IOException e) {
                url = null;
                logger_.warning("Can't locate icon: " + resource);
            }
            iconUrl_ = url == null ? "" : url.toString();
        }
        return iconUrl_.length() > 0 ? iconUrl_ : null;
    }

    static {
        NOTIFY_MODE = new SendMode("notify"){

            void send(Calculator calc, String receiverId, CalcRequest request, int iseq) throws SampException {
                calc.connection_.notify(receiverId, request.getMessage());
            }
        };
        ASYNCH_MODE = new SendMode("sync"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void send(Calculator calc, String receiverId, CalcRequest request, int iseq) throws SampException {
                String msgTag = "tag-" + iseq;
                Map map = calc.callMap_;
                synchronized (map) {
                    calc.callMap_.put(msgTag, request);
                }
                calc.connection_.call(receiverId, msgTag, request.getMessage());
            }
        };
        SYNCH_MODE = new SendMode("async"){

            void send(Calculator calc, String receiverId, CalcRequest request, int iseq) throws SampException {
                Response response = calc.connection_.callAndWait(receiverId, request.getMessage(), 0);
                request.checkResponse(response);
            }
        };
        RANDOM_MODE = new SendMode("mixture"){
            private final SendMode[] otherModes = new SendMode[]{NOTIFY_MODE, ASYNCH_MODE, SYNCH_MODE};

            void send(Calculator calc, String receiverId, CalcRequest request, int iseq) throws SampException {
                this.otherModes[calc.random_.nextInt(this.otherModes.length)].send(calc, receiverId, request, iseq);
            }
        };
    }

    private class CalcRequest {
        private final int a_;
        private final int b_;
        private final String mtype_;
        private final int x_;

        public CalcRequest(String mtype, int a, int b) {
            this.mtype_ = mtype;
            this.a_ = a;
            this.b_ = b;
            if (Calculator.ADD_MTYPE.equals(mtype)) {
                this.x_ = a + b;
            } else if (Calculator.SUB_MTYPE.equals(mtype)) {
                this.x_ = a - b;
            } else if (Calculator.MUL_MTYPE.equals(mtype)) {
                this.x_ = a * b;
            } else if (Calculator.DIV_MTYPE.equals(mtype)) {
                this.x_ = a / b;
            } else {
                throw new IllegalArgumentException();
            }
        }

        public Message getMessage() {
            Message msg = new Message(this.mtype_);
            msg.addParam("a", SampUtils.encodeInt(this.a_));
            msg.addParam("b", SampUtils.encodeInt(this.b_));
            return msg;
        }

        public void checkResponse(Response response) {
            Tester.assertEquals("samp.ok", response.getStatus());
            Tester.assertEquals(this.x_, SampUtils.decodeInt((String)response.getResult().get("x")));
        }
    }

    public static abstract class SendMode {
        private final String name_;

        private SendMode(String name) {
            this.name_ = name;
        }

        abstract void send(Calculator var1, String var2, CalcRequest var3, int var4) throws SampException;

        public String toString() {
            return this.name_;
        }
    }
}

