/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.hub;

import java.util.Map;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Metadata;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.SampUtils;
import org.astrogrid.samp.Subscriptions;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.hub.ProfileToken;

public class HubClient
implements Client {
    private final String publicId_;
    private final ProfileToken profileToken_;
    private volatile Subscriptions subscriptions_;
    private volatile Metadata metadata_;
    private volatile CallableClient callable_;

    public HubClient(String publicId, ProfileToken profileToken) {
        this.publicId_ = publicId;
        this.profileToken_ = profileToken;
        this.subscriptions_ = new Subscriptions();
        this.metadata_ = new Metadata();
        this.callable_ = new NoCallableClient();
    }

    public String getId() {
        return this.publicId_;
    }

    public Metadata getMetadata() {
        return this.metadata_;
    }

    public Subscriptions getSubscriptions() {
        return this.subscriptions_;
    }

    public ProfileToken getProfileToken() {
        return this.profileToken_;
    }

    public void setMetadata(Map meta) {
        this.metadata_ = new Metadata(meta);
    }

    public void setSubscriptions(Map subs) {
        this.subscriptions_ = Subscriptions.asSubscriptions(subs);
    }

    public boolean isSubscribed(String mtype) {
        return this.isCallable() && this.subscriptions_.isSubscribed(mtype);
    }

    public Map getSubscription(String mtype) {
        return this.isCallable() ? this.subscriptions_.getSubscription(mtype) : null;
    }

    public void setCallable(CallableClient callable) {
        this.callable_ = callable == null ? new NoCallableClient() : callable;
    }

    public CallableClient getCallable() {
        return this.callable_;
    }

    public boolean isCallable() {
        return !(this.callable_ instanceof NoCallableClient);
    }

    public String toString() {
        return SampUtils.toString(this);
    }

    private class NoCallableClient
    implements CallableClient {
        private NoCallableClient() {
        }

        public void receiveNotification(String senderId, Message message) throws SampException {
            this.refuse();
        }

        public void receiveCall(String senderId, String msgId, Message message) throws SampException {
            this.refuse();
        }

        public void receiveResponse(String responderId, String msgId, Response response) throws SampException {
            this.refuse();
        }

        private void refuse() throws SampException {
            throw new SampException("Client " + HubClient.this.getId() + " is not callable");
        }
    }
}

