package org.lsst.ccs.subsystem.ccob.thin;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;

/**
 * Adds the AutoCloseable interface to {@code Ascii} so that it can be used in try-with-resources statements.
 * Also overrides {@code close()}.
 * @author tether
 */
public class AsciiAuto extends Ascii implements AutoCloseable {
    
    /**
     * Either does nothing or actually closes the connection. Which one depends on how you want to
     * manage connection lifetimes: open only during commands or open until subsystem shutdown.
     * @throws DriverException
     */
    @Override
    public void close() throws DriverException {
        // closeForReal(); // Only if we want to close after every use.
    }
    
    public void closeForReal() {closeSilent();}

}
